/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.logging.Logger;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.docx.ActionEnum;
import oracle.tutor.docx.Condition;
import oracle.tutor.docx.Directive;
import oracle.tutor.docx.Step;
import oracle.tutor.docx.Task;

public class Flow_Util {
    private Logger logger;
    private BusinessProcessDiagram bpd;

    public Flow_Util(BusinessProcessDiagram bpd, Logger logger) {
        this.bpd = bpd;
        this.logger = logger;
    }

    protected SequenceFlow getSFfromDirectiveAsNextStep_single(Step step, Condition cond, int conditions, int flowNum) {
        int flowNumber = flowNum;
        Boolean isEnd = cond.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY;
        Boolean isGoto = cond.getAction().getType() == ActionEnum.Type.GOTO;
        Boolean isReturnTo = cond.getAction().getType() == ActionEnum.Type.RETURN_TO;
        Boolean isStopAndComplete = cond.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE;
        SequenceFlow s = isStopAndComplete.booleanValue() ? new SequenceFlow("S" + flowNumber, "", (GraphicalElement)this.bpd.getNode(cond.getAction().getConnectorId()), (GraphicalElement)this.bpd.getNode(step.getNextStep().getNextStep().getId())) : (isGoto.booleanValue() || isReturnTo.booleanValue() ? (cond.getAction().getTargetStep() != null ? new SequenceFlow("S" + flowNumber, "", (GraphicalElement)this.bpd.getNode(step.getId()), (GraphicalElement)this.bpd.getNode(cond.getAction().getTargetStep().getId())) : new SequenceFlow("S" + flowNumber, "", (GraphicalElement)this.bpd.getNode(step.getId()), (GraphicalElement)this.bpd.getNode(cond.getAction().getLinkObject().getId()))) : new SequenceFlow("S" + flowNumber, "", (GraphicalElement)this.bpd.getNode(step.getId()), (GraphicalElement)this.bpd.getNode("E2")));
        cond.setFlowProcessed(true);
        return s;
    }

    protected SequenceFlow getSFfromDirectiveStep_single(Step currentStep, Step step, Condition cond, int conditions, int flowNum) {
        Boolean isEnd = cond.getAction().getType() == ActionEnum.Type.END_OF_ACTIVITY;
        Boolean isGoto = cond.getAction().getType() == ActionEnum.Type.GOTO;
        Boolean isReturnTo = cond.getAction().getType() == ActionEnum.Type.RETURN_TO;
        Boolean isStopAndComplete = cond.getAction().getType() == ActionEnum.Type.STOP_AND_COMPLETE;
        SequenceFlow s = isStopAndComplete.booleanValue() ? new SequenceFlow("S" + flowNum, "", (GraphicalElement)this.bpd.getNode(currentStep.getId()), (GraphicalElement)this.bpd.getNode(cond.getAction().getConnectorId())) : (isGoto.booleanValue() || isReturnTo.booleanValue() ? (cond.getAction().getTargetStep() != null ? new SequenceFlow("S" + flowNum, "", (GraphicalElement)this.bpd.getNode(currentStep.getId()), (GraphicalElement)this.bpd.getNode(cond.getAction().getTargetStep().getId())) : new SequenceFlow("S" + flowNum, "", (GraphicalElement)this.bpd.getNode(currentStep.getId()), (GraphicalElement)this.bpd.getNode(cond.getAction().getLinkObject().getId()))) : new SequenceFlow("S" + flowNum, "", (GraphicalElement)this.bpd.getNode(currentStep.getId()), (GraphicalElement)this.bpd.getNode("E2")));
        cond.setFlowProcessed(true);
        return s;
    }

    protected void setDocumentationFromTask(ConnectingObject flow, Step step) {
        String taskData = "";
        if (step instanceof Task) {
            taskData = ((Task)step).getTaskDataAsDocumentationString();
        } else if (step instanceof Directive) {
            for (Object c : ((Directive)step).getConditions()) {
                taskData = taskData + ((Condition)c).getSubStepDataAsDocumentationString();
            }
        }
        flow.setDocumentation(taskData);
    }

    protected void setDocumentationFromCondition(ConnectingObject flow, Condition c) {
        String data = c.getSubStepDataAsDocumentationString();
        if (data != null && data != "") {
            this.logger.info("Found condition data:\n" + data);
            flow.setDocumentation(data);
        }
    }
}

