/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.docx.Actor;
import oracle.tutor.docx.Directive;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.SubStepData;
import oracle.tutor.docx.Task;
import oracle.tutor.docx.TutorDoc;
import oracle.tutor.docx.Utils;

public class Bpd2TutorTaskUtil
extends Task {
    private Logger _logger;

    public Bpd2TutorTaskUtil(TutorDoc td, oracle.tutor.bpmn.Task o, int taskNum, Logger logger, LanguageMap lm) {
        this.setTaskString(o.getName());
        this.setTaskNumber(taskNum);
        this.setId("T_" + taskNum);
        this._logger = logger;
        String ds = o.getDocumentation().trim();
        Map attributes = o.getAttributes();
        this._logger.fine("ds contains: " + ds + ". ds.length is " + ds.length() + ". ds.equals(\"\") is " + ds.equals("") + " but ds == \"\" returns " + (ds == ""));
        try {
            ArrayList taskDataObjectsArray = td.utils.getTaskDataObjectListFromDocumentationString(ds);
            String system_screen_name = "";
            String system_app_name = "";
            String system_navigation = "";
            String upk_topic_url = "";
            String upk_topic_id = "";
            String upk_topic_name = "";
            HashMap<String, SubStepData> attrMap = new HashMap<String, SubStepData>();
            if (!attributes.isEmpty()) {
                SubStepData ssd;
                if (attributes.containsKey("SYSTEM_SCREEN_NAME") && !(system_screen_name = (String)attributes.get("SYSTEM_SCREEN_NAME")).isEmpty() && !system_screen_name.equals(null)) {
                    ssd = new SubStepData("BoxText", system_screen_name + "");
                    attrMap.put("SYSTEM_SCREEN_NAME", ssd);
                }
                if (attributes.containsKey("SYSTEM_APPLICATION") && !(system_app_name = (String)attributes.get("SYSTEM_APPLICATION")).isEmpty() && !system_app_name.equals(null)) {
                    ssd = new SubStepData("BoxText", system_app_name + "");
                    attrMap.put("SYSTEM_APPLICATION", ssd);
                }
                if (attributes.containsKey("SYSTEM_NAVIGATION") && !(system_navigation = (String)attributes.get("SYSTEM_NAVIGATION")).isEmpty() && !system_navigation.equals(null)) {
                    ssd = new SubStepData("BoxText", system_navigation + "");
                    attrMap.put("SYSTEM_NAVIGATION", ssd);
                }
                if (attributes.containsKey("UPK_TOPIC_URL") && !(upk_topic_url = (String)attributes.get("UPK_TOPIC_URL")).isEmpty() && !upk_topic_url.equals(null)) {
                    ssd = new SubStepData("Note1", upk_topic_url + "");
                    attrMap.put("UPK_TOPIC_URL", ssd);
                }
                if (attributes.containsKey("UPK_TOPIC_ID") && !(upk_topic_id = (String)attributes.get("UPK_TOPIC_ID")).isEmpty() && !upk_topic_id.equals(null)) {
                    ssd = new SubStepData("Note1", upk_topic_id + "");
                    attrMap.put("UPK_TOPIC_ID", ssd);
                }
                if (attributes.containsKey("UPK_TOPIC_NAME") && !(upk_topic_name = (String)attributes.get("UPK_TOPIC_NAME")).isEmpty() && !upk_topic_name.equals(null)) {
                    ssd = new SubStepData("Note1", upk_topic_name + "");
                    attrMap.put("UPK_TOPIC_NAME", ssd);
                }
            }
            this._logger.fine("taskDataObjectsArray has this many elements: " + taskDataObjectsArray.size());
            if (!ds.equals("") && taskDataObjectsArray.size() > 0) {
                this._logger.fine("data in ds and taskDataObjects > 0");
                int boxTextCounter = 0;
                for (Object dob : taskDataObjectsArray) {
                    if (!(dob instanceof SubStepData)) continue;
                    if (((SubStepData)dob).getStyleName().matches("BoxText")) {
                        Boolean same;
                        if (system_app_name != null && system_app_name != "" && boxTextCounter == 0) {
                            same = Utils.compareStrings(((SubStepData)dob).getDataString(), system_app_name);
                            if (same.booleanValue()) {
                                this.addTaskData((SubStepData)dob);
                                attrMap.remove("SYSTEM_APPLICATION");
                            } else {
                                ((SubStepData)dob).setDataString(system_app_name);
                                attrMap.remove("SYSTEM_APPLICATION");
                            }
                        } else if (system_navigation != null && system_navigation != "" && boxTextCounter == 1) {
                            same = Utils.compareStrings(((SubStepData)dob).getDataString(), system_navigation);
                            if (same.booleanValue()) {
                                this.addTaskData((SubStepData)dob);
                                attrMap.remove("SYSTEM_NAVIGATION");
                            } else {
                                ((SubStepData)dob).setDataString(system_navigation);
                                attrMap.remove("SYSTEM_NAVIGATION");
                            }
                        } else if (system_screen_name != null && system_screen_name != "" && boxTextCounter == 2) {
                            same = Utils.compareStrings(((SubStepData)dob).getDataString(), system_screen_name);
                            if (same.booleanValue()) {
                                this.addTaskData((SubStepData)dob);
                                attrMap.remove("SYSTEM_SCREEN_NAME");
                            } else {
                                ((SubStepData)dob).setDataString(system_screen_name);
                                attrMap.remove("SYSTEM_SCREEN_NAME");
                            }
                        } else {
                            this.addTaskData((SubStepData)dob);
                        }
                        ++boxTextCounter;
                        continue;
                    }
                    this.addTaskData((SubStepData)dob);
                }
            } else if (ds.equals("") && attrMap.size() > 0) {
                String d;
                this._logger.fine("ds is empty. attrMap.size() is " + attrMap.size());
                String upkLinkString = null;
                if (attrMap.containsKey("SYSTEM_SCREEN_NAME") && !(d = ((SubStepData)attrMap.get("SYSTEM_SCREEN_NAME")).getDataString()).equals("")) {
                    this.addTaskData((SubStepData)attrMap.get("SYSTEM_SCREEN_NAME"));
                }
                if (attrMap.containsKey("SYSTEM_APPLICATION") && !(d = ((SubStepData)attrMap.get("SYSTEM_APPLICATION")).getDataString()).equals("")) {
                    this.addTaskData((SubStepData)attrMap.get("SYSTEM_APPLICATION"));
                }
                if (attrMap.containsKey("SYSTEM_NAVIGATION") && !(d = ((SubStepData)attrMap.get("SYSTEM_NAVIGATION")).getDataString()).equals("")) {
                    this.addTaskData((SubStepData)attrMap.get("SYSTEM_NAVIGATION"));
                }
                if (attrMap.containsKey("UPK_TOPIC_NAME") && !(d = ((SubStepData)attrMap.get("UPK_TOPIC_NAME")).getDataString()).equals("")) {
                    upkLinkString = d + " ";
                }
                if (attrMap.containsKey("UPK_TOPIC_URL") && !(d = ((SubStepData)attrMap.get("UPK_TOPIC_URL")).getDataString()).equals("")) {
                    d = d.replaceAll("\\[", "");
                    d = d.replaceAll("\\]", "");
                    upkLinkString = upkLinkString + "[" + d;
                }
                if (attrMap.containsKey("UPK_TOPIC_ID") && !(d = ((SubStepData)attrMap.get("UPK_TOPIC_ID")).getDataString()).equals("")) {
                    d = d.replaceFirst("Guid=", "");
                    d = d.replaceFirst("guid=", "");
                    upkLinkString = upkLinkString + "Guid=" + d + "]";
                }
                this._logger.fine("So I need to send this as a subStepData string: " + upkLinkString);
                this.addTaskData(new SubStepData("Note1", upkLinkString));
            }
        }
        catch (Exception e) {
            logger.severe("getTaskData throws this error: " + e.getClass().getName() + " while trying to create a SubStepData object/n");
        }
        try {
            this.handlePrev_FollowStepsLists(o, lm);
        }
        catch (Exception e) {
            logger.severe("formatStepsLists throws this error: " + e.getClass().getName() + " while trying to populate the preceding and following list objects/n");
        }
        Actor a = new Actor();
        if (o.getLane() != null) {
            a.setTitle(o.getLane().getName());
        } else {
            a.setTitle("Unknown");
        }
        this.addActor(a);
    }

    private void handlePrev_FollowStepsLists(oracle.tutor.bpmn.Task t, LanguageMap lm) {
        if (t.getOutflows().size() > 1) {
            Integer currentTutorTask = (Integer)t.getAttribute("taskNumber");
            this._logger.fine("Current object is analogous to tutor task # " + currentTutorTask);
            int flowNum = 0;
            Directive d = new Directive(lm);
            for (ConnectingObject f : t.getOutflows()) {
                ConnectingObject outFlow;
                if (flowNum > 0 && (outFlow = f) instanceof SequenceFlow) {
                    String directiveString;
                    SequenceFlow flow = (SequenceFlow)outFlow;
                    String test = "";
                    Integer target = 0;
                    GraphicalElement targetObj = flow.getTo();
                    if (targetObj instanceof oracle.tutor.bpmn.Task) {
                        if (targetObj.getAttribute("taskNumber") != null) {
                            target = (Integer)targetObj.getAttribute("taskNumber");
                        }
                        if (flowNum == 1) {
                            directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target.toString());
                            d = new Directive(lm, directiveString);
                        } else {
                            directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target.toString());
                            d.addStackedCondition(directiveString);
                        }
                        this.addFollowingStep(d, false);
                    } else if (targetObj instanceof Event) {
                        Event myEvent = (Event)targetObj;
                        if (myEvent.getEventType().equals((Object)Event.EventType.END) && flowNum == 1) {
                            String directiveString2 = (String)lm.getFirstValue("End of activity");
                            d = new Directive(lm, directiveString2);
                        }
                    } else if (targetObj instanceof Subprocess) {
                        if (targetObj.getAttribute("taskNumber") != null) {
                            target = (Integer)targetObj.getAttribute("taskNumber");
                        }
                        if (flowNum == 1) {
                            directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Stop and complete", target.toString());
                            d = new Directive(lm, directiveString);
                        } else {
                            directiveString = Utils.formatLocalizedDirectiveString(lm, test, "Goto", target.toString());
                            d.addStackedCondition(directiveString);
                        }
                    } else if (targetObj instanceof Gateway) {
                        // empty if block
                    }
                }
                ++flowNum;
            }
        }
    }
}

