/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.xhb;

import java.io.IOException;
import java.io.Writer;
import oracle.bpm.lang.Str;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.TextArea;

public final class Text
extends Element {
    private boolean isSafeText = true;
    private String theText_d;
    public static final String WHITE_SPACE = "&nbsp;";
    private static final String TAG_NAME = "TEXT";
    static final long serialVersionUID = -5498793621815829199L;
    static final long serialCheck = -5614074468166866444L;

    public Text() {
        super(TAG_NAME, String.valueOf(System.currentTimeMillis()));
        this.setPlainText("");
    }

    public Text(String id) {
        super(TAG_NAME, id);
        this.setPlainText("");
    }

    public Text(String id, String text) {
        super(TAG_NAME, id);
        this.setText(text);
    }

    public void setPlainText(String text) {
        this.isSafeText = true;
        this.theText_d = text;
    }

    public void setText(String text) {
        this.isSafeText = false;
        this.theText_d = text;
    }

    public String getText() {
        return this.theText_d;
    }

    @Override
    public void writeHtmlText(Writer w) throws IOException {
        w.write(this.isSafeText ? this.theText_d : Str.convertToHTMLString((String)this.theText_d));
        Element parent = this.getParent();
        if (parent == null || !(parent instanceof TextArea)) {
            w.write("\n");
        }
    }

    @Override
    protected boolean hasCloseTag() {
        return false;
    }
}

