/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.xobject.runtime.ConversionUtilities;

public class XObjectValueResolver {
    private static final int DEFAULT_INT_VALUE = 0;
    private static final BigDecimal DEFAULT_DECIMAL_VALUE = new BigDecimal(0);
    private static final Double DEFAULT_REAL_VALUE = 0.0;
    private static final Time DEFAULT_TIME_VALUE = Time.now().roundDownToSeconds();
    private static final String DEFAULT_STRING_VALUE = "value";
    private static final Interval DEFAULT_INTERVAL_VALUE = new Interval();
    private static final Boolean DEFAULT_BOOLEAN_VALUE = Boolean.FALSE;

    public static <T> ValueResolver<T> getValueSetter(Class<T> clazz) {
        if (clazz == Integer.class) {
            return (ValueResolver)Cast.force((Object)new IntEditorValueSetter());
        }
        if (clazz == BigDecimal.class) {
            return (ValueResolver)Cast.force((Object)new DecimalEditorValueSetter());
        }
        if (clazz == Double.class) {
            return (ValueResolver)Cast.force((Object)new RealEditorValueSetter());
        }
        if (clazz == Interval.class) {
            return (ValueResolver)Cast.force((Object)new IntervalEditorValueSetter());
        }
        if (clazz == Time.class) {
            return (ValueResolver)Cast.force((Object)new TimeEditorValueSetter());
        }
        if (clazz == Boolean.class) {
            return (ValueResolver)Cast.force((Object)new BoolEditorValueSetter());
        }
        return (ValueResolver)Cast.force((Object)new StringEditorValueSetter());
    }

    public static <T> ValueResolver<T> getValueResolver(int kind) {
        return (ValueResolver)Cast.force(XObjectValueResolver.getValueSetter(XObjectValueResolver.classForKind(kind)));
    }

    public static <T> Class<T> classForKind(int kind) {
        switch (kind) {
            case 2: {
                return (Class)Cast.force(Integer.class);
            }
            case 3: {
                return (Class)Cast.force(BigDecimal.class);
            }
            case 4: {
                return (Class)Cast.force(Double.class);
            }
            case 7: {
                return (Class)Cast.force(Interval.class);
            }
            case 6: {
                return (Class)Cast.force(Time.class);
            }
            case 1: {
                return (Class)Cast.force(Boolean.class);
            }
        }
        return (Class)Cast.force(String.class);
    }

    public static class TimeEditorValueSetter
    extends ValueResolver.Default<Time> {
        @Override
        public Time getValueFromString(String textToSet) {
            if (Str.isEmpty((String)textToSet)) {
                return null;
            }
            try {
                return (Time)ConversionUtilities.fromString(textToSet, 6);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Time getNextValidValueFromList(List<Time> values) {
            Time value = this.getDefaultValue();
            while (values.contains(value)) {
                value = value.addMinutes(1L);
                value = value.addDays(1);
            }
            return value;
        }

        @Override
        public Time getDefaultValue() {
            return DEFAULT_TIME_VALUE;
        }
    }

    public static class StringEditorValueSetter
    extends ValueResolver.Default<String> {
        @Override
        public String getValueFromString(String textToSet) {
            if (Str.isEmpty((String)textToSet)) {
                return null;
            }
            return textToSet;
        }

        @Override
        public String getNextValidValueFromList(List<String> values) {
            String value = this.getDefaultValue();
            int count = 1;
            while (values.contains(value)) {
                value = this.getDefaultValue() + "" + count++;
            }
            return value;
        }

        @Override
        public String getDefaultValue() {
            return XObjectValueResolver.DEFAULT_STRING_VALUE;
        }
    }

    public static class RealEditorValueSetter
    extends ValueResolver.Default<Double> {
        @Override
        public Double getValueFromString(String textToSet) {
            try {
                return Double.valueOf(textToSet);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        @Override
        public Double getNextValidValueFromList(List<Double> values) {
            Double value = this.getDefaultValue();
            while (values.contains(value)) {
                Double d = value;
                Double d2 = value = Double.valueOf(value + 1.0);
            }
            return value;
        }

        @Override
        public Double getDefaultValue() {
            return DEFAULT_REAL_VALUE;
        }
    }

    public static class IntervalEditorValueSetter
    extends ValueResolver.Default<Interval> {
        @Override
        public Interval getValueFromString(String textToSet) {
            if (Str.isEmpty((String)textToSet)) {
                return null;
            }
            try {
                return IntervalFormat.getInstance().parse(textToSet);
            }
            catch (ParseException e) {
                try {
                    return Interval.valueOf((String)textToSet);
                }
                catch (FormatException e1) {
                    return null;
                }
            }
        }

        @Override
        public Interval getNextValidValueFromList(List<Interval> values) {
            Interval value = this.getDefaultValue();
            while (values.contains(value)) {
                value = value.addMinutes(1L);
            }
            return value;
        }

        @Override
        public Interval getDefaultValue() {
            return DEFAULT_INTERVAL_VALUE;
        }
    }

    public static class IntEditorValueSetter
    extends ValueResolver.Default<Integer> {
        @Override
        public Integer getValueFromString(String textToSet) {
            try {
                return Integer.valueOf(textToSet);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Integer getNextValidValueFromList(List<Integer> values) {
            int value = this.getDefaultValue();
            while (values.contains(value)) {
                ++value;
            }
            return value;
        }

        @Override
        public Integer getDefaultValue() {
            return 0;
        }
    }

    public static class DecimalEditorValueSetter
    extends ValueResolver.Default<BigDecimal> {
        @Override
        public BigDecimal getValueFromString(String textToSet) {
            try {
                return new BigDecimal(textToSet);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public BigDecimal getNextValidValueFromList(List<BigDecimal> values) {
            BigDecimal value = this.getDefaultValue();
            while (values.contains(value)) {
                value = new BigDecimal(value.intValue() + 1);
            }
            return value;
        }

        @Override
        public BigDecimal getDefaultValue() {
            return DEFAULT_DECIMAL_VALUE;
        }
    }

    public static class BoolEditorValueSetter
    extends ValueResolver.Default<Boolean> {
        @Override
        public Boolean getValueFromString(String textToSet) {
            return Boolean.valueOf(textToSet);
        }

        @Override
        public Boolean getNextValidValueFromList(List<Boolean> values) {
            Boolean value = this.getDefaultValue();
            return values.contains(value) ? !value.booleanValue() : value;
        }

        @Override
        public Boolean getDefaultValue() {
            return DEFAULT_BOOLEAN_VALUE;
        }
    }

    public static interface ValueResolver<E> {
        public E getValueFromString(String var1);

        public E getDefaultValue();

        public E getNextValidValueFromList(List<E> var1);

        public boolean typedEquals(String var1, String var2);

        public static class Default<E>
        implements ValueResolver<E> {
            @Override
            public E getValueFromString(String textToSet) {
                return null;
            }

            @Override
            public E getNextValidValueFromList(List<E> values) {
                return null;
            }

            @Override
            public E getDefaultValue() {
                return null;
            }

            @Override
            public boolean typedEquals(String valueA, String valueB) {
                E typedValueB;
                E typedValueA = this.getValueFromString(valueA);
                return typedValueA.equals(typedValueB = this.getValueFromString(valueB)) || typedValueA instanceof Comparable && ((Comparable)typedValueA).compareTo(typedValueB) == 0;
            }
        }
    }
}

