/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.lib.XYZDataSource;
import oracle.bpm.xobject.lib.chart.FusionChartXmlFactory;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYZComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XOXYZComponentDelegate
extends XOGraphicComponentDelegate {
    private String categoryLabel;
    private XOGraphicComponentDelegate.GraphicComponentInfo<XYZDataSource, XOXYZComponent> componentInfo;
    private String valueLabel;

    public XOXYZComponentDelegate(XOXYZComponent component) {
        super(component);
        XFormChart xChart = (XFormChart)component.getPresentationXMLObject();
        this.setCategoryLabel(xChart.getCategorylabel());
        this.setValueLabel(xChart.getValuelabel());
    }

    public final XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo() {
        XOXYZComponent chartComponent = (XOXYZComponent)this.component;
        XYZDataSource value = null;
        boolean hasError = false;
        String dataMethodInvocation = chartComponent.getDataMethodInvocation();
        try {
            value = (XYZDataSource)chartComponent.getXScreen().getXO().invokeMethod(dataMethodInvocation, null);
        }
        catch (Throwable t) {
            hasError = true;
            Throwable cause = t;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            Log.logWarning((Msg)XObjectRuntimeMsg.GRAPHIC_LOADING_ERROR(chartComponent.getId(), dataMethodInvocation, cause.getMessage()));
            Log.logDebug((Throwable)t);
        }
        chartComponent.setHasError(hasError);
        return this.getGraphicComponentInfo(value);
    }

    @Override
    public List<XOGraphicComponentDelegate.GraphicType> getGraphicTypes(Locale locale) {
        ArrayList<XOGraphicComponentDelegate.GraphicType> graphicTypes = new ArrayList<XOGraphicComponentDelegate.GraphicType>(8);
        List<GraphicType> list = GraphicType.getSubtypes("XYZ");
        for (GraphicType type : list) {
            graphicTypes.add(new XOGraphicComponentDelegate.GraphicType(type, locale));
        }
        return graphicTypes;
    }

    @Override
    public void recreateGraphic(XOGraphicComponentDelegate.GraphicComponentInfo info) {
    }

    public void setCategoryLabel(String value) {
        this.categoryLabel = this.component.getI18NText(value);
    }

    public void setValueLabel(String value) {
        this.valueLabel = this.component.getI18NText(value);
    }

    public String getCategoryLabel() {
        return this.categoryLabel;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    @Override
    void init() {
    }

    private XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo(XYZDataSource dataSource) {
        if (this.componentInfo == null) {
            this.componentInfo = new XOGraphicComponentDelegate.GraphicComponentInfo<XYZDataSource, XOXYZComponent>(dataSource, (XOXYZComponent)this.component){

                @Override
                public String getGraphicImageData() {
                    return FusionChartXmlFactory.getFusionChartData((XYZDataSource)this.getValue(), (XOXYZComponent)this.getComponent());
                }
            };
        } else {
            this.componentInfo.updateValue(dataSource);
        }
        return this.componentInfo;
    }
}

