/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.lib.XYDataSource;
import oracle.bpm.xobject.lib.chart.FusionChartXmlFactory;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XOXYComponentDelegate
extends XOGraphicComponentDelegate {
    private XOGraphicComponentDelegate.GraphicComponentInfo<XYDataSource, XOXYComponent> componentInfo;

    public XOXYComponentDelegate(XOXYComponent component) {
        super(component);
    }

    public final XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo() {
        XOXYComponent chartComponent = (XOXYComponent)this.component;
        XYDataSource value = null;
        boolean hasError = false;
        String dataMethodInvocation = chartComponent.getDataMethodInvocation();
        try {
            value = (XYDataSource)chartComponent.getXScreen().getXO().invokeMethod(dataMethodInvocation, null);
        }
        catch (Throwable t) {
            hasError = true;
            Throwable cause = t;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            Log.logWarning((Msg)XObjectRuntimeMsg.GRAPHIC_LOADING_ERROR(chartComponent.getId(), dataMethodInvocation, cause.getMessage()));
            Log.logDebug((Throwable)t);
        }
        chartComponent.setHasError(hasError);
        return this.getGraphicComponentInfo(value);
    }

    @Override
    public List<XOGraphicComponentDelegate.GraphicType> getGraphicTypes(Locale locale) {
        ArrayList<XOGraphicComponentDelegate.GraphicType> graphicTypes = new ArrayList<XOGraphicComponentDelegate.GraphicType>(2);
        List<GraphicType> list = GraphicType.getSubtypes("XY");
        for (GraphicType type : list) {
            graphicTypes.add(new XOGraphicComponentDelegate.GraphicType(type, locale));
        }
        return graphicTypes;
    }

    @Override
    public void recreateGraphic(XOGraphicComponentDelegate.GraphicComponentInfo info) {
    }

    @Override
    void init() {
    }

    private XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo(XYDataSource dataSource) {
        if (this.componentInfo == null) {
            this.componentInfo = new XOGraphicComponentDelegate.GraphicComponentInfo<XYDataSource, XOXYComponent>(dataSource, (XOXYComponent)this.component){

                @Override
                public String getGraphicImageData() {
                    return FusionChartXmlFactory.getFusionChartData((XYDataSource)this.getValue(), (XOXYComponent)this.getComponent());
                }
            };
        } else {
            this.componentInfo.updateValue(dataSource);
        }
        return this.componentInfo;
    }
}

