/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XOInputComponentDelegate {
    private XOInputComponent component_d;
    private int kind = -1001;
    private int length = -1001;
    private int precision = -1001;
    private static final int NON_INIT_VALUE = -1001;

    public XOInputComponentDelegate(XOInputComponent component) {
        this.component_d = component;
        this.init();
    }

    public Object getDefaultValue() {
        return null;
    }

    public int getKind() {
        try {
            if (this.kind == -1001) {
                this.kind = this.component_d.getXScreen().getXO().getAttributeKind(this.component_d.getPresentationXMLObject().getReference());
            }
            return this.kind;
        }
        catch (InvalidXOAttributeException e) {
            return -1;
        }
    }

    public int getLength() {
        try {
            if (this.length == -1001) {
                this.length = this.component_d.getXScreen().getXO().getAttributeLength(this.component_d.getPresentationXMLObject().getReference());
            }
            return this.length;
        }
        catch (InvalidXOAttributeException e) {
            return -1;
        }
    }

    public int getPrecision() {
        try {
            if (this.precision == -1001) {
                this.precision = this.component_d.getXScreen().getXO().getAttributePrecision(this.component_d.getPresentationXMLObject().getReference());
            }
            return this.precision;
        }
        catch (InvalidXOAttributeException e) {
            return -1;
        }
    }

    public Object getValue() {
        try {
            return this.component_d.getXScreen().getXO().getAttributeValue(this.component_d.getReference());
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_GET_VALUE_PROBLEM(this.component_d.getId(), e.getLocalizedMessage()));
            if (Log.isDebugging()) {
                Log.logDebug((Throwable)((Object)e));
            }
            return null;
        }
    }

    public void applyRestrictions() {
        int kind = this.component_d.getKind();
        this.component_d.restrictType(kind);
        switch (kind) {
            case 3: 
            case 4: {
                int precision = this.component_d.getPrecision();
                if (precision <= 0) break;
                this.component_d.restrictPrecision(precision);
                break;
            }
            case 5: {
                int length = this.component_d.getLength();
                if (length <= 0) break;
                this.component_d.restrictLength(length);
                break;
            }
            case 6: {
                if (!(this.component_d instanceof XODateTimeComponent)) break;
                ((XODateTimeComponent)((Object)this.component_d)).restrict(this.component_d.getPrecision(), this.isAbsoluteTime());
            }
        }
    }

    public final boolean refreshPresentationValue(boolean force) {
        XObjectInstance xo = this.component_d.getXScreen().getXO();
        String dataId = this.component_d.getReference();
        if (dataId != null && (force || xo.isDirty(dataId))) {
            Object value = null;
            try {
                value = xo.getAttributeValue(dataId);
            }
            catch (InvalidXOAttributeException e) {
                Log.logWarning((Throwable)((Object)e));
            }
            this.component_d.setValue(value);
            this.component_d.getXScreen().fireChangeEvent(this.component_d.getId());
            return true;
        }
        return false;
    }

    public void restrictLength(int length) {
    }

    public void restrictPrecision(int precision) {
    }

    public void restrictType(int kind) {
    }

    private boolean isAbsoluteTime() {
        boolean result;
        try {
            result = this.component_d.getXScreen().getRuntimeManager().getXObject().isAbsoluteTime(this.component_d.getPresentationXMLObject().getReference());
        }
        catch (InvalidXOAttributeException e) {
            result = false;
        }
        catch (IllegalArgumentException e) {
            result = false;
        }
        return result;
    }

    private void init() {
    }
}

