/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.util.List;
import java.util.Locale;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponent;

public abstract class XOGraphicComponentDelegate {
    protected XOGraphicComponent component;

    public XOGraphicComponentDelegate(XOGraphicComponent component) {
        this.component = component;
        this.init();
    }

    public abstract List<GraphicType> getGraphicTypes(Locale var1);

    public abstract void recreateGraphic(GraphicComponentInfo var1);

    abstract void init();

    public static final class GraphicType {
        oracle.bpm.xobject.lib.chart.GraphicType graphicType;
        Locale locale;

        public GraphicType(oracle.bpm.xobject.lib.chart.GraphicType graphicType, Locale locale) {
            this.graphicType = graphicType;
            this.locale = locale;
        }

        public oracle.bpm.xobject.lib.chart.GraphicType getGraphicType() {
            return this.graphicType;
        }

        public String getGraphicTypeDescription() {
            return this.graphicType.getString(this.locale);
        }
    }

    public static class GraphicEvent {
        private boolean back;
        private Object category;
        private Object series;
        private int x;
        private int y;

        public GraphicEvent() {
            this(false);
        }

        public GraphicEvent(boolean back) {
            this(-1, -1, back);
        }

        public GraphicEvent(int x, int y) {
            this(x, y, false);
        }

        public GraphicEvent(Object category, Object series) {
            this(false);
            this.category = category;
            this.series = series;
        }

        public GraphicEvent(int x, int y, boolean back) {
            this.x = x;
            this.y = y;
            this.back = back;
        }

        public Object[] getArgs(int argType) {
            Object[] args = null;
            if (argType > 0) {
                args = new Object[argType];
                args[0] = this.category;
                if (argType > 1) {
                    args[1] = this.series;
                }
            }
            return args;
        }

        public boolean isBack() {
            return this.back;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        void setBack(boolean back) {
            this.back = back;
        }
    }

    public static abstract class GraphicComponentInfo<K, C> {
        private C component;
        private K value;

        GraphicComponentInfo(K value, C component) {
            this.value = value;
            this.component = component;
        }

        public abstract String getGraphicImageData();

        public K getValue() {
            return this.value;
        }

        public void updateValue(K value) {
            this.value = value;
        }

        public C getComponent() {
            return this.component;
        }
    }

    public static interface GraphicListener {
        public void mouseClicked(GraphicEvent var1);
    }
}

