/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Str;
import oracle.bpm.util.StackTrace;

public class ServletUtils {
    private static final String JSP = ".JSP";

    public static URL getResource(ServletContext context, String resource) throws IOException {
        if (resource == null) {
            throw new FileNotFoundException("resource was null");
        }
        if (resource.endsWith("/") || resource.endsWith(".") || resource.endsWith("\\")) {
            throw new MalformedURLException("Path must not end with a slash or dot");
        }
        String upperResource = resource.toUpperCase();
        if (upperResource.startsWith("/META-INF") || upperResource.startsWith("/WEB-INF")) {
            throw new MalformedURLException("Path must not begin with /WEB-INF or /META-INF");
        }
        if (upperResource.endsWith(JSP)) {
            throw new MalformedURLException("Path must not end with .jsp");
        }
        URL url = context.getResource(resource);
        if (url == null) {
            throw new FileNotFoundException("Requested resource  (" + resource + ") was null");
        }
        return url;
    }

    public static String getStackTraceAsString(Throwable t) {
        return StackTrace.getStackTrace((Throwable)t);
    }

    public static void main(String[] args) {
        int delim = 44;
        String[] arr = new String[]{"", "\"Hi, matt\"", "\"como\\ andamio\"", "", "todo bien\\n", "y vos,,", null, ""};
        for (int i = 0; i < arr.length; ++i) {
            System.out.println("Data:");
            System.out.println("token[" + i + "] = " + arr[i]);
        }
        System.out.println("Testing join(\"" + arr + "\", '" + ',' + "')");
        String joinTest = Str.join((String[])arr, (char)',');
        System.out.println("Result");
        System.out.println(joinTest);
        System.out.println();
        System.out.println();
        System.out.println("Testing split(\"" + joinTest + "\", '" + ',' + "')");
        String[] result = Str.split((String)joinTest, (char)',', (boolean)true);
        for (int i = 0; i < result.length; ++i) {
            System.out.println("Result");
            System.out.println("token[" + i + "] = " + result[i]);
        }
        String joinTest2 = Str.join((String[])result, (char)',');
        System.out.println("Result");
        System.out.println(joinTest2);
        String test3 = ",Hol\\a mat\\eo,com\\,o \\estas,test,test,todo,, bien,";
        System.out.println("Testing split3(\",Hol\\a mat\\eo,com\\,o \\estas,test,test,todo,, bien,\", ',')");
        String[] result3 = Str.split((String)",Hol\\a mat\\eo,com\\,o \\estas,test,test,todo,, bien,", (char)',', (boolean)true);
        for (int i = 0; i < result3.length; ++i) {
            System.out.println("token[" + i + "] = " + result3[i]);
        }
        String test4 = ",Hol\\a \"mat\\eo,com\\\",o \\estas,\"test,test\",todo,, bien,";
        System.out.println("Testing split4(\",Hol\\a \"mat\\eo,com\\\",o \\estas,\"test,test\",todo,, bien,\", ',')");
        String[] result4 = Str.split((String)",Hol\\a \"mat\\eo,com\\\",o \\estas,\"test,test\",todo,, bien,", (char)',', (boolean)true);
        for (int i = 0; i < result4.length; ++i) {
            System.out.println("token[" + i + "] = " + result4[i]);
        }
        String test5 = ",Hol\\a mat\\eo,com\\,o \\estas,test,test,todo,, bien,";
        System.out.println("Testing false split5(\",Hol\\a mat\\eo,com\\,o \\estas,test,test,todo,, bien,\", ',')");
        String[] result5 = Str.split((String)",Hol\\a mat\\eo,com\\,o \\estas,test,test,todo,, bien,", (char)',', (boolean)false);
        for (int i = 0; i < result5.length; ++i) {
            System.out.println("token[" + i + "] = " + result5[i]);
        }
        String test6 = ",Hol\\a \"mat\\eo,com\\\",o \\estas,\"test,test\",todo,, bien,";
        System.out.println("Testing false split6(\",Hol\\a \"mat\\eo,com\\\",o \\estas,\"test,test\",todo,, bien,\", ',')");
        String[] result6 = Str.split((String)",Hol\\a \"mat\\eo,com\\\",o \\estas,\"test,test\",todo,, bien,", (char)',', (boolean)false);
        for (int i = 0; i < result6.length; ++i) {
            System.out.println("token[" + i + "] = " + result6[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnFile(String filename, OutputStream out) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(filename);
        try {
            StreamUtils.copy((InputStream)fis, (OutputStream)out);
        }
        finally {
            fis.close();
        }
    }

    public static void returnURL(URL url, OutputStream out) throws IOException {
        StreamUtils.copy((InputStream)url.openStream(), (OutputStream)out);
    }

    public static void returnURL(URL url, PrintWriter out) throws IOException {
        int charsRead;
        URLConnection con = url.openConnection();
        con.connect();
        String encoding = con.getContentEncoding();
        BufferedReader in = encoding == null ? new BufferedReader(new InputStreamReader(url.openStream())) : new BufferedReader(new InputStreamReader(url.openStream(), encoding));
        char[] buf = new char[4096];
        while ((charsRead = in.read(buf)) != -1) {
            out.write(buf, 0, charsRead);
        }
    }

    public static String toEncodedString(Properties args) {
        StringBuffer buf;
        block3: {
            buf = new StringBuffer();
            Enumeration<?> names = args.propertyNames();
            String encoding = "UTF-8";
            try {
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = args.getProperty(name);
                    buf.append(URLEncoder.encode(name, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                    if (!names.hasMoreElements()) continue;
                    buf.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Encoding: UTF-8 not found.");
            }
        }
        return buf.toString();
    }
}

