/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.log.Log;
import oracle.bpm.xobject.Utilities;
import oracle.bpm.xobject.presentationmodel.XFormMultilinetext;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextAreaComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextAreaComponentDelegate;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.PRE;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobject.xhb.TextArea;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLTextArea
extends HTMLInputElement
implements XOTextAreaComponent {
    private final int cols;
    private final XOTextAreaComponentDelegate componentDelegate;
    private PRE nonEditablePRE;
    private Table nonEditableTableContainer;
    private Text nonEditableText;
    private TextArea textArea;

    public HTMLTextArea(XScreen xScreen, XFormMultilinetext t) {
        super(xScreen, (XFormUserInputPresentationXMLObject)t);
        this.cols = t.colqty;
        this.initTextArea();
        this.componentDelegate = new XOTextAreaComponentDelegate(this);
    }

    public static HTMLTextArea newInstance(HTMLTextArea originalElement) {
        HTMLTextArea newElement = new HTMLTextArea(originalElement.getXScreen(), (XFormMultilinetext)originalElement.getPresentationXMLObject());
        newElement.setValue(originalElement.getDefaultValue());
        return newElement;
    }

    @Override
    public String getElementHtmlId() {
        return this.textArea.getAttribute(Element.ID_PROPERTY);
    }

    @Override
    public void setName(String name) {
        if (this.textArea != null) {
            this.textArea.setName(name);
            this.textArea.setHtmlId(name);
        }
    }

    @Override
    public Element getPureElement() {
        if (this.isEditable()) {
            return this.textArea;
        }
        return this.nonEditableTableContainer;
    }

    @Override
    public String getStyle() {
        XFormMultilinetext xTextArea = (XFormMultilinetext)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xTextArea.fonttype, xTextArea.getFontStyle(), xTextArea.fontsize));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
            if (this.isEditable()) {
                css.append(this.getInlineBorderCSS(xTextArea.borderstyle, xTextArea.bordercolor, xTextArea.borderwidth));
            }
        }
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.textArea != null) {
            this.textArea.setTabindex(String.valueOf(tabIndex));
        }
    }

    @Override
    public void setValue(Object value) {
        block3: {
            try {
                String valueStr = this.componentDelegate.convertToString(value);
                if (valueStr != null) {
                    this.textArea.setText(valueStr);
                    String wrappedText = Utilities.wrapText(valueStr, this.cols, this.getXScreen().getRuntimeManager().getLocale());
                    this.nonEditableText.setText(wrappedText);
                }
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                if (!Log.isDebugging()) break block3;
                Log.logDebug((Throwable)e);
            }
        }
    }

    @Override
    public Object clone() {
        return HTMLTextArea.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        this.textArea.setStyle(style);
        this.nonEditablePRE.setStyle(style);
        if (this.isCssEnabled()) {
            this.textArea.setCssClass(this.getCssClassName());
            this.nonEditablePRE.setCssClass(this.getCssClassName());
        } else {
            this.textArea.setCssClass("");
            this.nonEditablePRE.setCssClass("");
        }
    }

    @Override
    void _setOnFocus(String js) {
        this.textArea.setOnFocus(js);
    }

    void addValueChangeEvent(String script) {
        if (this.textArea != null) {
            this.textArea.setOnChange(script);
        }
    }

    private void initEditableTextArea() {
        XFormMultilinetext xMultiline = (XFormMultilinetext)this.getPresentationXMLObject();
        this.textArea = new TextArea(this.getHtmlAttString());
        this.textArea.setName(this.getHtmlAttString());
        this.textArea.setHtmlId(this.getHtmlAttString());
        this.textArea.setCols(String.valueOf(xMultiline.getColqty()));
        this.textArea.setRows(String.valueOf(xMultiline.getLineqty()));
        this.textArea.setTabindex(String.valueOf(this.getTabindex()));
        if (!this.isPreview()) {
            this.textArea.setOnChange("valueChanged(this.name, " + (xMultiline.getOnChange() != null) + ')');
        }
    }

    private void initNonEditableTextArea() {
        this.nonEditableTableContainer = new Table();
        TR nonEditableTR = new TR();
        TD nonEditableTD = new TD();
        this.nonEditablePRE = new PRE();
        this.nonEditableText = new Text();
        this.nonEditablePRE.addChild(this.nonEditableText);
        nonEditableTD.addChild(this.nonEditablePRE);
        nonEditableTR.addChild(nonEditableTD);
        this.nonEditableTableContainer.addChild(nonEditableTR);
    }

    private void initTextArea() {
        this.initEditableTextArea();
        this.initNonEditableTextArea();
        this.applyStyle();
        this.applyFocusPersistence();
    }
}

