/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormCheck;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormDatetimepiker;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormIframe;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormInterval;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormMultilinetext;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormRadio;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.runtime.ErrorListener;
import oracle.bpm.xobject.runtime.ExecutionListener;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XObjectGroupRowInstance;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XObjectRuntimeInternalException;
import oracle.bpm.xobject.runtime.html.HTMLRow;
import oracle.bpm.xobject.runtime.html.PresentationProcessing;
import oracle.bpm.xobject.runtime.html.UrlBuilder;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XOContainerComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;

public class HTMLPresentationBuilder
extends XORuntimeManager {
    private final Listener listener;
    private final XFormPresentationModel model;

    private HTMLPresentationBuilder(Object xo, XFormPresentationModel model, Locale locale, TimeZone tZone, Listener listener) throws ComponentExecutionException {
        super(null, xo, model.getPresentationName(), 11, locale, tZone);
        this.listener = listener;
        this.model = model;
    }

    private HTMLPresentationBuilder(XObjectInstance xo, XFormPresentationModel model, Locale locale, TimeZone tZone, Listener listener) throws ComponentExecutionException {
        super(xo, model.getPresentationName(), 11, locale, tZone);
        this.listener = listener;
        this.model = model;
    }

    public static XScreenHTMLImpl buildEditorScreen(XFormPresentationModel model, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        return HTMLPresentationBuilder.buildEditorScreen(model, locale, tZone, null);
    }

    public static XScreenHTMLImpl buildEditorScreen(XFormPresentationModel model, Locale locale, TimeZone tZone, Listener listener) throws ComponentExecutionException {
        HTMLPresentationBuilder manager = new HTMLPresentationBuilder((XObjectInstance)new XObjectInstanceMockObject((XObjectTypeDescription)model.getOwner()), model, locale, tZone, listener);
        return HTMLPresentationBuilder.buildPreviewScreen(manager, 4);
    }

    public static XScreenHTMLImpl buildPreviewScreen(XFormPresentationModel model, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        return HTMLPresentationBuilder.buildPreviewScreen(model, locale, tZone, null);
    }

    public static XScreenHTMLImpl buildPreviewScreen(XFormPresentationModel model, Locale locale, TimeZone tZone, Listener listener) throws ComponentExecutionException {
        HTMLPresentationBuilder manager = new HTMLPresentationBuilder((XObjectInstance)new XObjectInstanceMockObject((XObjectTypeDescription)model.getOwner()), model, locale, tZone, listener);
        return HTMLPresentationBuilder.buildPreviewScreen(manager, 2);
    }

    public static XScreenHTMLImpl buildPreviewScreen(Object xo, XFormPresentationModel model, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        return HTMLPresentationBuilder.buildPreviewScreen(xo, model, locale, tZone, null);
    }

    public static XScreenHTMLImpl buildPreviewScreen(Object xo, XFormPresentationModel model, Locale locale, TimeZone tZone, Listener listener) throws ComponentExecutionException {
        HTMLPresentationBuilder manager = new HTMLPresentationBuilder(xo, model, locale, tZone, listener);
        return HTMLPresentationBuilder.buildPreviewScreen(manager, 2);
    }

    @Override
    public XFormPresentationModel getCurrentPModel() throws XObjectRuntimeInternalException {
        return this.model;
    }

    private static XScreenHTMLImpl buildPreviewScreen(HTMLPresentationBuilder builder, int screenType) throws ComponentExecutionException {
        builder.setUrlBuilder(new UrlBuilder(){

            protected String urlImage(String component, String action) {
                return this.urlForAction(component, action);
            }

            @Override
            protected String urlForAction(String component, String action) {
                return "";
            }

            @Override
            protected String urlForDynamicImage(String component, String action) {
                return "";
            }

            @Override
            protected String urlForStaticImage(String component, String action) {
                return "";
            }
        });
        builder.setShowOption(screenType);
        builder.makeXScreen(null, null);
        return (XScreenHTMLImpl)builder.getXScreen();
    }

    private void makeXScreen(ExecutionListener dl, ErrorListener el) throws ComponentExecutionException {
        ManagerPresentationProcessing presentationProcessing = new ManagerPresentationProcessing(this, this.listener);
        this.setXScreen(presentationProcessing.process());
    }

    private static class XObjectInstanceMockObject
    extends XObjectInstance {
        private static final long serialVersionUID = -5273698888917681846L;

        public XObjectInstanceMockObject() {
        }

        public XObjectInstanceMockObject(XObjectTypeDescription objectType) throws ComponentExecutionException {
            this.setObjectType((ObjectTypeDescription)objectType);
        }

        public XObjectInstanceMockObject(Object instance, ObjectTypeDescription objectType) throws ComponentExecutionException {
            super(instance);
            this.setObjectType(objectType);
        }

        @Override
        public int getGroupSize(String groupName) throws InvalidXOAttributeException {
            return 1;
        }

        @Override
        public final XObjectGroupRowInstance getGroupXObjectInstance(String groupDataId, int index) throws InvalidXOAttributeException {
            ObjectTypeDescription groupType = this.objectType.findMember(groupDataId).getResultType().getElementType().asObject();
            XObjectGroupRowInstance groupInstance = super.getGroupXObjectInstance(groupDataId, index);
            groupInstance.setObjectType(groupType);
            return groupInstance;
        }

        @Override
        public String getI18NResource(String key, Locale locale) {
            String result = this.objectType == null ? null : ((XObjectTypeDescription)this.objectType).getResource(key, locale);
            return result != null ? result : key;
        }

        protected void initObjectType() {
        }
    }

    private static class ManagerPresentationProcessing
    extends PresentationProcessing {
        Listener listener;

        private ManagerPresentationProcessing(HTMLPresentationBuilder manager, Listener listener) {
            super(manager);
            this.listener = listener;
        }

        @Override
        protected void buildPresentation(XFormTable t) {
            super.buildPresentation(t);
            this.notify(null);
        }

        @Override
        protected XOPresentationComponent initButtonComponent(XFormButton b) {
            XOPresentationComponent comp = super.initButtonComponent(b);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initCheckComponent(XFormCheck ck) {
            XOPresentationComponent comp = super.initCheckComponent(ck);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initComboComponent(XFormCombo xCombo) {
            XOPresentationComponent comp = super.initComboComponent(xCombo);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initDateTimePickerComponent(XFormDatetimepiker date) {
            XOPresentationComponent comp = super.initDateTimePickerComponent(date);
            String dataId = date.getReference();
            if (dataId != null && this.getXScreen().getXO().hasAttribute(dataId)) {
                ((XOInputComponent)comp).applyRestrictions();
            } else {
                int datePresition = 2;
                ((XODateTimeComponent)((Object)comp)).restrict(datePresition, false);
            }
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initGaugeComponent(XFormGauge xGauge) {
            XOPresentationComponent comp = super.initGaugeComponent(xGauge);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initGroupComponent(XFormArray array) {
            XOPresentationComponent comp = super.initGroupComponent(array);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initIFrameComponent(XFormIframe xIframe) {
            XOPresentationComponent comp = super.initIFrameComponent(xIframe);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initImageComponent(XFormImage i) {
            XOPresentationComponent comp = super.initImageComponent(i);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initIntervalComponent(XFormInterval interval) {
            XOPresentationComponent comp = super.initIntervalComponent(interval);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initLabelComponent(XFormLabel l) {
            XOPresentationComponent comp = super.initLabelComponent(l);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initLinkComponent(XFormLink l) {
            XOPresentationComponent comp = super.initLinkComponent(l);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initRadioComponent(XFormRadio r) {
            XOPresentationComponent comp = super.initRadioComponent(r);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initRepeatableSection(XFormRepeatablesection xrepeatableSection) {
            XOPresentationComponent comp = super.initRepeatableSection(xrepeatableSection);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initTableComponent(XFormTable t, XOGroupComponent group) {
            XOPresentationComponent comp = super.initTableComponent(t, group);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initTextAreaComponent(XFormMultilinetext mt) {
            XOPresentationComponent comp = super.initTextAreaComponent(mt);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initTextfieldComponent(XFormText t) {
            XOPresentationComponent comp = super.initTextfieldComponent(t);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initXYComponent(XFormPie xPie) {
            XOPresentationComponent comp = super.initXYComponent(xPie);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initXYZComponent(XFormChart xChart) {
            XOPresentationComponent comp = super.initXYZComponent(xChart);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initCellComponent(HTMLRow row, XFormCell xcell, XOGroupComponent group) {
            XOPresentationComponent comp = super.initCellComponent(row, xcell, group);
            this.notify(comp);
            return comp;
        }

        @Override
        protected XOPresentationComponent initRowComponent(XOContainerComponent table, XFormRow row, XOGroupComponent group) {
            XOPresentationComponent comp = super.initRowComponent(table, row, group);
            this.notify(comp);
            return comp;
        }

        private void notify(XOPresentationComponent comp) {
            if (this.listener != null) {
                this.listener.initComponent(comp);
            }
        }
    }

    public static interface Listener {
        public void initComponent(XOPresentationComponent var1);
    }
}

