/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.DateFormatSymbolUtils;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xobject.presentationmodel.XFormBackground;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XObjectRuntimeInternalException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLContainerElement;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.html.HTMLImage;
import oracle.bpm.xobject.runtime.html.UrlBuilder;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;
import oracle.bpm.xobject.runtime.presentationComponents.XOPageComponent;
import oracle.bpm.xobject.xhb.COL;
import oracle.bpm.xobject.xhb.ColGroup;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Form;
import oracle.bpm.xobject.xhb.IMG;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.Script;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLPage
extends HTMLContainerElement
implements XOPageComponent {
    private String bgColor;
    private String bgImgAttach;
    private String bgImgLayout;
    private String bgImgXPosition;
    private String bgImgYPosition;
    private String cssStyle;
    private String docId;
    private Form form;
    private boolean hasDateElement;
    private boolean hasGraphicElement;
    private HTMLImage.ImageInfo imageInfo;
    private boolean isCalendarStyleInit;
    private boolean isJsInit;
    private DIV jsContainerDiv;
    private String jsContextPath = "../js/";
    private DIV mainContainerDiv;
    private Table table;
    private TD td;
    private static String jsPortalDir;
    public static final String FORM_NAME = "xobjectForm";
    public static final String SUBMIT_HANDLER = "xoSubmitHandler";
    public static final String RESET_HANDLER = "xoResetHandler";
    public static final int MSG_TYPE_ERROR = 0;
    public static final int MSG_TYPE_CLIENT_ERROR = 1;
    public static final int MSG_TYPE_SERVER_ERROR = 2;
    public static final int MSG_TYPE_WARNING = 3;

    public HTMLPage(String bgColor, String docId, XScreen xScreen) {
        this(xScreen, docId);
        if (bgColor != null) {
            this.setPageBackgroundColor(bgColor);
        }
    }

    private HTMLPage(XScreen xScreen, String docId) {
        super(xScreen, null);
        this.docId = docId;
        this.initPage();
    }

    public static HTMLPage newInstance(HTMLPage originalElement) {
        return new HTMLPage(originalElement.bgColor, originalElement.docId, originalElement.getXScreen());
    }

    @Override
    public final Element getPureElement() {
        return this.form;
    }

    public String getJsContextPath() {
        return this.jsContextPath;
    }

    public void setJsContextPath(String jsContextPath) {
        this.jsContextPath = jsContextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundImageSrcPath(String imageDirSrcPath) {
        if (this.hasBgImg() && imageDirSrcPath != null) {
            File bgImageDir = new File(imageDirSrcPath);
            if (!bgImageDir.exists()) {
                bgImageDir.mkdirs();
            }
            HTMLPage hTMLPage = this;
            synchronized (hTMLPage) {
                File bgImageFile = new File(bgImageDir, this.getBgImgName() + this.getBgImgExtension());
                OutputStream fout = null;
                try {
                    if (!bgImageFile.exists()) {
                        bgImageFile.deleteOnExit();
                        fout = new FileOutputStream(bgImageFile);
                        ((FileOutputStream)fout).write(this.getBgImgBytes());
                    }
                    this.setBgImgSrc("../" + bgImageDir.getName() + '/' + bgImageFile.getName());
                    this.refreshBgImageStyle();
                }
                catch (IOException e) {
                    Log.logWarning((Throwable)e);
                }
                finally {
                    block19: {
                        try {
                            if (fout != null) {
                                fout.flush();
                                ((FileOutputStream)fout).close();
                            }
                        }
                        catch (IOException e) {
                            if (!Log.isDebugging()) break block19;
                            Log.logDebug((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void setBgImage(XFormBackground img) {
        if (img != null) {
            this.bgImgLayout = img.imagelayout;
            this.bgImgAttach = img.imageattachment;
            this.bgImgXPosition = img.imagexposition;
            this.bgImgYPosition = img.imageyposition;
            XFormImage bgImage = img.image;
            if (bgImage != null && !Str.isEmpty((String)bgImage.gifencoded)) {
                XORuntimeManager runtimeManager = this.getXScreen().getRuntimeManager();
                this.imageInfo = HTMLImage.getImageData(bgImage, this.getDocId(), this.getScreenId(), 12, this.isPreview(), runtimeManager.getUrlBuilder());
                if (this.imageInfo != null) {
                    this.applyStyle();
                }
            }
        }
    }

    public String getBgImgAttach() {
        return this.bgImgAttach;
    }

    public byte[] getBgImgBytes() {
        return this.imageInfo.getImageBytes();
    }

    public String getBgImgName() {
        if (this.hasBgImg()) {
            StringBuilder imgName = new StringBuilder();
            imgName.append(this.getXScreen().getRuntimeManager().getXObject().getName().replace('.', '_'));
            imgName.append(this.imageInfo.getImageBytes().length);
            imgName.append(this.imageInfo.getImageName());
            return imgName.toString();
        }
        return null;
    }

    public String getBgImgSrc() {
        if (this.imageInfo != null) {
            return this.imageInfo.getImageSrc();
        }
        return null;
    }

    public String getBgImgXPosition() {
        return this.bgImgXPosition;
    }

    public String getBgImgYPosition() {
        return this.bgImgYPosition;
    }

    @Override
    public boolean isClientErrorAsPopup() {
        try {
            return this.getXScreen().getRuntimeManager().getCurrentPModel().getPresentation().isClienterroraspopup();
        }
        catch (Throwable e) {
            return true;
        }
    }

    @Override
    public String getCssClassName() {
        try {
            return this.getXScreen().getRuntimeManager().getCurrentPModel().getPresentation().getCssClass();
        }
        catch (Throwable e) {
            return "";
        }
    }

    @Override
    public boolean isCssEnabled() {
        try {
            return this.getXScreen().getRuntimeManager().getCurrentPModel().getPresentation().isCssEnabled();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public String getCssFilename() {
        try {
            return this.getXScreen().getRuntimeManager().getCurrentPModel().getPresentation().getCssFilename();
        }
        catch (XObjectRuntimeInternalException e) {
            Log.logWarning((Throwable)((Object)e));
            return null;
        }
    }

    public String getDocumentHtmlText() throws IOException {
        this.initJSLibraries();
        return this.form.getHtmlText();
    }

    public Form getForm() {
        return this.form;
    }

    public String getFormHtmlText() throws IOException {
        return this.mainContainerDiv.getHtmlText();
    }

    public final String getHTMLErrorContainer() throws IOException {
        Table errorTable = new Table();
        errorTable.setHtmlId("fo.clientErrorContainer");
        errorTable.setStyle("display:none;border-collapse:collapse;width: 100%;border: 1px solid;");
        errorTable.setCellPadding("2");
        ColGroup errorColGroup = new ColGroup();
        COL iconCol = new COL();
        COL msgCol = new COL();
        msgCol.setWidth("100%");
        errorColGroup.addChild(iconCol);
        errorColGroup.addChild(msgCol);
        TR errorTR = this.getMsgRow(1, "fo.clientErrorIcon", "fo.clientErrorMsg", "");
        errorTable.addChild(errorColGroup);
        errorTable.addChild(errorTR);
        return errorTable.getHtmlText();
    }

    @Override
    public boolean isMixedCss() {
        try {
            return this.getXScreen().getRuntimeManager().getCurrentPModel().getPresentation().isMixedCss();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public TR getMsgRow(int type, String iconTdId, String msgErrorTdId, String errorMsg) {
        TR errorTR = new TR();
        TD errorIconTD = new TD();
        TD errorMsgTD = new TD();
        try {
            XFormPresentation xPresentation = this.getXScreen().getRuntimeManager().getCurrentPModel().presentation_d;
            if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
                StringBuffer styleBuffer = new StringBuffer();
                styleBuffer.append("border-bottom-style: solid; border-bottom-width: 1px; border-top-style: solid; border-top-width: 1px;");
                styleBuffer.append(this.getInlineFontCCS(xPresentation.errorfonttype, xPresentation.getErrorFontStyle(), xPresentation.errorfontsize));
                styleBuffer.append(this.getInlineBackgroundColorCCS(xPresentation.errorbgcolor));
                styleBuffer.append(this.getInlineForegroundColorCCS(xPresentation.errorfgcolor));
                errorIconTD.setStyle("border-right-style: none;" + styleBuffer);
                errorMsgTD.setStyle("border-left-style: none;" + styleBuffer);
            }
            if (this.isCssEnabled()) {
                errorIconTD.setCssClass(xPresentation.errorcssclass);
                errorMsgTD.setCssClass(xPresentation.errorcssclass);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        errorIconTD.setHtmlId(iconTdId);
        errorMsgTD.setHtmlId(msgErrorTdId);
        String iconSrc = null;
        XORuntimeManager manager = this.getXScreen().getRuntimeManager();
        UrlBuilder urlBuilder = manager.getUrlBuilder();
        switch (type) {
            case 0: {
                iconSrc = HTMLPage.getRuntimeImage(urlBuilder, XObjectRuntimeMsg.PAGE_ERROR);
                break;
            }
            case 3: {
                iconSrc = HTMLPage.getRuntimeImage(urlBuilder, XObjectRuntimeMsg.PAGE_WARNING);
                break;
            }
            case 1: {
                iconSrc = HTMLPage.getRuntimeImage(urlBuilder, XObjectRuntimeMsg.PAGE_ERROR_CLIENT);
                break;
            }
            case 2: {
                iconSrc = HTMLPage.getRuntimeImage(urlBuilder, XObjectRuntimeMsg.PAGE_ERROR_SERVER);
            }
        }
        IMG icon = new IMG();
        icon.setSrc(iconSrc);
        Text msgText = new Text();
        msgText.setPlainText(errorMsg);
        errorIconTD.addChild(icon);
        errorMsgTD.addChild(msgText);
        errorTR.addChild(errorIconTD);
        errorTR.addChild(errorMsgTD);
        return errorTR;
    }

    public void setPageBackgroundColor(String bgColor) {
        if (!Str.isEmpty((String)bgColor)) {
            this.bgColor = bgColor;
            this.applyStyle();
        }
    }

    public String getPageBackgroundColor() {
        return this.bgColor == null ? "#FFFFFF" : this.bgColor;
    }

    @Override
    public String getStyle() {
        StringBuilder style = new StringBuilder();
        if ((!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) && (this.getBgImgSrc() != null || this.getPageBackgroundColor() != null)) {
            style.append("background: ");
            if (this.getPageBackgroundColor() != null) {
                style.append(this.getPageBackgroundColor());
            }
            if (this.getBgImgSrc() != null) {
                style.append(" url('");
                style.append(this.getBgImgSrc());
                style.append("') ");
                style.append(this.getBgLayoutStyle());
            }
        }
        return style.toString();
    }

    public void setSyleSheet(String styleSheet) {
        this.cssStyle = styleSheet;
    }

    @Override
    public Object clone() {
        return HTMLPage.newInstance(this);
    }

    public boolean hasBgImg() {
        return this.imageInfo != null;
    }

    public String getBgImgExtension() {
        return this.imageInfo.getImageExtension();
    }

    public void setBgImgSrc(String src) {
        this.imageInfo.setImageSrc(src);
    }

    public void refreshBgImageStyle() {
        if (this.table != null) {
            this.table.setStyle(this.getStyle());
        }
    }

    @Override
    protected final void _addElement(HTMLElement element) {
        this.td.addChild(element.getElement());
    }

    @Override
    protected void _applyStyle(String style) {
        this.table.setStyle(style);
        if (this.isCssEnabled()) {
            this.table.setCssClass(this.getCssClassName());
        } else {
            this.table.setCssClass("");
        }
    }

    protected void initPageWithDateTimeElement(Locale locale, TimeZone timeZone) {
        this.hasDateElement = true;
    }

    protected void initPageWithGraphicElement() {
        this.hasGraphicElement = true;
    }

    protected void initGraphicJSLibraries() {
        this.jsContainerDiv.addChild(this.initScript("FusionCharts.js"));
        if (!this.isPreview()) {
            this.jsContainerDiv.addChild(this.initScript("fuegotimer.js"));
            StringBuilder scriptBuffer = new StringBuilder();
            scriptBuffer.append("enableTimer();startTimer();");
            Text scriptText = new Text();
            scriptText.setPlainText(scriptBuffer.toString());
            Script theScript = new Script("TimerScript");
            theScript.setLanguage("JavaScript");
            theScript.addChild(scriptText);
            this.mainContainerDiv.addChild(theScript);
        }
    }

    String getDocId() {
        return this.docId;
    }

    String getScreenId() {
        return this.getXScreen().getIdentifier();
    }

    private static DIV buildJSContainer() {
        return new DIV("jsContainerDiv_d");
    }

    private static String getPreviewScriptFile(String jsFileName) {
        String result;
        if (jsPortalDir == null) {
            StringBuilder dirbuffer = new StringBuilder();
            dirbuffer.append(FuegoDirectories.webAppsInstallation());
            dirbuffer.append("workspace");
            dirbuffer.append(File.separator);
            dirbuffer.append("js");
            jsPortalDir = dirbuffer.toString();
        }
        try {
            File jsFile = new File(jsPortalDir, jsFileName);
            result = jsFile.exists() ? jsFile.toURI().toURL().toString() : "";
        }
        catch (MalformedURLException e) {
            result = "";
        }
        return result;
    }

    private void initDateJSLibraries(Locale locale) {
        this.jsContainerDiv.addChild(this.initScript("fuegodate.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegopopupwindow.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegoanchorposition.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegocalendarpopup.js"));
        String monthNames = DateFormatSymbolUtils.convertToString((String[])DateFormatSymbolUtils.getLocalizedMonthNames((Locale)locale), (boolean)false);
        String monthAbbreviations = DateFormatSymbolUtils.convertToString((String[])DateFormatSymbolUtils.getLocalizedMonthShortNames((Locale)locale), (boolean)false);
        String dayHeaders = DateFormatSymbolUtils.convertToString((String[])DateFormatSymbolUtils.getLocalizedHeaderDayNames((Locale)locale), (boolean)false);
        StringBuilder scriptBuffer = new StringBuilder();
        scriptBuffer.append("var calendar = new CalendarPopup('calendardiv');\n");
        scriptBuffer.append("calendar.setReturnFunction('FuegoObjectCalendarReturnFunction');\n");
        scriptBuffer.append("calendar.setMonthNames(");
        scriptBuffer.append(monthNames);
        scriptBuffer.append(");\n");
        scriptBuffer.append("calendar.setMonthAbbreviations(");
        scriptBuffer.append(monthAbbreviations);
        scriptBuffer.append(");\n");
        scriptBuffer.append("calendar.setDayHeaders(");
        scriptBuffer.append(dayHeaders);
        scriptBuffer.append(");\n");
        scriptBuffer.append("calendar.setWeekStartDay(");
        scriptBuffer.append(DateFormatSymbolUtils.getLocalizedFirstDayOfWeek((Locale)locale) - 1);
        scriptBuffer.append(");\n");
        scriptBuffer.append("calendar.setTodayText('");
        scriptBuffer.append(CoreMsg.TODAY.getString(locale));
        scriptBuffer.append("');\n");
        scriptBuffer.append("calendar.showYearNavigation();\n");
        scriptBuffer.append("var popupcalendar = new CalendarPopup();\n");
        scriptBuffer.append("popupcalendar.setReturnFunction('FuegoObjectCalendarReturnFunction');\n");
        scriptBuffer.append("popupcalendar.setMonthNames(");
        scriptBuffer.append(monthNames);
        scriptBuffer.append(");\n");
        scriptBuffer.append("popupcalendar.setMonthAbbreviations(");
        scriptBuffer.append(monthAbbreviations);
        scriptBuffer.append(");\n");
        scriptBuffer.append("popupcalendar.setDayHeaders(");
        scriptBuffer.append(dayHeaders);
        scriptBuffer.append(");\n");
        scriptBuffer.append("popupcalendar.setWeekStartDay(");
        scriptBuffer.append(DateFormatSymbolUtils.getLocalizedFirstDayOfWeek((Locale)locale) - 1);
        scriptBuffer.append(");\n");
        scriptBuffer.append("popupcalendar.setTodayText('");
        scriptBuffer.append(CoreMsg.TODAY.getString(locale));
        scriptBuffer.append("');\n");
        scriptBuffer.append("popupcalendar.showYearNavigation();\n");
        scriptBuffer.append("MONTH_NAMES=new Array(");
        scriptBuffer.append(monthNames);
        scriptBuffer.append(',');
        scriptBuffer.append(monthAbbreviations);
        scriptBuffer.append(");");
        if (!this.isCalendarStyleInit && this.cssStyle != null) {
            this.isCalendarStyleInit = true;
            scriptBuffer.append("\npopupcalendar.setStyles('");
            scriptBuffer.append(this.cssStyle);
            scriptBuffer.append("');");
        }
        Text scriptText = new Text();
        scriptText.setPlainText(scriptBuffer.toString());
        Script theScript = new Script();
        theScript.setLanguage("JavaScript");
        theScript.addChild(scriptText);
        DIV div = new DIV();
        div.setHtmlId("calendardiv");
        div.setStyle("VISIBILITY: hidden; POSITION: absolute; BACKGROUND-COLOR: white; layer-background-color: white");
        this.mainContainerDiv.addChild(theScript);
        this.mainContainerDiv.addChild(div);
    }

    private void initPage() {
        this.form = this.buildForm();
        this.mainContainerDiv = this.initMainDivContainer();
        this.jsContainerDiv = HTMLPage.buildJSContainer();
        this.form.addChild(this.jsContainerDiv);
        this.form.addChild(this.mainContainerDiv);
    }

    private String getBgLayout() {
        return this.bgImgLayout;
    }

    private String getBgLayoutStyle() {
        StringBuilder styleBuffer = new StringBuilder();
        styleBuffer.append(this.getBgLayout() != null ? this.getBgLayout() : "no-repeat");
        styleBuffer.append(' ');
        styleBuffer.append(this.getBgImgAttach() != null ? this.getBgImgAttach() : "fixed");
        styleBuffer.append(' ');
        styleBuffer.append(this.getBgImgXPosition() != null ? this.getBgImgXPosition() : "center");
        styleBuffer.append(' ');
        styleBuffer.append(this.getBgImgYPosition() != null ? this.getBgImgYPosition() : "center");
        styleBuffer.append(' ');
        return styleBuffer.toString();
    }

    private Form buildForm() {
        Form form = new Form(String.valueOf(System.currentTimeMillis()));
        form.setName(FORM_NAME);
        form.setHtmlId(FORM_NAME);
        form.setMethod("POST");
        form.setEncType("application/x-www-form-urlencoded");
        if (this.isPreview()) {
            form.setOnSubmit("return false;");
        }
        Input xfdocHidden = new Input("xo$DocSessKey");
        xfdocHidden.setType("HIDDEN");
        xfdocHidden.setName("xo$DocSessKey");
        xfdocHidden.setValue(this.getDocId());
        form.addChild(xfdocHidden);
        Input actionHidden = new Input("xo$Action");
        actionHidden.setType("HIDDEN");
        actionHidden.setName("xo$Action");
        actionHidden.setValue("9999");
        form.addChild(actionHidden);
        Input attNameHidden = new Input("xo$AttName");
        attNameHidden.setType("HIDDEN");
        attNameHidden.setName("xo$AttName");
        attNameHidden.setValue("");
        form.addChild(attNameHidden);
        Input changeHidden = new Input("xo$ChangedAtts");
        changeHidden.setType("HIDDEN");
        changeHidden.setName("xo$ChangedAtts");
        changeHidden.setValue("");
        form.addChild(changeHidden);
        Input groupSelectionIndexHidden = new Input("xo$GroupIndexes");
        groupSelectionIndexHidden.setType("HIDDEN");
        groupSelectionIndexHidden.setName("xo$GroupIndexes");
        groupSelectionIndexHidden.setValue("");
        form.addChild(groupSelectionIndexHidden);
        Input lastFocusHidden = new Input("xo$lastFocusElement");
        lastFocusHidden.setType("HIDDEN");
        lastFocusHidden.setName("xo$lastFocusElement");
        lastFocusHidden.setValue("");
        form.addChild(lastFocusHidden);
        Input currentTimerValuesHidden = new Input("xo$TimerValues");
        currentTimerValuesHidden.setType("HIDDEN");
        currentTimerValuesHidden.setName("xo$TimerValues");
        currentTimerValuesHidden.setValue("");
        form.addChild(currentTimerValuesHidden);
        Input currentGraphicClickCategoryHidden = new Input("fo$graphiclick$category");
        currentGraphicClickCategoryHidden.setType("HIDDEN");
        currentGraphicClickCategoryHidden.setName("fo$graphiclick$category");
        currentGraphicClickCategoryHidden.setHtmlId("fo$graphiclick$category");
        currentGraphicClickCategoryHidden.setValue("");
        form.addChild(currentGraphicClickCategoryHidden);
        Input currentClickSeriesHidden = new Input("fo$graphiclick$series");
        currentClickSeriesHidden.setType("HIDDEN");
        currentClickSeriesHidden.setName("fo$graphiclick$series");
        currentClickSeriesHidden.setHtmlId("fo$graphiclick$series");
        currentClickSeriesHidden.setValue("");
        form.addChild(currentClickSeriesHidden);
        return form;
    }

    private void initJSLibraries() {
        if (!this.isJsInit) {
            this.isJsInit = true;
            this.initGralJSLibraries(this.getXScreen().getLocale());
            if (this.hasDateElement) {
                this.initDateJSLibraries(this.getXScreen().getLocale());
            }
            if (this.hasGraphicElement) {
                this.initGraphicJSLibraries();
            }
        }
    }

    private void initGralJSLibraries(Locale locale) {
        this.jsContainerDiv.addChild(this.initScript("fuegovalidation.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegoxoformutil.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegomask.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegogroup.js"));
        this.jsContainerDiv.addChild(this.initScript("fuegorequest.js"));
        Text scriptText = new Text();
        StringBuilder msgSetupBuffer = new StringBuilder();
        msgSetupBuffer.append("\nremoteScriptNullResponseMsg = \"");
        msgSetupBuffer.append(XObjectRuntimeMsg.REMOTE_JS_NULL_RESPONSE_ERROR.getString(locale));
        msgSetupBuffer.append("\";");
        msgSetupBuffer.append("\nremoteScriptUnknownResponseMsg = \"");
        msgSetupBuffer.append(XObjectRuntimeMsg.REMOTE_JS_UNKNOWN_RESPONSE.getString(locale));
        msgSetupBuffer.append("\";");
        msgSetupBuffer.append("\nremoteScriptNullRequest = \"");
        msgSetupBuffer.append(XObjectRuntimeMsg.REMOTE_JS_NULL_RS_OBJECT.getString(locale));
        msgSetupBuffer.append("\";");
        msgSetupBuffer.append("\nremoteScriptStatusProblem = \"");
        msgSetupBuffer.append(XObjectRuntimeMsg.REMOTE_JS_RESPONSE_PROBLEM.getString(locale));
        msgSetupBuffer.append("\";");
        msgSetupBuffer.append("\nloadingMessage = \"");
        msgSetupBuffer.append(XObjectRuntimeMsg.PRESENTATION_LOADING_MESSAGE.getString(locale));
        msgSetupBuffer.append("\";");
        scriptText.setPlainText(msgSetupBuffer.toString());
        Script theScript = new Script();
        theScript.setType("Text/JavaScript");
        theScript.addChild(scriptText);
        this.jsContainerDiv.addChild(theScript);
    }

    private DIV initMainDivContainer() {
        this.td = new TD("td_d");
        this.td.setWidth("100%");
        this.td.setHeight("100%");
        this.td.setAlign("center");
        this.td.setVAlign("top");
        TR tr = new TR("tr_d");
        tr.addChild(this.td);
        this.table = new Table("table_d");
        this.table.setAlign("center");
        this.table.setCellPadding("0");
        this.table.setCellSpacing("0");
        this.table.setBorder("0");
        this.table.addChild(tr);
        this.table.setWidth("100%");
        this.mainContainerDiv = new DIV("tableDiv_d");
        this.mainContainerDiv.setHtmlId(ComponentIdFactory.buildPresentationId());
        Input xfscreenHidden = new Input("xo$ScreenSessKey");
        xfscreenHidden.setType("HIDDEN");
        xfscreenHidden.setName("xo$ScreenSessKey");
        xfscreenHidden.setValue(this.getScreenId());
        this.mainContainerDiv.addChild(xfscreenHidden);
        this.mainContainerDiv.addChild(this.table);
        return this.mainContainerDiv;
    }

    private Script initScript(String jsFileName) {
        Script theScript = new Script(jsFileName);
        theScript.setLanguage("JavaScript");
        if (this.isPreview()) {
            theScript.setSrc(HTMLPage.getPreviewScriptFile(jsFileName));
        } else {
            theScript.setSrc(this.jsContextPath + jsFileName);
        }
        return theScript;
    }
}

