/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.data.html.LinkType;
import oracle.bpm.data.html.TextType;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLComponentElement;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;
import oracle.bpm.xobject.runtime.presentationComponents.RefreshableComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOLinkComponent;
import oracle.bpm.xobject.xhb.A;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Text;

public class HTMLLink
extends HTMLComponentElement
implements XOLinkComponent,
RefreshableComponent {
    private A anchor;
    private LinkType linkType;
    private Text text;
    private TextType textType;

    public HTMLLink(XScreen xScreen, XFormLink formLink) {
        super(xScreen, (XFormPresentationXMLObject)formLink);
        this.linkType = formLink.getLinkType() != null ? LinkType.valueOf((String)formLink.getLinkType()) : LinkType.DEFAULT;
        this.textType = formLink.getTextType() != null ? TextType.valueOf((String)formLink.getTextType()) : TextType.DEFAULT;
        this.initLink();
    }

    public LinkType getLinkType() {
        if (this.linkType == null) {
            this.linkType = LinkType.DEFAULT;
        }
        return this.linkType;
    }

    @Override
    public int getMethodArgumentQty() {
        return 0;
    }

    @Override
    public String getMethodInvocation() {
        return null;
    }

    @Override
    public void setName(String name) {
        this.anchor.setHtmlId(name);
    }

    @Override
    public Element getPureElement() {
        return this.getAnchor();
    }

    @Override
    public String getStyle() {
        XFormLink xLink = (XFormLink)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (this.areEventsAllowed() && this.getMethodInvocation() != null || this.getLink() != null) {
            css.append("text-decoration: underline;");
        }
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xLink.getFonttype(), xLink.getFontStyle(), xLink.getFontsize()));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
        }
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
    }

    public TextType getTextType() {
        if (this.textType == null) {
            this.textType = TextType.DEFAULT;
        }
        return this.textType;
    }

    @Override
    public boolean hasClick() {
        return false;
    }

    @Override
    public void refresh(XObjectInstance xo) {
        this.refresh(xo, false);
    }

    @Override
    protected void _applyStyle(String style) {
        this.anchor.setStyle(style);
        if (this.isCssEnabled()) {
            this.anchor.setCssClass(this.getCssClassName());
        } else {
            this.anchor.setCssClass("");
        }
    }

    protected void initLink() {
        this.text = new Text();
        this.anchor = new A();
        this.anchor.setHtmlId(ComponentIdFactory.buildEditableTextComponentId(this.getId()));
        this.anchor.addChild(this.text);
        XFormLink formLink = (XFormLink)this.getPresentationXMLObject();
        if (this.textType != TextType.REFERENCE) {
            this.setText(formLink.getTextValue());
        }
        if (this.linkType != LinkType.REFERENCE) {
            this.setLink(formLink.getLinkValue());
        }
        if (!(this.hasTextGroupDataId() || this.hasLinkGroupDataId() || this.textType != TextType.REFERENCE && this.linkType != LinkType.REFERENCE)) {
            this.refresh(this.getXScreen().getXO(), true);
        }
        this.applyStyle();
    }

    @Override
    protected void _setText(String theText) {
        if (this.text != null) {
            this.text.setText(theText);
        }
    }

    @Override
    protected void _setLink(String url) {
        if (this.anchor != null) {
            url = url == null ? "" : String.valueOf(url);
            StringBuilder buffer = new StringBuilder();
            if (this.isExternal() || this.isReference()) {
                if (url.toLowerCase().startsWith("mailto:")) {
                    buffer.append(url);
                } else {
                    buffer.append("javascript:void(window.open('");
                    buffer.append(url);
                    buffer.append("', '_blank'");
                    XFormLabel xLabel = (XFormLabel)this.getPresentationXMLObject();
                    if (!xLabel.isFullBrowser()) {
                        buffer.append(", 'resizable,scrollbars'");
                    }
                    buffer.append("));");
                }
                this.anchor.setHref(buffer.toString());
                this.anchor.setTitle(url);
            } else if (this.isAnchor()) {
                this.anchor.setName(url);
            } else if (this.isLocal()) {
                this.anchor.setHref('#' + url);
            }
        }
    }

    @Override
    void _setOnFocus(String js) {
    }

    private void refresh(XObjectInstance xo, boolean forceRefresh) {
        String dataId;
        XFormLink formLink = (XFormLink)this.getPresentationXMLObject();
        try {
            if (this.textType == TextType.REFERENCE && (dataId = formLink.getTextValue()) != null) {
                if (this.isEditor()) {
                    this.setText(dataId);
                } else {
                    String string = dataId = this.hasTextGroupDataId() ? dataId.substring(dataId.indexOf("[].") + 3) : dataId;
                    if (xo.isDirty(dataId) || forceRefresh) {
                        this.setText(String.valueOf(xo.getAttributeValue(dataId)));
                    }
                }
            }
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Throwable)((Object)e));
        }
        try {
            if (this.linkType == LinkType.REFERENCE && (dataId = formLink.getLinkValue()) != null) {
                if (this.isEditor()) {
                    this.setLink(dataId);
                } else {
                    String string = dataId = this.hasLinkGroupDataId() ? dataId.substring(dataId.indexOf("[].") + 3) : dataId;
                    if (xo.isDirty(dataId) || forceRefresh) {
                        this.setLink(String.valueOf(xo.getAttributeValue(dataId)));
                    }
                }
            }
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Throwable)((Object)e));
        }
    }

    private boolean hasTextGroupDataId() {
        XFormLink formLink = (XFormLink)this.getPresentationXMLObject();
        String dataId = formLink.getTextValue();
        return dataId != null && dataId.contains("[].");
    }

    private boolean hasLinkGroupDataId() {
        XFormLink formLink = (XFormLink)this.getPresentationXMLObject();
        String dataId = formLink.getLinkValue();
        return dataId != null && dataId.contains("[].");
    }

    private A getAnchor() {
        return this.anchor;
    }

    private boolean isAnchor() {
        return this.getLinkType() == LinkType.ANCHOR;
    }

    private boolean isExternal() {
        return this.getLinkType() == LinkType.EXTERNAL;
    }

    private boolean isFixed() {
        return this.getTextType() == TextType.FIXED;
    }

    private boolean isLocal() {
        return this.getLinkType() == LinkType.LOCAL;
    }

    private boolean isReference() {
        return this.getLinkType() == LinkType.REFERENCE;
    }
}

