/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.util.Locale;
import oracle.bpm.lang.Interval;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormInterval;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.presentationComponents.XOIntervalComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOIntervalComponentDelegate;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLInterval
extends HTMLInputElement
implements XOIntervalComponent {
    private final XOIntervalComponentDelegate componentDelegate_d;
    private Input iText_d;
    private final Locale locale_d;
    private Table sTable_d;
    private TD sTD_d;
    private Text sText_d;

    public HTMLInterval(XScreen xScreen, XFormInterval t, Locale locale) {
        super(xScreen, (XFormUserInputPresentationXMLObject)t);
        this.locale_d = locale;
        this.initInterval(t);
        this.componentDelegate_d = new XOIntervalComponentDelegate(this);
    }

    public static HTMLInterval newInstance(HTMLInterval originalElement) {
        HTMLInterval newElement = new HTMLInterval(originalElement.getXScreen(), (XFormInterval)originalElement.getPresentationXMLObject(), originalElement.locale_d);
        newElement.setValue(originalElement.getDefaultValue());
        return newElement;
    }

    @Override
    public String getElementHtmlId() {
        return this.iText_d.getAttribute(Element.ID_PROPERTY);
    }

    @Override
    public void setName(String name) {
        if (this.iText_d != null) {
            this.iText_d.setName(name);
            this.iText_d.setHtmlId(name);
        }
    }

    @Override
    public Element getPureElement() {
        return this.isEditable() ? this.iText_d : this.sTable_d;
    }

    @Override
    public String getStyle() {
        XFormInterval xInterval = (XFormInterval)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xInterval.fonttype, xInterval.getFontStyle(), xInterval.fontsize));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
            css.append(this.getInlineBackgroundColorCCS(this.isEditable() ? this.getBackgroundColor() : "transparent"));
            if (this.isEditable()) {
                css.append(this.getInlineBorderCSS(xInterval.borderstyle, xInterval.bordercolor, xInterval.borderwidth));
            }
        }
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.iText_d != null) {
            this.iText_d.setTabindex(tabIndex);
        }
    }

    @Override
    public void setValue(Object value) {
        block4: {
            try {
                String valueStr = this.componentDelegate_d.convertToString(value);
                if (valueStr != null) {
                    if (valueStr.isEmpty()) {
                        valueStr = new Interval().toString();
                    }
                    this.iText_d.setValue(valueStr);
                    this.sText_d.setText(valueStr);
                }
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                if (!Log.isDebugging()) break block4;
                Log.logDebug((Throwable)e);
            }
        }
    }

    @Override
    public Object clone() {
        return HTMLInterval.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        this.iText_d.setStyle(style);
        this.sTD_d.setStyle(style);
        if (this.isCssEnabled()) {
            this.iText_d.setCssClass(this.getCssClassName());
            this.sTD_d.setCssClass(this.getCssClassName());
        } else {
            this.iText_d.setCssClass("");
            this.sTD_d.setCssClass("");
        }
    }

    @Override
    void _setOnFocus(String js) {
        this.iText_d.setOnFocus(js);
    }

    private void initInterval(XFormInterval t) {
        this.initIntervalInput(t);
        this.initIntervalText(t);
        this.applyStyle();
        this.applyFocusPersistence();
    }

    private void initIntervalInput(XFormInterval t) {
        this.iText_d = new Input(this.getId());
        this.iText_d.setType("TEXT");
        this.iText_d.setName(this.getHtmlAttString());
        this.iText_d.setHtmlId(this.getHtmlAttString());
        this.iText_d.setTabindex(this.getTabindex());
        if (!this.isPreview()) {
            this.iText_d.setOnChange("valueChanged(this.name, " + (t.getOnChange() != null) + ')');
        }
    }

    private void initIntervalText(XFormInterval t) {
        this.sTable_d = new Table(this.getId());
        TR sTR = new TR("sTR_d");
        this.sTD_d = new TD("sTD_d");
        this.sText_d = new Text();
        this.sTD_d.addChild(this.sText_d);
        sTR.addChild(this.sTD_d);
        this.sTable_d.addChild(sTR);
    }
}

