/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.GroupArray;
import oracle.bpm.xobject.GroupArrayChangeListener;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XObjectGroupRowInstance;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.html.HTMLGroupElement;
import oracle.bpm.xobject.runtime.html.HTMLRow;
import oracle.bpm.xobject.runtime.presentationComponents.MultivaluatedComponent;
import oracle.bpm.xobject.runtime.presentationComponents.RefreshableComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOElementComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Group;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public abstract class HTMLGroup
extends HTMLGroupElement
implements GroupArrayChangeListener {
    private int currentBeginPageIndex;
    private int currentEndPageIndex = -1;
    private Group group;
    private boolean hasPaging;
    private HTMLRow modelRow;
    private int rowQtyByPage = -1;

    protected HTMLGroup(XScreen screen, XFormRepeatable array) {
        super(screen, array);
        this.initGroup();
    }

    @Override
    public void setBgColorProperty(int index, String colPresId, String color) {
        this.groupDelegate.setBgColorProperty(index, colPresId, color);
    }

    @Override
    public String getBgColorProperty(int index, String colPresId) {
        return this.groupDelegate.getBgColorProperty(index, colPresId);
    }

    @Override
    public void setEditableProperty(int index, String colPresId, boolean isEditable) {
        this.groupDelegate.setEditableProperty(index, colPresId, isEditable);
    }

    @Override
    public boolean getEditableProperty(int index, String colPresId) {
        return this.groupDelegate.getEditableProperty(index, colPresId);
    }

    public String getEvenRowStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBackgroundColorCCS(xArray.getRowevencolor()));
        }
        return css.toString();
    }

    @Override
    public String getEventListener() {
        return this.groupDelegate.getEventListener();
    }

    @Override
    public void setFgColorProperty(int index, String colPresId, String color) {
        this.groupDelegate.setFgColorProperty(index, colPresId, color);
    }

    @Override
    public String getFgColorProperty(int index, String colPresId) {
        return this.groupDelegate.getFgColorProperty(index, colPresId);
    }

    public String getHeaderStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xArray.getHeaderfonttype(), xArray.getHeaderFontStyle(), xArray.getHeaderfontsize()));
            css.append(this.getInlineBackgroundColorCCS(xArray.getHeaderbgcolor()));
            css.append(this.getInlineForegroundColorCCS(xArray.getHeaderfgcolor()));
            css.append(this.getInlineBorderCSS(xArray.headerborderstyle, xArray.headerbordercolor, xArray.headerborderwidth));
        }
        return css.toString();
    }

    @Override
    public void setHeaderText(String[] headers) {
        if (this.group != null && headers != null && this.group.getHeaders().length == headers.length) {
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = this.getI18NText(headers[i]);
            }
            this.group.setHeaders(headers);
        }
    }

    @Override
    public String[] getHeaderText() {
        if (this.group != null) {
            return this.group.getHeaders();
        }
        return null;
    }

    public String getIndexAnchorStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xArray.getIndexfonttype(), xArray.getIndexfontStyle(), xArray.getIndexfontsize()));
            css.append(this.getInlineForegroundColorCCS(xArray.getIndexfgcolor()));
        }
        return css.toString();
    }

    public String getIndexCellStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xArray.getIndexfonttype(), xArray.getIndexfontStyle(), xArray.getIndexfontsize()));
            css.append(this.getInlineBackgroundColorCCS(xArray.getIndexbgcolor()));
            css.append(this.getInlineForegroundColorCCS(xArray.getIndexfgcolor()));
            css.append(this.getInlineBorderCSS(xArray.indexborderstyle, xArray.getIndexbordercolor(), xArray.getIndexborderwidth()));
        }
        return css.toString();
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void setLinkProperty(int index, String colPresId, String link) {
        this.groupDelegate.setLinkProperty(index, colPresId, link);
    }

    @Override
    public String getLinkProperty(int index, String colPresId) {
        return this.groupDelegate.getLinkProperty(index, colPresId);
    }

    @Override
    public void setName(String name) {
    }

    public String getOddRowStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBackgroundColorCCS(xArray.getRowoddcolor()));
        }
        return css.toString();
    }

    public String getPagingFontStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineForegroundColorCCS(xArray.getPagingfgcolor()));
            css.append(this.getInlineFontCCS(xArray.getPagingfonttype(), xArray.getPagingFontStyle(), xArray.getPagingfontsize()));
        }
        return css.toString();
    }

    public String getPagingStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBackgroundColorCCS(xArray.getPagingbgcolor()));
            css.append(this.getInlineBorderCSS(xArray.pagingborderstyle, xArray.getPagingbordercolor(), xArray.getPagingborderwidth()));
        }
        return css.toString();
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public String getStyle() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineBorderCSS(xArray.borderstyle, xArray.getBordercolor(), xArray.getBorderwidth()));
        }
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
    }

    @Override
    public void setTextProperty(int index, String colPresId, String text) {
        this.groupDelegate.setTextProperty(index, colPresId, text);
    }

    @Override
    public String getTextProperty(int index, String colPresId) {
        return this.groupDelegate.getTextProperty(index, colPresId);
    }

    @Override
    public void setValue(int index, Map rowValueMap) {
        block2: {
            this.updateModelRow(index, rowValueMap);
            try {
                this.groupDelegate.applyPropertiesToModelRow(index, this);
                this.group.setRow(index, (TR)this.getModelRow().getElement());
                this.groupDelegate.restorePropertiesToModelRow(index, this);
            }
            catch (IOException e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_ADD_BUILDER_ERROR);
                if (!Log.isDebugging()) break block2;
                Log.logDebug((Throwable)e);
            }
        }
    }

    @Override
    public void setVisibleProperty(int index, String colPresId, boolean isVisible) {
        this.groupDelegate.setVisibleProperty(index, colPresId, isVisible);
    }

    @Override
    public boolean getVisibleProperty(int index, String colPresId) {
        return this.groupDelegate.getVisibleProperty(index, colPresId);
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.group != null && this.group.isReadOnly() == editable) {
            this.group.setReadOnly(!editable);
        }
    }

    @Override
    public void _setVisible(boolean visible, boolean collapsed) {
        if (this.group != null && (this.group.isVisible() != visible || this.group.isVisibleCollapsed() != collapsed)) {
            this.group.setVisible(visible, collapsed);
            Iterator columnElementIterator = this.getColumnComponents();
            while (columnElementIterator.hasNext()) {
                HTMLElement element = (HTMLElement)columnElementIterator.next();
                element.refreshComponent();
            }
        }
    }

    @Override
    public void addElement(XOPresentationComponent element) {
        block5: {
            if (element instanceof HTMLRow) {
                this.modelRow = (HTMLRow)element;
                this.modelRow.setParent(this);
                this.modelRow.initElement();
                this.initRowStuff();
            }
            if (!this.isEditor()) {
                this.registerListener();
            } else {
                try {
                    this.group.addRow((TR)this.modelRow.getElement());
                }
                catch (IOException e) {
                    if ($assertionsDisabled || Log.logDebug((Throwable)e)) break block5;
                    throw new AssertionError();
                }
            }
        }
    }

    public boolean addRow(int rowIndex) throws InvalidXOAttributeException {
        try {
            this.groupDelegate.applyPropertiesToModelRow(rowIndex, this);
            this.group.insertRow(rowIndex, (TR)this.getModelRow(rowIndex).getElement());
            this.groupDelegate.restorePropertiesToModelRow(rowIndex, this);
            return true;
        }
        catch (InvalidXOAttributeException e) {
            if (Log.isDebugging()) {
                Log.logDebug((Msg)XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_ADD_ACCESS_ERROR);
            }
            if (Log.isDebugging()) {
                Log.logDebug((Throwable)((Object)e));
            }
            return false;
        }
        catch (IOException e) {
            this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_ADD_BUILDER_ERROR);
            if (Log.isDebugging()) {
                Log.logDebug((Throwable)e);
            }
            return false;
        }
    }

    @Override
    public void applyRestrictions() {
    }

    public void contentsChanged(int index) {
        this.groupDelegate.contentsChanged(index);
    }

    @Override
    public boolean hasEventListener() {
        return this.groupDelegate.hasEventListener();
    }

    public void intervalAdded(int startIndex, int endIndex) {
        this.groupDelegate.intervalAdded(startIndex, endIndex);
        for (int i = startIndex; i <= endIndex; ++i) {
            try {
                this.addRow(i);
                continue;
            }
            catch (InvalidXOAttributeException e) {
                // empty catch block
            }
        }
    }

    public void intervalRemoved(GroupArray source, int startIndex, int endIndex) {
        this.groupDelegate.intervalRemoved(source, startIndex, endIndex);
        this.group.removeRows(startIndex, endIndex);
    }

    public void nextPage() {
        if (this.hasPaging) {
            this.currentBeginPageIndex += this.rowQtyByPage;
            this.currentEndPageIndex += this.rowQtyByPage;
            this.setPresCompDirty(true);
        }
    }

    public void prevPage() {
        if (this.hasPaging && this.currentBeginPageIndex > 0) {
            this.currentBeginPageIndex -= this.rowQtyByPage;
            this.currentEndPageIndex -= this.rowQtyByPage;
            this.setPresCompDirty(true);
        }
    }

    @Override
    public boolean refreshPresentationValue(boolean force) {
        this.groupDelegate.cleanRowProperties();
        XObjectInstance xo = this.getXScreen().getRuntimeManager().getXObject();
        try {
            List<XObjectGroupRowInstance> xobjectInstanceList;
            if (this.hasPaging) {
                int totalGroupQty = xo.getGroupSize(this.getReference());
                this.group.setRowQtyWithoutPaging(totalGroupQty);
                if (totalGroupQty == 0) {
                    this.resetPageIndexes();
                } else if (this.currentBeginPageIndex >= totalGroupQty) {
                    while (this.currentBeginPageIndex >= totalGroupQty) {
                        this.currentBeginPageIndex -= this.rowQtyByPage;
                        this.currentEndPageIndex -= this.rowQtyByPage;
                    }
                    this.group.setPagingRange(this.currentBeginPageIndex, this.currentEndPageIndex);
                    force = true;
                } else if (this.currentBeginPageIndex != this.group.getPagingRange()[0]) {
                    this.group.setPagingRange(this.currentBeginPageIndex, this.currentEndPageIndex);
                    force = true;
                }
                xobjectInstanceList = this.getXScreen().getRuntimeManager().getXObject().getGroupRows(this.getReference(), this.currentBeginPageIndex, this.currentEndPageIndex);
            } else {
                xobjectInstanceList = this.getXScreen().getRuntimeManager().getXObject().getGroupRows(this.getReference());
            }
            if (this.isPresCompDirty()) {
                this.group.clearRows();
                force = true;
            } else if (this.group.size() != xobjectInstanceList.size()) {
                this.group.clearRows();
                this.groupDelegate.syncroRowProperties(xobjectInstanceList.size());
                force = true;
            }
            for (int i = 0; i < xobjectInstanceList.size(); ++i) {
                XObjectGroupRowInstance rowXObjectInstance = xobjectInstanceList.get(i);
                boolean isRowDirty = rowXObjectInstance.isDirty() || this.groupDelegate.hasRowProperties(i) && !this.groupDelegate.hasBeenApplied(i);
                String[] references = this.getColumnDataIds();
                HashMap<String, Object> rowValueMap = new HashMap<String, Object>(references.length);
                for (String reference : references) {
                    Object value;
                    block18: {
                        isRowDirty = isRowDirty || rowXObjectInstance.isDirty(reference);
                        value = null;
                        try {
                            value = rowXObjectInstance.getAttributeValue(reference);
                        }
                        catch (IllegalArgumentException e) {
                            if (this.isPreview()) break block18;
                            throw e;
                        }
                    }
                    rowValueMap.put(reference, value);
                }
                if (force || isRowDirty) {
                    int index = this.hasPaging ? i + this.currentBeginPageIndex : i;
                    this.setValue(index, rowValueMap);
                }
                rowXObjectInstance.resetDirty();
            }
            xo.resetGroupModifiedRowsFlag(this.getReference());
            this.resetPresCompDirty();
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Throwable)((Object)e));
            throw new RuntimeException((Throwable)((Object)e));
        }
        this.getXScreen().fireChangeEvent(this.getId());
        return true;
    }

    @Override
    public void registerListener() {
        try {
            this.getXScreen().getXO().registerGroupArrayChangeListener(this.getReference(), this);
        }
        catch (InvalidXOAttributeException e) {
            Log.logDebug((String)("[FuegoObject] HTMLPresentation ::: The group [" + this.getReference() + "] listener could not be registered."));
        }
    }

    @Override
    public void resetPresCompDirty() {
        super.resetPresCompDirty();
        Iterator comps = this.getColumnComponents();
        while (comps.hasNext()) {
            XOPresentationComponent xoPresentationComponent = (XOPresentationComponent)comps.next();
            xoPresentationComponent.resetPresCompDirty();
        }
    }

    @Override
    public void restrictLength(int length) {
    }

    @Override
    public void restrictPrecision(int precision) {
    }

    @Override
    public void restrictType(int kind) {
    }

    protected abstract void initRowStuff();

    protected String getElementColumnHtmlId(String columnId, int index) {
        return XOConstants.createGrpStr(this.getId(), columnId, index);
    }

    protected HTMLRow getModelRow() {
        return this.modelRow;
    }

    @Override
    protected Element getPureElement() {
        return this.group;
    }

    @Override
    protected void _applyStyle(String style) {
        this.group.setStyle(style);
        this.group.setPagingCellStyle(this.getPagingStyle());
        this.group.setPagingTextStyle(this.getPagingFontStyle());
        this.group.setHeaderStyle(this.getHeaderStyle());
        this.group.setIndexCellStyle(this.getIndexCellStyle());
        this.group.setIndexAnchorStyle(this.getIndexAnchorStyle());
        this.group.setEvenRowStyle(this.getEvenRowStyle());
        this.group.setOddRowStyle(this.getOddRowStyle());
        if (this.isCssEnabled()) {
            XFormRepeatable xGroup = (XFormRepeatable)this.getPresentationXMLObject();
            this.group.setCssClass(this.getCssClassName());
            this.group.setPagingCssClass(xGroup.getPagingcssclass());
            this.group.setHeaderCssClass(xGroup.getHeadercssclass());
            this.group.setIndexCssClass(xGroup.getIndexcssclass());
            this.group.setEvenRowCssClass(xGroup.getRowevencssclass());
            this.group.setOddRowCssClass(xGroup.getRowoddcssclass());
        } else {
            this.group.setCssClass(null);
            this.group.setPagingCssClass(null);
            this.group.setHeaderCssClass(null);
            this.group.setIndexCssClass(null);
            this.group.setEvenRowCssClass(null);
            this.group.setOddRowCssClass(null);
        }
    }

    @Override
    protected void _setBackgroundColor(String color) {
        this.applyStyle();
        this.refreshPresentationValue(true);
    }

    @Override
    void _setOnFocus(String js) {
        this.group.setOnFocus(js);
    }

    private void updateModelRow(int index, Map rowValueMap) {
        String[] presIds;
        for (String presId : presIds = this.getColumnPresentationIds()) {
            XObjectGroupRowInstance xobjectInstance;
            XOElementComponent componentElement = this.getColumnElementByPresId(presId);
            String name = this.getElementColumnHtmlId(componentElement.getId(), index);
            componentElement.setName(name);
            componentElement.setTabIndex(this.getTabindex());
            if (componentElement instanceof MultivaluatedComponent) {
                try {
                    xobjectInstance = this.getXScreen().getRuntimeManager().getXObject().getGroupXObjectInstance(this.getReference(), index);
                    MultivaluatedComponent multivaluatedComponent = (MultivaluatedComponent)componentElement;
                    if (multivaluatedComponent.isValidValuesReloadNeeded()) {
                        Object[][] vv = xobjectInstance.getAttributeValidValues(this.getDataIdtWithPressId(presId));
                        multivaluatedComponent.setValidValues(vv[0], vv[1]);
                    }
                }
                catch (InvalidXOAttributeException e) {
                    this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_VV_SETTER_PROBLEM(this.getId(), presId));
                }
                catch (RuntimeException e) {
                    if (this.isPreview()) {
                        Log.logWarning((Throwable)e);
                    }
                    throw e;
                }
            }
            if (componentElement instanceof XOInputComponent) {
                ((XOInputComponent)componentElement).setValue(rowValueMap.get(this.getDataIdtWithPressId(presId)));
                continue;
            }
            if (!(componentElement instanceof RefreshableComponent)) continue;
            try {
                xobjectInstance = this.getXScreen().getXO().getGroupXObjectInstance(this.getReference(), index);
                ((RefreshableComponent)((Object)componentElement)).refresh(xobjectInstance);
            }
            catch (InvalidXOAttributeException e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_VV_SETTER_PROBLEM(this.getId(), presId));
            }
            catch (RuntimeException e) {
                if (this.isPreview()) {
                    Log.logWarning((Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private HTMLRow getModelRow(int rowIndex) throws InvalidXOAttributeException {
        XObjectGroupRowInstance xobjectInstance = this.getXScreen().getRuntimeManager().getXObject().getGroupXObjectInstance(this.getReference(), rowIndex);
        String[] references = this.getColumnDataIds();
        HashMap<String, Object> values = new HashMap<String, Object>(references.length);
        for (String reference : references) {
            Object value = xobjectInstance.getAttributeValue(reference);
            values.put(reference, value);
        }
        this.updateModelRow(rowIndex, values);
        return this.modelRow;
    }

    private void initGroup() {
        this.initPresentationGroup();
        this.applyStyle();
        this.applyFocusPersistence();
    }

    private void initPresentationGroup() {
        XFormRepeatable xArray = (XFormRepeatable)this.getPresentationXMLObject();
        this.group = new Group(this.getId(), xArray.getHeaders(), xArray.getHeaderswidth());
        this.group.setReadOnly(!this.isEditable());
        this.group.setCellpadding(xArray.cellpadding);
        this.group.setCellspacing(xArray.cellspacing);
        this.group.setBgColor(xArray.bgcolor);
        this.group.setFgColor(xArray.fgcolor);
        this.group.setHeaderAlignment(xArray.alignment);
        this.group.setHeaderEnabled(xArray.headerenabled);
        this.group.setIndexEnabled(xArray.indexenabled);
        this.group.setHtmlId(this.getId());
        this.group.setTabIndex(this.getTabindex());
        this.group.setIndexTabNavigation(xArray.isIndextabenabled());
        if (xArray.rows > 0) {
            this.currentBeginPageIndex = 0;
            this.currentEndPageIndex = xArray.rows - 1;
            this.rowQtyByPage = xArray.rows;
            this.group.setPagingRange(this.currentBeginPageIndex, this.currentEndPageIndex);
            this.group.setRowQtyWithoutPaging(0);
            this.group.setPagingShowAll(xArray.pagingshowall);
            this.hasPaging = true;
        }
        String addSrc = this.getImage(XObjectRuntimeMsg.GROUP_ADD);
        String addDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_ADD_DISABLED);
        String minusSrc = this.getImage(XObjectRuntimeMsg.GROUP_MINUS);
        String minusDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_MINUS_DISABLED);
        String addUpSrc = this.getImage(XObjectRuntimeMsg.GROUP_ADD_UP);
        String addUpDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_ADD_UP_DISABLED);
        String addDownSrc = this.getImage(XObjectRuntimeMsg.GROUP_ADD_DOWN);
        String addDownDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_ADD_DOWN_DISABLED);
        String removeSrc = this.getImage(XObjectRuntimeMsg.GROUP_REMOVE);
        String removeDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_REMOVE_DISABLED);
        String nextPagingSrc = this.getImage(XObjectRuntimeMsg.GROUP_NEXT_PAGING);
        String prevPagingSrc = this.getImage(XObjectRuntimeMsg.GROUP_PREV_PAGING);
        String nextPagingDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_NEXT_PAGING_DISABLED);
        String prevPagingDisabledSrc = this.getImage(XObjectRuntimeMsg.GROUP_PREV_PAGING_DISABLED);
        String upSrc = this.getImage(XObjectRuntimeMsg.GROUP_SORT_UP);
        String downSrc = this.getImage(XObjectRuntimeMsg.GROUP_SORT_DOWN);
        Locale locale = this.getXScreen().getLocale();
        this.group.setGralToolBarImageSrc(addSrc, addDisabledSrc, minusSrc, minusDisabledSrc);
        this.group.setGralToolBarTooltips(XObjectRuntimeMsg.GROUP_ADD_TOOLTIP.getString(locale), XObjectRuntimeMsg.GROUP_MINUS_TOOLTIP.getString(locale));
        this.group.setSelectToolBarImageSrc(addUpSrc, addUpDisabledSrc, addDownSrc, addDownDisabledSrc, removeSrc, removeDisabledSrc);
        this.group.setSelectToolBarTooltips(XObjectRuntimeMsg.GROUP_ADD_UP_TOOLTIP.getString(locale), XObjectRuntimeMsg.GROUP_ADD_DOWN_TOOLTIP.getString(locale), XObjectRuntimeMsg.GROUP_REMOVE_TOOLTIP.getString(locale));
        this.group.setPrevPagingImageSrc(prevPagingSrc);
        this.group.setNextPagingImageSrc(nextPagingSrc);
        this.group.setPrevPagingDisabledImageSrc(prevPagingDisabledSrc);
        this.group.setNextPagingDisabledImageSrc(nextPagingDisabledSrc);
        this.group.setUpSortImageSrc(upSrc);
        this.group.setDownSortImageSrc(downSrc);
        this.setHeaderText(xArray.headers);
        if (!this.isPreview()) {
            StringBuffer jsBuffer = new StringBuffer();
            jsBuffer.append("doXoAction(");
            jsBuffer.append(4);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setAddJavaScript(jsBuffer.toString());
            jsBuffer = new StringBuffer();
            jsBuffer.append("doXoAction(");
            jsBuffer.append(5);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setRemoveLastJavaScript(jsBuffer.toString());
            jsBuffer = new StringBuffer();
            jsBuffer.append("setGroupSelectedIndexes(getHighLightRowIndexes('");
            jsBuffer.append(this.getId());
            jsBuffer.append("').toString());doXoAction(");
            jsBuffer.append(15);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setRemoveJavaScript(jsBuffer.toString());
            jsBuffer = new StringBuffer();
            jsBuffer.append("setGroupSelectedIndexes(getHighestIndexSelection('");
            jsBuffer.append(this.getId());
            jsBuffer.append("'));doXoAction(");
            jsBuffer.append(17);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setInsertDownJavaScript(jsBuffer.toString());
            jsBuffer = new StringBuffer();
            jsBuffer.append("setGroupSelectedIndexes(getLowestIndexSelection('");
            jsBuffer.append(this.getId());
            jsBuffer.append("'));doXoAction(");
            jsBuffer.append(16);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setInsertUpJavaScript(jsBuffer.toString());
            jsBuffer = new StringBuffer();
            jsBuffer.append("doXoAction(");
            jsBuffer.append(19);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setPrevPagingJavaScript(jsBuffer.toString());
            jsBuffer = new StringBuffer();
            jsBuffer.append("doXoAction(");
            jsBuffer.append(18);
            jsBuffer.append(", '");
            jsBuffer.append(this.getId());
            jsBuffer.append("');forbidSubmitWithErrors();return false;");
            this.group.setNextPagingJavaScript(jsBuffer.toString());
        }
    }

    private void resetPageIndexes() {
        this.currentBeginPageIndex = 0;
        this.currentEndPageIndex = this.rowQtyByPage - 1;
    }
}

