/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.Properties;
import oracle.bpm.xobject.lib.chart.Dimension;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.lib.chart.SwfFactory;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XObjectInternalException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLComponentElement;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponentDelegate;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.IMG;
import oracle.bpm.xobject.xhb.Option;
import oracle.bpm.xobject.xhb.Script;
import oracle.bpm.xobject.xhb.Select;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public abstract class HTMLGraphic
extends HTMLComponentElement
implements XOGraphicComponent {
    private String clickMethodInvocation;
    private String ctrlClickMethodInvocation;
    private String dataMethodInvocation;
    private String dataUrl;
    private DIV flashObjectDiv;
    private Text flashScript;
    private XOGraphicComponentDelegate.GraphicComponentInfo graphicComponentInfo;
    private TR graphicContainerTableFooterTR;
    private TD graphicContainerTableHeaderTD;
    private TR graphicContainerTableHeaderTR;
    private DIV graphicDiv;
    private Select graphicSelectTypes;
    private boolean hasDynamicType;
    private boolean hasErrors;
    private boolean hasForcedRefresh;
    private int refreshRate;
    private Dimension size = Dimension.createDefault();
    private GraphicType type;

    protected HTMLGraphic(XScreen xScreen, XFormGraphic xFormGraphic) {
        super(xScreen, (XFormPresentationXMLObject)xFormGraphic);
        this.initGraphic(xFormGraphic);
        ((XScreenHTMLImpl)xScreen).getPage().initPageWithGraphicElement();
    }

    public abstract String getSWF(SwfFactory var1);

    public abstract String getDummyDataSourceXml();

    public static String getClickeableScript(Object categoryValue, Object serieValue, String id) {
        StringBuilder onClickScriptBuffer = new StringBuilder();
        onClickScriptBuffer.append("graphicClick(");
        onClickScriptBuffer.append(27);
        onClickScriptBuffer.append(", ");
        onClickScriptBuffer.append("['");
        onClickScriptBuffer.append(id);
        onClickScriptBuffer.append("'], ");
        if (categoryValue != null) {
            onClickScriptBuffer.append('\'').append(categoryValue).append('\'');
        } else {
            onClickScriptBuffer.append((String)null);
        }
        onClickScriptBuffer.append(", ");
        if (serieValue != null) {
            onClickScriptBuffer.append('\'').append(serieValue).append('\'');
        } else {
            onClickScriptBuffer.append((String)null);
        }
        onClickScriptBuffer.append(");");
        return onClickScriptBuffer.toString();
    }

    public String getClickeableScript(Object categoryValue, Object serieValue) {
        return HTMLGraphic.getClickeableScript(categoryValue, serieValue, this.getId());
    }

    @Override
    public int getCtrlMethodArgumentQty() {
        return ((XFormGraphic)this.getPresentationXMLObject()).getBackMethodArgumentQty();
    }

    @Override
    public String getCtrlMethodInvocation() {
        if (this.ctrlClickMethodInvocation != null && !this.ctrlClickMethodInvocation.trim().isEmpty()) {
            return this.ctrlClickMethodInvocation;
        }
        return null;
    }

    @Override
    public String getDataMethodInvocation() {
        if (this.dataMethodInvocation != null && !this.dataMethodInvocation.trim().isEmpty()) {
            return this.dataMethodInvocation;
        }
        return null;
    }

    public final String getGraphicHtmlCode() {
        try {
            return this.flashObjectDiv.getHtmlText();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getGraphicImageData() {
        return this.graphicComponentInfo.getGraphicImageData();
    }

    @Override
    public void setGraphicType(GraphicType type) {
        this.type = type;
    }

    @Override
    public GraphicType getGraphicType() {
        return this.type;
    }

    @Override
    public void setHasDynamicType(boolean hasDynamicType) {
        if (this.hasDynamicType() != hasDynamicType) {
            this.hasDynamicType = hasDynamicType;
            if (this.graphicContainerTableHeaderTR != null) {
                this.graphicContainerTableHeaderTR.setStyle(this.getInlineDisplayCCS(this.hasDynamicType()));
            }
        }
    }

    @Override
    public void setHasError(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @Override
    public void setHasForcedRefresh(boolean hasForcedRefresh) {
        if (this.hasForcedRefresh() != hasForcedRefresh) {
            this.hasForcedRefresh = hasForcedRefresh;
            if (this.graphicContainerTableFooterTR != null) {
                this.graphicContainerTableFooterTR.setStyle(this.getInlineDisplayCCS(this.hasForcedRefresh()));
            }
        }
    }

    @Override
    public int getMethodArgumentQty() {
        return ((XFormGraphic)this.getPresentationXMLObject()).getOnClickArgumentQty();
    }

    @Override
    public String getMethodInvocation() {
        if (this.clickMethodInvocation != null && !this.clickMethodInvocation.trim().isEmpty()) {
            return this.clickMethodInvocation;
        }
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Element getPureElement() {
        return this.graphicDiv;
    }

    @Override
    public void setRefreshRate(int rate) {
        this.refreshRate = rate;
    }

    @Override
    public int getRefreshRate() {
        return this.refreshRate;
    }

    @Override
    public void setSize(Dimension dimension) {
        if (dimension != null && !dimension.equals(this.getSize())) {
            this.size = dimension;
            this.recreateGraphic();
        }
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public String getStyle() {
        XFormGraphic xGraphic = (XFormGraphic)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xGraphic.getFonttype(), xGraphic.getFontStyle(), xGraphic.getFontsize()));
            css.append(this.getInlineBorderCSS(xGraphic.borderstyle, xGraphic.bordercolor, xGraphic.borderwidth));
        }
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
    }

    @Override
    public void changeGraphicType(GraphicType type) {
        if (type != null && this.getGraphicType() != type) {
            this.setGraphicType(type);
            XOGraphicComponentDelegate xoGraphicComponentDelegate = this.getXOGraphicComponentDelegate();
            xoGraphicComponentDelegate.recreateGraphic(this.graphicComponentInfo);
            this.selectGraphicType(type);
            this.refreshGraphicScript();
        }
    }

    @Override
    public boolean hasClick() {
        return this.getMethodInvocation() != null;
    }

    @Override
    public boolean hasCtrlClick() {
        return this.getCtrlMethodInvocation() != null;
    }

    @Override
    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    @Override
    public boolean hasError() {
        return this.hasErrors;
    }

    @Override
    public boolean hasForcedRefresh() {
        return this.hasForcedRefresh;
    }

    @Override
    public void refreshImage() throws XObjectInternalException {
        if (!this.isEditor()) {
            this.reloadGraphicData();
        }
        this.refreshGraphicScript();
    }

    public void updateGraphicScript(String text) {
        this.flashScript.setPlainText(text);
    }

    public void addScriptToPerform(String script) {
        ((XScreenHTMLImpl)this.getXScreen()).addScriptToPerform(script, false);
    }

    @Override
    public void recreateGraphic() {
        if (this.graphicComponentInfo != null) {
            XOGraphicComponentDelegate xoGraphicComponentDelegate = this.getXOGraphicComponentDelegate();
            xoGraphicComponentDelegate.recreateGraphic(this.graphicComponentInfo);
            this.refreshGraphicScript();
        }
    }

    public String getDataURL() {
        return this.dataUrl;
    }

    protected abstract XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo() throws XObjectInternalException;

    protected abstract XOGraphicComponentDelegate getXOGraphicComponentDelegate();

    protected abstract String buildGraphicScript(String var1);

    @Override
    protected void _applyStyle(String style) {
        if (this.graphicDiv != null) {
            this.graphicDiv.setStyle(style);
        }
        if (this.graphicContainerTableHeaderTD != null) {
            this.graphicContainerTableHeaderTD.setStyle(this.getHeaderStyle());
        }
    }

    @Override
    protected void _setText(String text) {
        this.recreateGraphic();
    }

    protected void loadGraphicTypes() {
        List<XOGraphicComponentDelegate.GraphicType> graphicTypes = this.getXOGraphicComponentDelegate().getGraphicTypes(this.getXScreen().getRuntimeManager().getLocale());
        for (int i = 0; i < graphicTypes.size(); ++i) {
            XOGraphicComponentDelegate.GraphicType graphicType = graphicTypes.get(i);
            Option option = new Option(String.valueOf(i));
            option.setValue(String.valueOf((Object)graphicType.getGraphicType()));
            option.addChild(new Text(String.valueOf(i), graphicType.getGraphicTypeDescription()));
            if (graphicType.getGraphicType() == this.getGraphicType()) {
                option.setSelected(true);
            } else {
                option.setSelected(false);
            }
            this.graphicSelectTypes.addChild(option);
        }
    }

    @Override
    void _setOnFocus(String js) {
    }

    private void reloadGraphicData() throws XObjectInternalException {
        this.graphicComponentInfo = this.getGraphicComponentInfo();
    }

    private void setDataMethodInvocation(String dataMethodInvocation) {
        this.dataMethodInvocation = dataMethodInvocation;
    }

    private String getHeaderStyle() {
        XFormGraphic xGraphic = (XFormGraphic)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xGraphic.getFonttype(), xGraphic.getFontStyle(), xGraphic.getFontsize()));
        }
        return css.toString();
    }

    private String getHtmlChangeTypeAttString() {
        return XOConstants.createAttGraphicChangeStr(this.getId());
    }

    private void setCtrlMethodInvocation(String ctrlClickMethodInvocation) {
        this.ctrlClickMethodInvocation = ctrlClickMethodInvocation;
    }

    private void setMethodInvocation(String clickMethodInvocation) {
        this.clickMethodInvocation = clickMethodInvocation;
    }

    private void initGraphic(XFormGraphic xGraphic) {
        this.setGraphicType(GraphicType.valueOf(xGraphic.getEnumType()));
        this.setMethodInvocation(xGraphic.getOnclick());
        this.setCtrlMethodInvocation(xGraphic.getBackmethod());
        this.setDataMethodInvocation(xGraphic.getMethodinvocation());
        this.setSize(Dimension.create(xGraphic.getWidth(), xGraphic.getHeight()));
        this.setText(xGraphic.getTitle());
        this.setRefreshRate(xGraphic.getRefreshrate());
        this.setHasForcedRefresh(xGraphic.getHasforcedrefresh());
        this.setHasDynamicType(xGraphic.getHasdynamictype());
        this.graphicDiv = new DIV(this.getId());
        Table graphicContainerTable = new Table();
        this.graphicContainerTableHeaderTR = new TR();
        this.graphicContainerTableHeaderTR.setStyle(this.getInlineDisplayCCS(this.hasDynamicType()));
        this.graphicContainerTableHeaderTD = new TD();
        this.graphicContainerTableHeaderTD.setAlign("center");
        Text graphicTypeText = new Text("graphicTypeText");
        graphicTypeText.setText(XObjectRuntimeMsg.GRAPHIC_TYPE.getString());
        String selectName = this.getHtmlChangeTypeAttString();
        this.graphicSelectTypes = new Select("selectType");
        this.graphicSelectTypes.setName(selectName);
        this.graphicSelectTypes.setHtmlId(selectName);
        if (!this.isPreview()) {
            StringBuilder onChangeTypeScript = new StringBuilder();
            onChangeTypeScript.append("doXoGraphicAction(");
            onChangeTypeScript.append(24);
            onChangeTypeScript.append(", ['");
            onChangeTypeScript.append(this.getHtmlAttString());
            onChangeTypeScript.append("'], ['").append(selectName).append("'])");
            this.graphicSelectTypes.setOnChange(onChangeTypeScript.toString());
        }
        this.graphicContainerTableHeaderTD.addChild(graphicTypeText);
        this.graphicContainerTableHeaderTD.addChild(this.graphicSelectTypes);
        this.graphicContainerTableHeaderTR.addChild(this.graphicContainerTableHeaderTD);
        graphicContainerTable.addChild(this.graphicContainerTableHeaderTR);
        TR graphicContainerTableBodyTR = new TR();
        TD graphicContainerTableBodyTD = new TD();
        this.flashObjectDiv = new DIV();
        this.flashObjectDiv.setHtmlId(this.getHtmlAttString());
        this.flashScript = new Text("flashScript");
        this.flashObjectDiv.addChild(this.flashScript);
        graphicContainerTableBodyTD.addChild(this.flashObjectDiv);
        graphicContainerTableBodyTR.addChild(graphicContainerTableBodyTD);
        graphicContainerTable.addChild(graphicContainerTableBodyTR);
        this.graphicContainerTableFooterTR = new TR();
        this.graphicContainerTableFooterTR.setStyle(this.getInlineDisplayCCS(this.hasForcedRefresh()));
        TD graphicContainerTableFooterTD = new TD();
        graphicContainerTableFooterTD.setAlign("right");
        IMG graphicManualRefreshImage = new IMG("graphicManualRefreshImage");
        String calSrc = this.getImage(XObjectRuntimeMsg.REFRESH);
        if (!this.isPreview()) {
            StringBuilder onClickScript = new StringBuilder();
            onClickScript.append("doXoGraphicAction(");
            onClickScript.append(23);
            onClickScript.append(", ['");
            onClickScript.append(this.getHtmlAttString());
            onClickScript.append("'], null)");
            graphicManualRefreshImage.setOnClick(onClickScript.toString());
            graphicManualRefreshImage.setOnMouseOver("this.style.cursor = 'pointer'");
            graphicManualRefreshImage.setOnMouseOut("this.style.cursor = 'default'");
        }
        graphicManualRefreshImage.setSrc(calSrc);
        graphicManualRefreshImage.setTitle(CoreMsg.REFRESH.getString(this.getXScreen().getRuntimeManager().getLocale()));
        graphicContainerTableFooterTD.addChild(graphicManualRefreshImage);
        this.graphicContainerTableFooterTR.addChild(graphicContainerTableFooterTD);
        graphicContainerTable.addChild(this.graphicContainerTableFooterTR);
        this.graphicDiv.addChild(graphicContainerTable);
        if (!this.isPreview() && this.getRefreshRate() > 0) {
            StringBuilder refreshScriptCode = new StringBuilder();
            refreshScriptCode.append("registerActionToPerform('");
            refreshScriptCode.append(this.getHtmlAttString());
            refreshScriptCode.append("', ");
            refreshScriptCode.append(this.getRefreshRate());
            refreshScriptCode.append(");");
            Script refreshScript = new Script("refreshScript");
            refreshScript.setLanguage("Javascript");
            Text refreshScriptText = new Text();
            refreshScriptText.setText(refreshScriptCode.toString());
            refreshScript.addChild(refreshScriptText);
            this.graphicDiv.addChild(refreshScript);
        }
        this.applyStyle();
    }

    private void refreshGraphicScript() {
        String imageId = this.getHtmlAttString();
        if (!this.isPreview()) {
            String pageId = ((XScreenHTMLImpl)this.getXScreen()).getPage().getDocId();
            String screenId = ((XScreenHTMLImpl)this.getXScreen()).getPage().getScreenId();
            Properties params = new Properties();
            if (imageId != null) {
                params.setProperty("xo$AttName", imageId);
            }
            params.setProperty("xo$DocSessKey", pageId);
            params.setProperty("xo$ScreenSessKey", screenId);
            params.setProperty("xo$dummy", String.valueOf(System.currentTimeMillis()));
            this.dataUrl = this.getXScreen().getRuntimeManager().getUrlBuilder().htmlControllerCall(33, (java.util.Properties)params);
        }
        this.updateGraphicScript(this.buildGraphicScript(this.dataUrl));
    }

    private void selectGraphicType(GraphicType type) {
        if (this.graphicSelectTypes != null) {
            Iterator<Element> options = this.graphicSelectTypes.getAllChilds();
            while (options.hasNext()) {
                Option option = (Option)options.next();
                GraphicType graphicType = GraphicType.valueOf(option.getAttribute("value"));
                boolean isSelected = graphicType != null && graphicType == type;
                option.setSelected(isSelected);
            }
        }
    }
}

