/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLPage;
import oracle.bpm.xobject.runtime.html.UrlBuilder;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponentImpl;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public abstract class HTMLElement
extends XOPresentationComponentImpl
implements Cloneable {
    Text emptyElement_d = new Text("&nbsp;");
    HTMLElement parent_d = null;
    private static HashMap<String, String> imageFilePathsMap = null;
    private static final Msg[] imageArray = new Msg[]{XObjectRuntimeMsg.CALENDAR, XObjectRuntimeMsg.GROUP_ADD, XObjectRuntimeMsg.GROUP_ADD_DISABLED, XObjectRuntimeMsg.GROUP_MINUS, XObjectRuntimeMsg.GROUP_MINUS_DISABLED, XObjectRuntimeMsg.GROUP_SORT_UP, XObjectRuntimeMsg.GROUP_SORT_DOWN, XObjectRuntimeMsg.GROUP_ADD_UP_DISABLED, XObjectRuntimeMsg.GROUP_ADD_DOWN, XObjectRuntimeMsg.GROUP_ADD_DOWN_DISABLED, XObjectRuntimeMsg.GROUP_REMOVE, XObjectRuntimeMsg.GROUP_REMOVE_DISABLED, XObjectRuntimeMsg.GROUP_NEXT_PAGING, XObjectRuntimeMsg.GROUP_PREV_PAGING, XObjectRuntimeMsg.GROUP_NEXT_PAGING_DISABLED, XObjectRuntimeMsg.GROUP_PREV_PAGING_DISABLED, XObjectRuntimeMsg.REFRESH, XObjectRuntimeMsg.BROKEN_IMAGE, XObjectRuntimeMsg.PIE, XObjectRuntimeMsg.BAR_CHART, XObjectRuntimeMsg.SPEEDOMETER};

    public HTMLElement(XScreen xScreen, XFormPresentationXMLObject object) {
        super(xScreen, object);
    }

    HTMLElement(XScreen xScreen) {
        this(xScreen, null);
    }

    public abstract String getStyle();

    public static String getRuntimeImage(UrlBuilder urlBuilder, Msg msg) {
        String imageFile = msg.getImageFile();
        return urlBuilder.urlForStaticImage("XObject", imageFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPreviewImage(Msg msg) {
        if (imageFilePathsMap == null) {
            imageFilePathsMap = new HashMap(imageArray.length);
            for (Msg imageMsg : imageArray) {
                try {
                    InputStream inputStream = imageMsg.getImageResource().openStream();
                    String name = imageMsg.getImageFile();
                    String ext = "";
                    int dotIndex = name.indexOf(46);
                    if (dotIndex != -1) {
                        ext = name.substring(dotIndex);
                        name = name.substring(0, dotIndex);
                    }
                    File file = File.createTempFile(name, ext);
                    file.deleteOnExit();
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        StreamUtils.copy((InputStream)inputStream, (OutputStream)fos);
                    }
                    finally {
                        fos.close();
                    }
                    inputStream.close();
                    imageFilePathsMap.put(imageMsg.getCode(), file.toURI().toURL().toString());
                }
                catch (IOException ioe) {
                    if (!Log.isDebugging()) continue;
                    Log.logDebug((Throwable)ioe);
                }
            }
        }
        return imageFilePathsMap.get(msg.getCode());
    }

    public static HTMLElement newInstance(HTMLElement originalElement) {
        throw new UnsupportedOperationException("[" + originalElement.getPresentationXMLObject().getName() + "/" + originalElement.getId() + "] -> new Instance NOT Implemented!!!");
    }

    public final void setParent(HTMLElement element) {
        this.parent_d = element;
    }

    public final HTMLElement getParent() {
        return this.parent_d;
    }

    public final void applyStyle() {
        this._applyStyle(this.getStyle());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
    }

    public Element getElement() {
        return this.getPureElement();
    }

    protected abstract Element getPureElement();

    protected boolean isClientErrorAsPopup() {
        try {
            return this.getXScreen().getRuntimeManager().getCurrentPModel().presentation_d.isClienterroraspopup();
        }
        catch (Throwable e) {
            return true;
        }
    }

    protected HTMLPage getHTMLPage() {
        HTMLElement element = this.parent_d;
        while (!(element instanceof HTMLPage) && element != null) {
            element = element.parent_d;
        }
        assert (element != null);
        return (HTMLPage)element;
    }

    protected final String getHtmlAttString() {
        return XOConstants.createAttStr(this.getId());
    }

    protected final String getInlineBackgroundColorCCS(String bgcolor) {
        String css = "";
        if (bgcolor != null && !bgcolor.trim().equals("")) {
            css = this.getCSSInlineProperty("background-color", bgcolor);
        }
        return css;
    }

    protected final String getInlineBackgroungImageCSS(String src, String imagelayout, String imagexposition, String imageyposition) {
        StringBuffer css = new StringBuffer();
        css.append("background: url(");
        css.append(src);
        css.append(") ");
        css.append(imagelayout != null ? imagelayout : "no-repeat");
        css.append(" ");
        css.append("fixed");
        css.append(" ");
        css.append(imagexposition != null ? imagexposition : "center");
        css.append(" ");
        css.append(imageyposition != null ? imageyposition : "center");
        css.append(";");
        return css.toString();
    }

    protected final String getInlineBorderCSS(String style, String color, int width) {
        return this.getInlineBorderCSS("border", style, color, width);
    }

    protected final String getInlineBottomBorderCSS(String style, String color, int width) {
        return this.getInlineBorderCSS("border-bottom", style, color, width);
    }

    protected final String getInlineCollapseBorderCCS() {
        return this.getCSSInlineProperty("border-collapse", "collapse");
    }

    protected final String getInlineDisplayCCS(boolean isVisible) {
        return isVisible ? "" : this.getCSSInlineProperty("display", "none");
    }

    protected final String getInlineFontCCS(String fontType, FontStyle fontFace, int fontSize) {
        StringBuffer css = new StringBuffer();
        if (fontSize > 0) {
            css.append(this.getCSSInlineProperty("font-size", String.valueOf(fontSize) + "px"));
        }
        if (fontType != null && !fontType.trim().equals("")) {
            css.append(this.getCSSInlineProperty("font-family", fontType));
        }
        if (fontFace != null) {
            if (fontFace.isBold()) {
                css.append(this.getCSSInlineProperty("font-weight", "bold"));
            }
            if (fontFace.isItalic()) {
                css.append(this.getCSSInlineProperty("font-style", "italic"));
            }
        }
        return css.toString();
    }

    protected final String getInlineWidthCSS(String width) {
        return this.getCSSInlineProperty("width", width);
    }

    protected final String getInlineHeightCSS(String height) {
        return this.getCSSInlineProperty("height", height);
    }

    protected final String getInlineForegroundColorCCS(String fgcolor) {
        String css = "";
        if (fgcolor != null && !fgcolor.trim().equals("")) {
            css = this.getCSSInlineProperty("color", fgcolor);
        }
        return css;
    }

    protected final String getInlineLeftBorderCSS(String style, String color, int width) {
        return this.getInlineBorderCSS("border-left", style, color, width);
    }

    protected final String getInlineRightBorderCSS(String style, String color, int width) {
        return this.getInlineBorderCSS("border-right", style, color, width);
    }

    protected final String getInlineTextAlignmentCSS(String align) {
        return this.getCSSInlineProperty("text-align", align);
    }

    protected final String getInlineTopBorderCSS(String style, String color, int width) {
        return this.getInlineBorderCSS("border-top", style, color, width);
    }

    protected final String getInlineVisibilityCCS(boolean isVisible) {
        return this.getCSSInlineProperty("visibility", isVisible ? "visible" : "hidden");
    }

    protected final String getInlineVisibilityCCS(boolean isVisible, boolean isVisibleCollapsed) {
        if (isVisibleCollapsed) {
            return this.getInlineDisplayCCS(isVisible);
        }
        return this.getInlineVisibilityCCS(isVisible);
    }

    protected void _applyStyle(String style) {
    }

    @Override
    protected void _setBackgroundColor(String color) {
        this.applyStyle();
    }

    @Override
    protected void _setCssClassName(String cssClass) {
        this.applyStyle();
    }

    @Override
    protected void _setForegroundColor(String color) {
        this.applyStyle();
    }

    @Override
    protected void _setLink(String link) {
        this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_NON_SUPPORTED_METHOD("setLink", this.getId()));
    }

    @Override
    protected void _setText(String text) {
        this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_NON_SUPPORTED_METHOD("setText", this.getId()));
    }

    protected String escape(String value, boolean escapeBackSlash) {
        StringBuffer escapeMask = new StringBuffer();
        if (value != null) {
            char[] valueArray;
            block10: for (char ch : valueArray = value.toCharArray()) {
                switch (ch) {
                    case '\\': {
                        if (escapeBackSlash) {
                            escapeMask.append("\\\\");
                            continue block10;
                        }
                        escapeMask.append("\\");
                        continue block10;
                    }
                    case '\n': {
                        escapeMask.append("\\n");
                        continue block10;
                    }
                    case '\t': {
                        escapeMask.append("\\t");
                        continue block10;
                    }
                    case '\r': {
                        escapeMask.append("\\r");
                        continue block10;
                    }
                    case '\b': {
                        escapeMask.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        escapeMask.append("\\f");
                        continue block10;
                    }
                    case '\"': {
                        escapeMask.append("\\'");
                        continue block10;
                    }
                    case '\'': {
                        escapeMask.append("\\'");
                        continue block10;
                    }
                    default: {
                        escapeMask.append(ch);
                    }
                }
            }
        }
        return escapeMask.toString();
    }

    protected void log(Msg Msg2) {
        XScreen xScreen = this.getXScreen();
        if (xScreen.getRuntimeManager().isEmbedded()) {
            Log.logWarning((Msg)Msg2);
        } else {
            Log.logInfo((Msg)Msg2);
        }
    }

    String getImage(Msg msg) {
        XORuntimeManager manager = this.getXScreen().getRuntimeManager();
        UrlBuilder urlBuilder = manager.getUrlBuilder();
        return this.isPreview() ? HTMLElement.getPreviewImage(msg) : HTMLElement.getRuntimeImage(urlBuilder, msg);
    }

    void initElementWithParent() {
    }

    private String getCSSInlineProperty(String propertyName, String propertyValue) {
        StringBuffer inlineProperty = new StringBuffer();
        inlineProperty.append(propertyName);
        inlineProperty.append(":");
        inlineProperty.append(propertyValue);
        inlineProperty.append(";");
        return inlineProperty.toString();
    }

    private String getCSSInlineProperty(String propertyName, String[] propertyValues) {
        StringBuffer inlineProperty = new StringBuffer();
        inlineProperty.append(propertyName);
        inlineProperty.append(":");
        for (String propertyValue : propertyValues) {
            inlineProperty.append(propertyValue);
            inlineProperty.append(" ");
        }
        inlineProperty.append(";");
        return inlineProperty.toString();
    }

    private String getInlineBorderCSS(String propertyName, String style, String color, int width) {
        String css = "";
        if (style != null && style.length() > 0 && color != null && color.length() > 0) {
            css = this.getCSSInlineProperty(propertyName, new String[]{String.valueOf(width).concat("px"), style, color});
        }
        return css;
    }
}

