/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLComponentElement;
import oracle.bpm.xobject.runtime.presentationComponents.XOButtonComponent;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.Text;

public class HTMLButton
extends HTMLComponentElement
implements XOButtonComponent,
Cloneable {
    private Input button;
    private Text displayButton;
    private String methodinvocation = null;

    public HTMLButton(XScreen xScreen, XFormButton b) {
        super(xScreen, (XFormPresentationXMLObject)b);
        if (this.isDisplay()) {
            this.displayButton = new Text(this.getId());
        } else {
            this.initButton();
        }
    }

    public static HTMLButton newInstance(HTMLButton originalElement) {
        return new HTMLButton(originalElement.getXScreen(), (XFormButton)originalElement.getPresentationXMLObject());
    }

    public String getMethodInvocation() {
        return this.methodinvocation;
    }

    @Override
    public void setName(String name) {
        if (this.button != null) {
            this.button.setName(name);
            this.button.setHtmlId(name);
        }
    }

    @Override
    public Element getPureElement() {
        if (this.isDisplay()) {
            return this.displayButton;
        }
        return this.button;
    }

    @Override
    public String getStyle() {
        XFormButton b = (XFormButton)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(b.fonttype, b.getFontStyle(), b.fontsize));
            css.append(this.getInlineBackgroundColorCCS(b.transparent ? "transparent" : this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
            css.append(this.getInlineBorderCSS(b.borderstyle, b.bordercolor, b.borderwidth));
        }
        css.append(this.getInlineVisibilityCCS(!this.isDisplay() && this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.button != null) {
            this.button.setTabindex(tabIndex);
        }
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.button != null) {
            this.button.setDisabled(!editable);
        }
    }

    @Override
    public Object clone() {
        return HTMLButton.newInstance(this);
    }

    @Override
    public String getConfirmationMessage() {
        String message = ((XFormButton)this.getPresentationXMLObject()).getConfirmationmessage();
        if (message != null) {
            message = this.getI18NText(message);
        }
        return message;
    }

    @Override
    protected void _applyStyle(String style) {
        if (this.button != null) {
            this.button.setStyle(style);
            if (this.isCssEnabled()) {
                this.button.setCssClass(this.getCssClassName());
            } else {
                this.button.setCssClass("");
            }
        }
    }

    @Override
    protected void _setText(String text) {
        if (this.button != null) {
            this.button.setValue(text);
        }
    }

    @Override
    void _setOnFocus(String js) {
        this.button.setOnFocus(js);
    }

    void addOnClickEvent(String script) {
        if (this.areEventsAllowed() && this.button != null && script != null && !script.trim().equals("")) {
            this.button.setOnClick(script);
        }
    }

    private void initButton() {
        XFormButton xButton = (XFormButton)this.getPresentationXMLObject();
        String confirmMsg = this.getConfirmationMessage();
        boolean hasConfirmMsg = confirmMsg != null && confirmMsg.trim().length() > 0;
        this.button = new Input(this.getId());
        int action = 9999;
        StringBuffer onClickScript = new StringBuffer();
        if (hasConfirmMsg) {
            onClickScript.append("if(confirm('");
            onClickScript.append(confirmMsg);
            onClickScript.append("')){");
        }
        if (xButton.isSubmit()) {
            this.button.setType("BUTTON");
            action = 7;
            onClickScript.append("forbidSubmitWithErrors();");
        } else if (xButton.isCancel()) {
            this.button.setType("BUTTON");
            action = 8;
            onClickScript.append("allowSubmitWithErrors();");
        } else if (xButton.isReset()) {
            this.button.setType("BUTTON");
            action = 10;
            onClickScript.append("forbidSubmitWithErrors();");
        } else if (xButton.isRefresh()) {
            this.button.setType("BUTTON");
            action = 9;
            onClickScript.append("forbidSubmitWithErrors();");
        } else if (xButton.isAction()) {
            this.button.setType("BUTTON");
            action = 11;
            this.methodinvocation = xButton.methodinvocation;
            onClickScript.append("forbidSubmitWithErrors();");
        } else if (xButton.isPrint()) {
            this.button.setType("BUTTON");
            action = 21;
            onClickScript.append("forbidSubmitWithErrors();");
        } else if (xButton.isSave()) {
            this.button.setType("BUTTON");
            action = 20;
            onClickScript.append("forbidSubmitWithErrors();");
        }
        onClickScript.append("doXoAction(");
        onClickScript.append(action);
        onClickScript.append(", this.name);");
        if (hasConfirmMsg) {
            onClickScript.append("}");
        }
        this.addOnClickEvent(onClickScript.toString());
        this.button.setName(this.getHtmlAttString());
        this.button.setHtmlId(this.getHtmlAttString());
        this.setText(xButton.display);
        this.button.setTabindex(this.getTabindex());
        this.applyStyle();
        this.applyFocusPersistence();
    }
}

