/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.components;

import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.ComponentAction;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.Components;
import oracle.bpm.web.execution.ModelAccessor;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

@Component(module="Fuego.Internal", runsOnServer=false)
public class XObjectShowImpl {
    public void show(Object instance) throws ComponentExecutionException {
        this.show(null, instance);
    }

    public void show(final String selectedPresentation, final Object instance) throws ComponentExecutionException {
        if (instance == null) {
            throw new ComponentExecutionException(XObjectRuntimeMsg.XO_NULL_INST);
        }
        Components.execute((ModelAccessor)new ModelAccessor(){

            public ComponentAction prepare(ComponentContext ctx) throws Exception {
                TimeZone tZone = ctx.getTimeZone();
                Locale locale = ctx.getLocale();
                XOExecutionController controller = XOExecutionController.newHTMLExecution(instance, selectedPresentation, locale, tZone);
                ctx.setAttribute(XOConstants.ATT_EXEC_INST, (Object)controller);
                return new ComponentAction("XObject", "xshow");
            }

            public Object commit(ComponentContext ctx) throws Exception {
                try {
                    XOExecutionController.XOResult result = (XOExecutionController.XOResult)ctx.getAttribute("xoExecResult");
                    if (result.isException()) {
                        Log.logWarning((Throwable)result.getException());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return null;
            }

            public void aborted(ComponentContext ctx) throws Exception {
            }
        });
    }
}

