/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.components;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletException;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.servlet.ParameterNotFoundException;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.Controller;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.Request;
import oracle.bpm.web.execution.impl.WebExternalContext;
import oracle.bpm.web.execution.impl.WebUtils;
import oracle.bpm.xobject.lib.GroupEvent;
import oracle.bpm.xobject.lib.chart.FusionChartsCreator;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.ErrorListener;
import oracle.bpm.xobject.runtime.ExecutionListener;
import oracle.bpm.xobject.runtime.FinishFOExecution;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XOConstants;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobject.runtime.XObjectGroupRowInstance;
import oracle.bpm.xobject.runtime.XObjectInternalException;
import oracle.bpm.xobject.runtime.html.HTMLButton;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.html.HTMLGraphic;
import oracle.bpm.xobject.runtime.html.HTMLGroup;
import oracle.bpm.xobject.runtime.html.HTMLImage;
import oracle.bpm.xobject.runtime.html.WebUrlBuilder;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.ClickeableComponent;
import oracle.bpm.xobject.runtime.presentationComponents.CtrlClickeableComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYZComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XObjectHtmlRuntimeController
implements Controller {
    private static final byte[] BOM = new byte[]{-17, -69, -65};

    public void service(ComponentContext componentContext, ExternalContext externalContext) throws Exception {
        XScreenHTMLImpl doc;
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$Action", "xo$DocSessKey", "xo$ScreenSessKey"});
        int action = 9999;
        String xfdocKey = (String)componentContext.getAttribute("xo$DocSessKey");
        if (xfdocKey == null) {
            ParameterNotFoundException pnfe = new ParameterNotFoundException("xo$DocSessKey");
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_DOCKEY_NOT_FOUND(pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
            return;
        }
        XOExecutionController controller = (XOExecutionController)componentContext.getAttribute(xfdocKey);
        if (controller == null) {
            Exception e = new Exception(XObjectRuntimeMsg.FOBJECT_00001(xfdocKey).getString());
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_XSCREEN_NOT_FOUND(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, e);
            return;
        }
        String screenKey = (String)componentContext.getAttribute("xo$ScreenSessKey");
        if (screenKey == null) {
            ParameterNotFoundException pnfe = new ParameterNotFoundException("xo$ScreenSessKey");
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_DOCKEY_NOT_FOUND(pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
            return;
        }
        try {
            int i = Integer.parseInt(screenKey);
            doc = (XScreenHTMLImpl)controller.getManager(i).getXScreen();
        }
        catch (NumberFormatException e) {
            Log.logDebug((Throwable)e);
            doc = (XScreenHTMLImpl)controller.getCurrentManager().getXScreen();
        }
        if (doc == null) {
            Exception e = new Exception(XObjectRuntimeMsg.FOBJECT_00001(xfdocKey).getString());
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_XSCREEN_NOT_FOUND(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, e);
            return;
        }
        controller.getCurrentManager().setUrlBuilder(new WebUrlBuilder(externalContext));
        try {
            action = this.getIntParameter(request, "xo$Action");
        }
        catch (NumberFormatException nfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_CORRUPTED_ACTION(String.valueOf(action), nfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, nfe);
            return;
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_ACTION_NOT_FOUND(pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        boolean isRemoteScript = true;
        boolean partial = true;
        if (isRemoteScript && partial) {
            if (doc.getElementChangeListener() == null) {
                doc.setElementChangeListener(new XScreenHTMLImpl.HTMLElemnetChangeImpl());
            } else {
                doc.getElementChangeListener().reset();
            }
        }
        doc.cleanErrorStuff();
        String timerValues = null;
        try {
            timerValues = this.getStringParameter(request, "xo$TimerValues");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (timerValues != null && timerValues.trim().length() > 0) {
            doc.restoreTimerValues(timerValues);
        }
        if (!isRemoteScript) {
            String lastFocusId = null;
            try {
                lastFocusId = this.getStringParameter(request, "xo$lastFocusElement");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (lastFocusId != null && lastFocusId.trim().length() > 0) {
                doc.setFocus(lastFocusId);
            }
        }
        try {
            switch (action) {
                case 4: {
                    this.manageArrayAddRow(externalContext, componentContext, doc);
                    break;
                }
                case 5: {
                    this.manageArrayRemoveLastRow(externalContext, componentContext, doc);
                    break;
                }
                case 15: {
                    this.manageArrayRemoveRow(externalContext, componentContext, doc);
                    break;
                }
                case 16: {
                    this.manageArrayInsertUpRow(externalContext, componentContext, doc);
                    break;
                }
                case 17: {
                    this.manageArrayInsertDownRow(externalContext, componentContext, doc);
                    break;
                }
                case 19: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageArrayPrevPage(externalContext, componentContext, doc);
                    break;
                }
                case 18: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageArrayNextPage(externalContext, componentContext, doc);
                    break;
                }
                case 6: {
                    this.manageGetImage(externalContext, doc);
                    break;
                }
                case 12: {
                    this.manageGetBackgroundImage(externalContext, doc);
                    break;
                }
                case 7: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageSubmit(externalContext, componentContext, doc);
                    break;
                }
                case 8: {
                    this.manageCancel(externalContext, componentContext, doc);
                    break;
                }
                case 9: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageRefresh(externalContext, componentContext, doc);
                    break;
                }
                case 10: {
                    this.manageReset(externalContext, componentContext, doc);
                    break;
                }
                case 11: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageAction(externalContext, componentContext, doc);
                    break;
                }
                case 13: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageOnChange(externalContext, componentContext, doc);
                    break;
                }
                case 14: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageOnClick(externalContext, componentContext, doc);
                    break;
                }
                case 25: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageOnCtrlClick(externalContext, componentContext, doc);
                    break;
                }
                case 26: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageGraphicClick(externalContext, componentContext, true, doc);
                    break;
                }
                case 27: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageGraphicClick(externalContext, componentContext, false, doc);
                    break;
                }
                case 20: {
                    this.updateValues(externalContext, componentContext, doc, false);
                    this.manageSave(externalContext, componentContext, doc);
                    break;
                }
                case 21: {
                    this.updateValues(externalContext, componentContext, doc, true);
                    this.managePrint(externalContext, componentContext, doc);
                    break;
                }
                case 33: {
                    this.manageGetGraphicData(externalContext, doc);
                    break;
                }
                case 23: {
                    this.manageRefreshGraphicImage(externalContext, componentContext, doc);
                    break;
                }
                case 24: {
                    this.manageChangeTypeGraphicImage(externalContext, componentContext, doc);
                    break;
                }
                case 28: {
                    this.updateValues(externalContext, componentContext, doc, true);
                    this.manageRepaint(externalContext, componentContext, doc);
                    break;
                }
                case 29: {
                    this.manageStartChild(externalContext, componentContext, doc);
                    break;
                }
                case 30: {
                    this.manageCloseChild(externalContext, componentContext, doc);
                    break;
                }
                case 31: {
                    this.updateValues(externalContext, componentContext, doc, true);
                    this.manageArraySort(externalContext, componentContext, doc);
                    break;
                }
                case 32: {
                    externalContext.finishExecution();
                    break;
                }
                default: {
                    Exception e = new Exception(XObjectRuntimeMsg.FOBJECT_00002.getString());
                    Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_ACTION(String.valueOf(action), e.getMessage()));
                    this.finishExecWithError(externalContext, componentContext, doc, e);
                    break;
                }
            }
        }
        catch (Throwable t) {
            String message = ExceptionFormatter.fullTechLevel((Throwable)t);
            Log.logInfo((Msg)XObjectRuntimeMsg.FOBJECT_ACTION_MANAGEMENT_ERROR(message));
            this.finishExecWithError(externalContext, componentContext, doc, t);
        }
    }

    public int getIntParameter(Request request, String name) throws ParameterNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringParameter(request, name));
    }

    public GraphicType getGraphicTypeParameter(Request request, String name) throws ParameterNotFoundException, NumberFormatException {
        return GraphicType.valueOf(this.getStringParameter(request, name));
    }

    protected String convertPresentationGroupValueToDataValue(String value, String groupDataId, String columnDataId, int index, Locale locale, TimeZone timeZone, XScreenHTMLImpl doc) throws InvalidXOAttributeException, ParseException {
        XOGroupComponent group = (XOGroupComponent)((Object)doc.getPElementWithRef(groupDataId));
        XOInputComponent element = (XOInputComponent)group.getColumnElementByDataId(columnDataId);
        return this.convertPresentationValueToDataValue(value, locale, timeZone, element);
    }

    protected String convertPresentationValueToDataValue(String value, String dataId, Locale locale, TimeZone timeZone, XScreenHTMLImpl doc) throws InvalidXOAttributeException, ParseException {
        XOInputComponent element = (XOInputComponent)((Object)doc.getPElementWithRef(dataId));
        return this.convertPresentationValueToDataValue(value, locale, timeZone, element);
    }

    protected void finishExec(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, String selection) throws IOException, ServletException {
        Object instance = null;
        if (doc != null) {
            instance = doc.getXO().getTarget();
        }
        XOExecutionController.XOResult result = new XOExecutionController.XOResult(instance, selection);
        this.manageFinishExec(externalContext, componentContext, result);
    }

    protected void finishExecWithError(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, Throwable t) throws IOException, ServletException {
        XOExecutionController.XOResult result = new XOExecutionController.XOResult(t);
        this.manageFinishExec(externalContext, componentContext, result);
    }

    protected void manageAction(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        String attId;
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            attId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_BUTTON_ID_NOT_FOUND(pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        String presId = XOConstants.getAttId(attId);
        int i = XOConstants.getGrpIndex(attId);
        String methodInvocation = ((HTMLButton)doc.getPElementWithId(presId)).getMethodInvocation();
        Integer index = i != -1 ? Integer.valueOf(i) : null;
        this.processAction(externalContext, componentContext, doc, methodInvocation, index);
    }

    protected void manageArrayAddRow(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            String groupDataId = doc.getDataIdtWithPressId(groupPresId);
            this.updateValues(externalContext, componentContext, doc, false);
            doc.getXO().addNewRowToGroup(groupDataId);
            doc.getRuntimeManager().refreshPresentation(false);
            XOGroupComponent group = (XOGroupComponent)((Object)doc.getPElementWithRef(groupDataId));
            if (group.hasEventListener()) {
                this.processAction(externalContext, componentContext, doc, group.getEventListener(), -1, new GroupEvent[]{new GroupEvent(0)});
                return;
            }
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_GROUP_ID(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, (Throwable)((Object)e));
        }
    }

    protected void manageArrayInsertDownRow(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            XOGroupComponent group;
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            String selectedIndexesStr = this.getStringParameter(request, "xo$GroupIndexes");
            String groupDataId = doc.getDataIdtWithPressId(groupPresId);
            this.updateValues(externalContext, componentContext, doc, false);
            int selectedIndex = Integer.parseInt(selectedIndexesStr);
            boolean inserDownOk = doc.getXO().insertRowDowntFromGroup(groupDataId, selectedIndex);
            doc.getRuntimeManager().refreshPresentation(false);
            if (inserDownOk && (group = (XOGroupComponent)((Object)doc.getPElementWithRef(groupDataId))).hasEventListener()) {
                this.processAction(externalContext, componentContext, doc, group.getEventListener(), -1, new GroupEvent[]{new GroupEvent(4, new int[]{selectedIndex})});
                return;
            }
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_GROUP_ID(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, (Throwable)((Object)e));
        }
        catch (NumberFormatException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_INDEX_SELECTION(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, e);
        }
    }

    protected void manageArrayInsertUpRow(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            XOGroupComponent group;
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            String selectedIndexesStr = this.getStringParameter(request, "xo$GroupIndexes");
            String groupDataId = doc.getDataIdtWithPressId(groupPresId);
            this.updateValues(externalContext, componentContext, doc, false);
            int selectedIndex = Integer.parseInt(selectedIndexesStr);
            boolean insertUpOk = doc.getXO().insertRowUpFromGroup(groupDataId, selectedIndex);
            doc.getRuntimeManager().refreshPresentation(false);
            if (insertUpOk && (group = (XOGroupComponent)((Object)doc.getPElementWithRef(groupDataId))).hasEventListener()) {
                this.processAction(externalContext, componentContext, doc, group.getEventListener(), -1, new GroupEvent[]{new GroupEvent(3, new int[]{selectedIndex})});
                return;
            }
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_GROUP_ID(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, (Throwable)((Object)e));
        }
        catch (NumberFormatException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_INDEX_SELECTION(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, e);
        }
    }

    protected void manageArrayNextPage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            HTMLGroup group = (HTMLGroup)doc.getPElementWithId(groupPresId);
            group.nextPage();
            doc.getRuntimeManager().refreshPresentation(false);
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
    }

    protected void manageArrayPrevPage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            HTMLGroup group = (HTMLGroup)doc.getPElementWithId(groupPresId);
            group.prevPage();
            doc.getRuntimeManager().refreshPresentation(false);
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
    }

    protected void manageArrayRemoveLastRow(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            XOGroupComponent group;
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            String groupDataId = doc.getDataIdtWithPressId(groupPresId);
            this.updateValues(externalContext, componentContext, doc, false);
            Object removedObject = doc.getXO().removeLastRowFromGroup(groupDataId);
            boolean removeLastOk = removedObject != null;
            doc.getRuntimeManager().refreshPresentation(false);
            if (removeLastOk && (group = (XOGroupComponent)((Object)doc.getPElementWithRef(groupDataId))).hasEventListener()) {
                this.processAction(externalContext, componentContext, doc, group.getEventListener(), -1, new GroupEvent[]{new GroupEvent(1)});
                return;
            }
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_GROUP_ID(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, (Throwable)((Object)e));
        }
    }

    protected void manageArrayRemoveRow(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName", "xo$GroupIndexes"});
        try {
            String groupPresId = this.getStringParameter(request, "xo$AttName");
            String selectedIndexesStr = this.getStringParameter(request, "xo$GroupIndexes");
            String[] indexesStrArray = selectedIndexesStr.split(",");
            int[] indexes = new int[indexesStrArray.length];
            for (int i = 0; i < indexesStrArray.length; ++i) {
                indexes[i] = Integer.parseInt(indexesStrArray[i]);
            }
            String groupDataId = doc.getDataIdtWithPressId(groupPresId);
            this.updateValues(externalContext, componentContext, doc, false);
            doc.getXO().removeRowFromGroup(groupDataId, indexes);
            doc.getRuntimeManager().refreshPresentation(false);
            XOGroupComponent group = (XOGroupComponent)((Object)doc.getPElementWithRef(groupDataId));
            if (group.hasEventListener()) {
                this.processAction(externalContext, componentContext, doc, group.getEventListener(), -1, new GroupEvent[]{new GroupEvent(2, indexes)});
                return;
            }
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_GROUP_ID(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, (Throwable)((Object)e));
        }
        catch (NumberFormatException e) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_INVALID_INDEX_SELECTION(e.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, e);
        }
    }

    protected void manageCancel(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        try {
            doc.processCancel();
        }
        catch (FinishFOExecution finishFOExecution) {
            if (finishFOExecution.isMainExecution()) {
                String result = null;
                this.finishExec(externalContext, componentContext, doc, result);
            }
            doc.getRuntimeManager().refreshPresentation(false);
            this.renderChildPage(externalContext, componentContext, 30, doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageChangeTypeGraphicImage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        WebExternalContext webContext = (WebExternalContext)externalContext;
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            HashMap<String, HTMLGraphic> graphicSrcs = new HashMap<String, HTMLGraphic>(1);
            String attGraphicId = this.getStringParameter(request, "xo$AttName");
            String presAttId = XOConstants.getAttId(attGraphicId);
            String graphicTypeAttName = XOConstants.createAttGraphicChangeStr(presAttId);
            GraphicType graphicType = null;
            try {
                graphicType = this.getGraphicTypeParameter(request, graphicTypeAttName);
            }
            catch (ParameterNotFoundException e) {
                // empty catch block
            }
            HTMLElement e = doc.getPElementWithId(presAttId);
            HTMLGraphic graphic = (HTMLGraphic)e;
            graphic.changeGraphicType(graphicType);
            graphicSrcs.put(attGraphicId, graphic);
            switch (this.getExecutionType(externalContext)) {
                case 1: {
                    if (graphicSrcs != null) {
                        webContext.setResponseContentType("text/xml;charset=UTF-8");
                        PrintWriter out = webContext.getResponseWriter();
                        try {
                            out.println(this.buildXmlGraphicResponse(graphicSrcs));
                            break;
                        }
                        finally {
                            out.flush();
                            out.close();
                        }
                    }
                    webContext.sendResponseError(404);
                    break;
                }
                default: {
                    componentContext.setAttribute("xo$DocSessKey", (Object)doc.getRuntimeManager().getExecutionController().getIdentifier());
                    componentContext.setAttribute("xo$ScreenSessKey", (Object)doc.getIdentifier());
                    externalContext.processAction("XObject", "xoHtmlImpl");
                }
            }
        }
        catch (ParameterNotFoundException pnfe) {
            webContext.sendResponseError(404);
        }
    }

    protected void manageCloseChild(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        boolean isActionInProgress;
        XOExecutionController executionController = doc.getRuntimeManager().getExecutionController();
        int currentStackPosition = executionController.getCurrentManagerStackPosition();
        boolean bl = isActionInProgress = componentContext.getAttribute("xoExecInProgress") != null;
        if (isActionInProgress) {
            --currentStackPosition;
        }
        doc = (XScreenHTMLImpl)executionController.getManager(currentStackPosition).getXScreen();
        this.renderPage(externalContext, componentContext, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageFinishExec(ExternalContext externalContext, ComponentContext componentContext, XOExecutionController.XOResult xoResult) throws IOException, ServletException {
        WebExternalContext webContext = (WebExternalContext)externalContext;
        String url = WebUtils.urlForAction((String)"XObject", (String)"controller", (ExternalContext)externalContext);
        switch (this.getExecutionType(externalContext)) {
            case 1: {
                url = this.addParam(url, "dummyts", String.valueOf(System.currentTimeMillis()));
                url = this.addParam(url, "xo$Action", Integer.toString(32));
                componentContext.setAttribute("xoExecResult", (Object)xoResult);
                webContext.setResponseContentType("text/xml;charset=UTF-8");
                PrintWriter out = webContext.getResponseWriter();
                try {
                    out.println(this.buildXmlFinishResponse(url));
                    break;
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            default: {
                componentContext.setAttribute("xoExecResult", (Object)xoResult);
                externalContext.finishExecution();
            }
        }
    }

    protected void manageGetBackgroundImage(ExternalContext externalContext, XScreenHTMLImpl doc) throws IOException {
        WebExternalContext webContext = (WebExternalContext)externalContext;
        byte[] imgData = doc.getPage().getBgImgBytes();
        if (imgData != null) {
            try {
                webContext.setResponseContentType("image/gif");
                OutputStream op = webContext.getResponseOutputStream();
                op.write(imgData);
                op.flush();
            }
            catch (IOException ioe) {
                webContext.sendResponseError(404);
            }
        } else {
            webContext.sendResponseError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageGetGraphicData(ExternalContext externalContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        block7: {
            WebExternalContext webContext = (WebExternalContext)externalContext;
            Request request = externalContext.getRequest();
            this.checkParameters(request, new String[]{"xo$AttName"});
            try {
                String attGraphicId = this.getStringParameter(request, "xo$AttName");
                String presAttId = XOConstants.getAttId(attGraphicId);
                HTMLElement e = doc.getPElementWithId(presAttId);
                HTMLGraphic graphic = (HTMLGraphic)e;
                String graphicData = graphic.getGraphicImageData();
                if (graphic.hasError()) {
                    graphicData = ">>Error loading graphic data<<";
                }
                if (graphicData != null) {
                    webContext.setResponseContentType("text/xml;charset=UTF-8");
                    OutputStream responseOutputStream = webContext.getResponseOutputStream();
                    responseOutputStream.write(BOM);
                    PrintStream out = new PrintStream(responseOutputStream, false, "UTF-8");
                    try {
                        out.println(graphicData);
                        break block7;
                    }
                    finally {
                        out.flush();
                    }
                }
                webContext.sendResponseError(404);
            }
            catch (ParameterNotFoundException pnfe) {
                webContext.sendResponseError(404);
            }
        }
    }

    protected void manageGetImage(ExternalContext externalContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        assert (externalContext instanceof WebExternalContext) : "This functionality is only supported in web environments";
        WebExternalContext webContext = (WebExternalContext)externalContext;
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            byte[] imgData;
            String attrId;
            String attImageId = this.getStringParameter(request, "xo$AttName");
            try {
                attrId = this.getStringParameter(request, "htmlImageId");
            }
            catch (ParameterNotFoundException pnfe) {
                attrId = null;
            }
            if (attrId == null || !attrId.startsWith("grp$")) {
                HTMLElement e = doc.getPElementWithId(attImageId);
                HTMLImage im = (HTMLImage)e;
                imgData = im.getBytes();
            } else {
                String groupPresId = XOConstants.getGrpId(attrId);
                String groupDataId = doc.getDataIdtWithPressId(groupPresId);
                String groupColumnPresId = XOConstants.getAttId(attrId);
                int index = XOConstants.getGrpIndex(attrId);
                HTMLGroup group = (HTMLGroup)doc.getPElementWithId(groupPresId);
                String groupColumnDataId = group.getDataIdtWithPressId(groupColumnPresId);
                XObjectGroupRowInstance groupXO = doc.getRuntimeManager().getXObject().getGroupXObjectInstance(groupDataId, index);
                imgData = (byte[])groupXO.getAttributeValue(groupColumnDataId);
            }
            if (imgData != null) {
                webContext.setResponseContentType("image/gif");
                OutputStream op = webContext.getResponseOutputStream();
                op.write(imgData);
                op.flush();
            } else {
                webContext.sendResponseError(404);
            }
        }
        catch (ParameterNotFoundException pnfe) {
            webContext.sendResponseError(404);
        }
        catch (InvalidXOAttributeException ixoae) {
            webContext.sendResponseError(404);
        }
    }

    protected void manageGraphicClick(ExternalContext externalContext, ComponentContext componentContext, boolean isCtrlClick, XScreenHTMLImpl doc) throws IOException, ServletException {
        String attId;
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            attId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        XOGraphicComponent comp = (XOGraphicComponent)((Object)doc.getPElementWithId(attId));
        comp.recreateGraphic();
        boolean isCategoryParamNeeded = false;
        boolean isSeriesParamNeeded = false;
        Object[] args = null;
        int argQty = 0;
        String methodInvocation = null;
        if (isCtrlClick) {
            XOGraphicComponent ctrlClickeableComponent = comp;
            methodInvocation = ctrlClickeableComponent.getCtrlMethodInvocation();
            argQty = ctrlClickeableComponent.getCtrlMethodArgumentQty();
        } else {
            XOGraphicComponent clickeableComponent = comp;
            methodInvocation = clickeableComponent.getMethodInvocation();
            argQty = clickeableComponent.getMethodArgumentQty();
        }
        if (comp instanceof XOXYZComponent) {
            if (argQty == 2) {
                isCategoryParamNeeded = true;
                isSeriesParamNeeded = true;
                args = new Object[2];
            }
        } else if (comp instanceof XOXYComponent && argQty == 1) {
            isCategoryParamNeeded = true;
            args = new Object[1];
        }
        if (isCategoryParamNeeded) {
            try {
                String category = this.getStringParameter(request, "fo$graphiclick$category");
                args[0] = category;
            }
            catch (ParameterNotFoundException pnfe) {
                Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("fo$graphiclick$category", pnfe.getMessage()));
                this.finishExecWithError(externalContext, componentContext, doc, pnfe);
                return;
            }
        }
        if (isSeriesParamNeeded) {
            try {
                String series = this.getStringParameter(request, "fo$graphiclick$series");
                args[1] = series;
            }
            catch (ParameterNotFoundException pnfe) {
                GraphicType graphicType = comp.getGraphicType();
                if (graphicType != GraphicType.PIE && graphicType != GraphicType.PIE3D) {
                    Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("fo$graphiclick$series", pnfe.getMessage()));
                    this.finishExecWithError(externalContext, componentContext, doc, pnfe);
                    return;
                }
                args[1] = "";
            }
        }
        Integer index = null;
        this.processAction(externalContext, componentContext, doc, methodInvocation, index, args);
    }

    protected void manageOnChange(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        String attId = null;
        try {
            attId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        String presId = XOConstants.getAttId(attId);
        int i = XOConstants.getGrpIndex(attId);
        XFormUserInputPresentationXMLObject userObject = (XFormUserInputPresentationXMLObject)doc.getPElementWithId(presId).getPresentationXMLObject();
        String methodInvocation = userObject.getOnChange();
        Integer index = i != -1 ? Integer.valueOf(i) : null;
        this.processAction(externalContext, componentContext, doc, methodInvocation, index);
    }

    protected void manageOnClick(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        String attId = null;
        try {
            attId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        String presId = XOConstants.getAttId(attId);
        int i = XOConstants.getGrpIndex(attId);
        ClickeableComponent comp = (ClickeableComponent)((Object)doc.getPElementWithId(presId));
        String methodInvocation = comp.getMethodInvocation();
        Integer index = i != -1 ? Integer.valueOf(i) : null;
        this.processAction(externalContext, componentContext, doc, methodInvocation, index);
    }

    protected void manageOnCtrlClick(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        String attId = null;
        try {
            attId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        String presId = XOConstants.getAttId(attId);
        int i = XOConstants.getGrpIndex(attId);
        CtrlClickeableComponent comp = (CtrlClickeableComponent)((Object)doc.getPElementWithId(presId));
        String methodInvocation = comp.getCtrlMethodInvocation();
        Integer index = i != -1 ? Integer.valueOf(i) : null;
        this.processAction(externalContext, componentContext, doc, methodInvocation, index);
    }

    protected void managePrint(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        doc.processPrint();
        this.renderPage(externalContext, componentContext, doc);
    }

    protected void manageRefresh(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        doc.processRefresh();
        this.renderPage(externalContext, componentContext, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageRefreshGraphicImage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        assert (externalContext instanceof WebExternalContext) : "This functionality is only supported in web environments";
        WebExternalContext webContext = (WebExternalContext)externalContext;
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            String[] attGraphicIds = null;
            HashMap<String, HTMLGraphic> graphicComponents = null;
            String attGraphicIdsStr = this.getStringParameter(request, "xo$AttName");
            StringTokenizer st = new StringTokenizer(attGraphicIdsStr, ",", false);
            attGraphicIds = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                attGraphicIds[i++] = st.nextToken();
            }
            graphicComponents = new HashMap<String, HTMLGraphic>(attGraphicIds.length);
            for (String attGraphicId : attGraphicIds) {
                try {
                    String presAttId = XOConstants.getAttId(attGraphicId);
                    HTMLElement e = doc.getPElementWithId(presAttId);
                    HTMLGraphic graphic = (HTMLGraphic)e;
                    graphic.refreshImage();
                    graphicComponents.put(attGraphicId, graphic);
                }
                catch (XObjectInternalException xie) {
                    Log.logWarning((Throwable)((Object)xie));
                }
            }
            switch (this.getExecutionType(externalContext)) {
                case 1: {
                    webContext.setResponseContentType("text/xml;charset=UTF-8");
                    PrintWriter out = webContext.getResponseWriter();
                    try {
                        out.println(this.buildXmlGraphicRefreshResponse(graphicComponents));
                        break;
                    }
                    finally {
                        out.flush();
                        out.close();
                    }
                }
                default: {
                    componentContext.setAttribute("xo$DocSessKey", (Object)doc.getRuntimeManager().getExecutionController().getIdentifier());
                    componentContext.setAttribute("xo$ScreenSessKey", (Object)doc.getIdentifier());
                    externalContext.processAction("XObject", "xoHtmlImpl");
                }
            }
        }
        catch (ParameterNotFoundException pnfe) {
            webContext.sendResponseError(404);
        }
    }

    protected void manageRepaint(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        this.renderPage(externalContext, componentContext, doc);
    }

    protected void manageReset(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        doc.processReset();
        this.renderPage(externalContext, componentContext, doc);
    }

    protected void manageSave(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        if (doc.isDisplay()) {
            this.finishExec(externalContext, componentContext, doc, null);
            return;
        }
        this.checkParameters(request, new String[]{"xo$AttName"});
        String attBttndId = null;
        try {
            attBttndId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        String presId = XOConstants.getAttId(attBttndId);
        try {
            doc.processSave(presId);
        }
        catch (FinishFOExecution finishFOExecution) {
            if (finishFOExecution.isMainExecution()) {
                this.finishExec(externalContext, componentContext, doc, presId);
                return;
            }
            doc.getRuntimeManager().refreshPresentation(false);
            this.renderChildPage(externalContext, componentContext, 30, doc);
            return;
        }
        doc.getRuntimeManager().refreshPresentation(false);
        this.renderPage(externalContext, componentContext, doc);
    }

    protected void manageStartChild(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        boolean isActionInProgress;
        XOExecutionController executionController = doc.getRuntimeManager().getExecutionController();
        int currentStackPosition = executionController.getCurrentManagerStackPosition();
        boolean bl = isActionInProgress = componentContext.getAttribute("xoExecInProgress") != null;
        if (isActionInProgress) {
            ++currentStackPosition;
        }
        doc = (XScreenHTMLImpl)executionController.getManager(currentStackPosition).getXScreen();
        this.renderPage(externalContext, componentContext, doc);
    }

    protected void manageSubmit(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        if (doc.isDisplay()) {
            this.finishExec(externalContext, componentContext, doc, null);
            return;
        }
        this.checkParameters(request, new String[]{"xo$AttName"});
        String attBttndId = null;
        try {
            attBttndId = this.getStringParameter(request, "xo$AttName");
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, doc, pnfe);
            return;
        }
        String presId = XOConstants.getAttId(attBttndId);
        try {
            doc.processSubmit(presId);
        }
        catch (FinishFOExecution finishFOExecution) {
            if (finishFOExecution.isMainExecution()) {
                this.finishExec(externalContext, componentContext, doc, presId);
                return;
            }
            doc.getRuntimeManager().refreshPresentation(false);
            this.renderChildPage(externalContext, componentContext, 30, doc);
            return;
        }
        doc.getRuntimeManager().refreshPresentation(false);
        this.renderPage(externalContext, componentContext, doc);
    }

    protected void processAction(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, String methodInvocation, Integer index) throws ServletException, IOException {
        this.processAction(externalContext, componentContext, doc, methodInvocation, index, null);
    }

    protected void processAction(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, String methodInvocation, Integer index, Object[] args) throws ServletException, IOException {
        WebExecutionListener executionListener = new WebExecutionListener();
        WebErrorListener errorListener = new WebErrorListener();
        doc.setExecutionListener(executionListener);
        doc.setErrorListener(errorListener);
        doc.processAction(methodInvocation, index, args);
        if (errorListener.isError()) {
            switch (errorListener.getErrorType()) {
                case 0: {
                    componentContext.setAttribute("xo$DocSessKey", (Object)doc.getRuntimeManager().getExecutionController().getIdentifier());
                    componentContext.setAttribute("xo$ScreenSessKey", (Object)doc.getIdentifier());
                    this.showError(externalContext, componentContext, errorListener.getErrorCause(), WebUtils.urlForAction((String)"XObject", (String)"xoHtmlImpl", (ExternalContext)externalContext));
                    break;
                }
                case 1: {
                    this.finishExecWithError(externalContext, componentContext, doc, errorListener.getErrorCause());
                    return;
                }
            }
        }
        if (executionListener.isChildExecutionStarted() || executionListener.isChildExecutionFinished()) {
            this.renderChildPage(externalContext, componentContext, executionListener.isChildExecutionStarted() ? 29 : 30, doc);
            return;
        }
        if (executionListener.isMainExecutionFinished()) {
            this.finishExec(externalContext, componentContext, doc, executionListener.getResult());
            return;
        }
        this.renderPage(externalContext, componentContext, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderChildPage(ExternalContext externalContext, ComponentContext componentContext, int actionId, XScreenHTMLImpl doc) throws IOException, ServletException {
        XOExecutionController executionController = doc.getRuntimeManager().getExecutionController();
        WebExternalContext webContext = (WebExternalContext)externalContext;
        doc = (XScreenHTMLImpl)executionController.getCurrentManager().getXScreen();
        switch (this.getExecutionType(externalContext)) {
            case 1: {
                componentContext.setAttribute("xoExecInProgress", (Object)Boolean.TRUE);
                webContext.setResponseContentType("text/xml;charset=UTF-8");
                PrintWriter out = webContext.getResponseWriter();
                try {
                    out.println(this.buildXmlChildResponse(String.valueOf(actionId)));
                    break;
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            default: {
                this.renderPage(externalContext, componentContext, doc);
            }
        }
    }

    protected void updateValues(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc, boolean refreshPresentation) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        if (doc.isDisplay()) {
            return;
        }
        String changedAtts = null;
        String[] atts = null;
        try {
            changedAtts = this.getStringParameter(request, "xo$ChangedAtts");
        }
        catch (ParameterNotFoundException pnfe) {
            // empty catch block
        }
        if (changedAtts != null) {
            StringTokenizer st = new StringTokenizer(changedAtts, ",", false);
            atts = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                atts[i++] = st.nextToken();
            }
        }
        if (atts != null) {
            for (int j = 0; j < atts.length; ++j) {
                assert (atts[j] != null) : "The attribute name can not be null";
                if (atts[j].startsWith("att$")) {
                    String presAttId = XOConstants.getAttId(atts[j]);
                    String dataId = doc.getDataIdtWithPressId(presAttId);
                    String value = request.getParameter(atts[j]);
                    try {
                        value = this.convertPresentationValueToDataValue(value, dataId, doc.getRuntimeManager().getLocale(), doc.getRuntimeManager().getTimeZone(), doc);
                    }
                    catch (InvalidXOAttributeException e) {
                        Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_DATA_CONVERSION_ERROR(dataId, e.getMessage()));
                        this.finishExecWithError(externalContext, componentContext, doc, (Throwable)((Object)e));
                        return;
                    }
                    catch (ParseException e) {
                        Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_DATA_CONVERSION_ERROR(dataId, e.getMessage()));
                        this.finishExecWithError(externalContext, componentContext, doc, e);
                        return;
                    }
                    try {
                        doc.getRuntimeManager().setInstanceValue(dataId, value);
                        continue;
                    }
                    catch (ComponentExecutionException e) {
                        Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_DATA_CONVERSION_ERROR(dataId, e.getMessage()));
                        this.finishExecWithError(externalContext, componentContext, doc, e);
                        return;
                    }
                }
                if (!atts[j].startsWith("grp$")) continue;
                String groupPresId = XOConstants.getGrpId(atts[j]);
                String groupDataId = doc.getDataIdtWithPressId(groupPresId);
                String groupColumnPresId = XOConstants.getAttId(atts[j]);
                int index = XOConstants.getGrpIndex(atts[j]);
                String value = request.getParameter(atts[j]);
                HTMLGroup group = (HTMLGroup)doc.getPElementWithId(groupPresId);
                String groupColumnDataId = group.getDataIdtWithPressId(groupColumnPresId);
                try {
                    value = this.convertPresentationGroupValueToDataValue(value, groupDataId, groupColumnDataId, index, doc.getRuntimeManager().getLocale(), doc.getRuntimeManager().getTimeZone(), doc);
                }
                catch (InvalidXOAttributeException e) {
                    Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_GROUP_DATA_CONVERSION_ERROR(groupDataId, groupColumnDataId, String.valueOf(index), e.getMessage()));
                    this.finishExecWithError(externalContext, componentContext, doc, (Throwable)((Object)e));
                    return;
                }
                catch (ParseException e) {
                    Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_GROUP_DATA_CONVERSION_ERROR(groupDataId, groupColumnDataId, String.valueOf(index), e.getMessage()));
                    this.finishExecWithError(externalContext, componentContext, doc, e);
                    return;
                }
                try {
                    doc.getRuntimeManager().setGroupInstanceValue(groupDataId, groupColumnDataId, index, value);
                    continue;
                }
                catch (ComponentExecutionException e) {
                    Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_GROUP_DATA_CONVERSION_ERROR(groupDataId, groupColumnDataId, String.valueOf(index), e.getMessage()));
                    this.finishExecWithError(externalContext, componentContext, doc, e);
                }
            }
        }
        if (refreshPresentation) {
            doc.getRuntimeManager().refreshPresentation(false);
        }
    }

    private String getStringParameter(Request request, String name) throws ParameterNotFoundException {
        String[] values = (String[])request.getParameterMap().get(name);
        if (values == null) {
            throw new ParameterNotFoundException(name + " not found");
        }
        if (values[0].length() == 0) {
            throw new ParameterNotFoundException(name + " was empty");
        }
        return values[0];
    }

    private String addParam(String url, String name, String value) {
        String connector = url.indexOf(63) != -1 ? "&" : "?";
        try {
            url = url + connector + name + '=' + URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        return url;
    }

    private int getExecutionType(ExternalContext externalContext) {
        Request request = externalContext.getRequest();
        String execType = request.getParameter("xo$executionType");
        if (execType != null && execType.equals("rscript")) {
            return 1;
        }
        return 0;
    }

    private String buildXmlChildResponse(String screenId) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> attrMap = new HashMap<String, String>(1);
        attrMap.put("actionId", screenId);
        sb.append(this.buildXmlTagResponse("fobject$actionId", attrMap, null));
        return this.buildXmlResponse("CHILD", sb.toString());
    }

    private String buildXmlFinishResponse(String url) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> attrMap = new HashMap<String, String>(1);
        attrMap.put("url", url);
        sb.append(this.buildXmlTagResponse("fobject$finishUrl", attrMap, null));
        return this.buildXmlResponse("FINISH", sb.toString());
    }

    private String buildXmlGraphicResponse(Map<String, HTMLGraphic> graphics) {
        StringBuffer sb = new StringBuffer();
        for (String graphicId : graphics.keySet()) {
            HTMLGraphic htmlGraphic = graphics.get(graphicId);
            HashMap<String, String> attrMap = new HashMap<String, String>(2);
            attrMap.put("justJsToPerform", "true");
            attrMap.put("jsToPerform", FusionChartsCreator.updateChartType(htmlGraphic));
            sb.append(this.buildXmlTagResponse(graphicId, attrMap, ""));
        }
        return this.buildXmlResponse("GRAPHIC", sb.toString());
    }

    private String buildXmlGraphicRefreshResponse(Map<String, HTMLGraphic> graphics) {
        StringBuffer sb = new StringBuffer();
        for (String graphicId : graphics.keySet()) {
            HTMLGraphic htmlGraphic = graphics.get(graphicId);
            HashMap<String, String> attrMap = new HashMap<String, String>(2);
            attrMap.put("justJsToPerform", "true");
            attrMap.put("jsToPerform", FusionChartsCreator.updateChart(htmlGraphic));
            sb.append(this.buildXmlTagResponse(graphicId, attrMap, ""));
        }
        return this.buildXmlResponse("GRAPHIC", sb.toString());
    }

    private String buildXmlRenderResponse(String html, String msgs, String js) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildXmlTagResponse("fobject$Html", html));
        sb.append(this.buildXmlTagResponse("fobject$Messages", msgs));
        sb.append(this.buildXmlTagResponse("fobject$Js", js));
        return this.buildXmlResponse("RENDER", sb.toString());
    }

    private String buildXmlResponse(String responseType, String responseXml) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        sb.append(this.buildXmlTagResponse("fobject$ResponseType", responseType));
        sb.append(responseXml);
        return sb.toString();
    }

    private String buildXmlTagResponse(String tagId, String tagContent) {
        return this.buildXmlTagResponse(tagId, null, tagContent);
    }

    private String buildXmlTagResponse(String tagId, Map<String, String> attrMap, String tagContent) {
        StringBuffer sb = new StringBuffer();
        sb.append("<DIV id=\"");
        sb.append(tagId);
        sb.append("\"");
        if (attrMap != null) {
            for (String attName : attrMap.keySet()) {
                String attValue = attrMap.get(attName);
                sb.append(" ");
                sb.append(attName);
                sb.append("=\"");
                sb.append((Object)attValue);
                sb.append("\"");
            }
        }
        if (tagContent != null) {
            sb.append(">");
            sb.append(tagContent);
            sb.append("</DIV>");
        } else {
            sb.append("'/>");
        }
        return sb.toString();
    }

    private void checkParameters(Request parser, String[] strings) {
    }

    private String convertPresentationValueToDataValue(String value, Locale locale, TimeZone timeZone, XOInputComponent inputComponent) throws ParseException {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        int kind = inputComponent.getKind();
        switch (kind) {
            case 3: 
            case 4: {
                value = value.replace(decimalFormatSymbols.getDecimalSeparator(), '.');
                break;
            }
            case 6: {
                if (!(inputComponent instanceof XODateTimeComponent)) break;
                value = ((XODateTimeComponent)((Object)inputComponent)).convertPresentationValueToDataValue(value);
                break;
            }
            case 1: {
                if (value != null) break;
                value = Boolean.FALSE.toString();
            }
        }
        return value;
    }

    private void manageArraySort(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws IOException, ServletException {
        Request request = externalContext.getRequest();
        this.checkParameters(request, new String[]{"xo$AttName"});
        try {
            String headerId = this.getStringParameter(request, "xo$AttName");
            String[] headerIds = headerId.split("-");
            String groupPresId = headerIds[0];
            int columnIndex = Integer.parseInt(headerIds[1]);
            this.updateValues(externalContext, componentContext, doc, false);
            XOGroupComponent xoGroupComponent = (XOGroupComponent)((Object)doc.getPElementWithId(groupPresId));
            xoGroupComponent.sort(columnIndex);
            doc.getRuntimeManager().refreshPresentation(false);
            this.renderPage(externalContext, componentContext, doc);
        }
        catch (ParameterNotFoundException pnfe) {
            Log.logWarning((Msg)XObjectRuntimeMsg.FOBJECT_PARAM_NOT_FOUND("xo$AttName", pnfe.getMessage()));
            this.finishExecWithError(externalContext, componentContext, null, pnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPage(ExternalContext externalContext, ComponentContext componentContext, XScreenHTMLImpl doc) throws ServletException, IOException {
        WebExternalContext webContext = (WebExternalContext)externalContext;
        componentContext.removeAttribute("xoExecInProgress");
        XOExecutionController executionController = doc.getRuntimeManager().getExecutionController();
        doc = (XScreenHTMLImpl)executionController.getCurrentManager().getXScreen();
        switch (this.getExecutionType(externalContext)) {
            case 1: {
                String html = doc.getFormHtmlText();
                String messageString = doc.getHTMLMsgs();
                String scriptToPerform = doc.getScriptToPerform();
                webContext.setResponseContentType("text/xml;charset=UTF-8");
                PrintWriter out = webContext.getResponseWriter();
                try {
                    out.println(this.buildXmlRenderResponse(html, messageString, scriptToPerform));
                    break;
                }
                finally {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
            }
            default: {
                componentContext.setAttribute("xo$DocSessKey", (Object)executionController.getIdentifier());
                componentContext.setAttribute("xo$ScreenSessKey", (Object)doc.getIdentifier());
                externalContext.processAction("XObject", "xoHtmlImpl");
            }
        }
    }

    private void showError(ExternalContext externalContext, ComponentContext componentContext, Throwable errorCause, String s) {
        System.out.println("Error! " + s + " " + errorCause);
    }

    protected static class WebExecutionListener
    implements ExecutionListener {
        int eventType = 0;
        String result;

        protected WebExecutionListener() {
        }

        public boolean isChildExecutionFinished() {
            return this.eventType == 2;
        }

        public boolean isChildExecutionStarted() {
            return this.eventType == 3;
        }

        public boolean isMainExecutionFinished() {
            return this.eventType == 1;
        }

        @Override
        public int getRegisteredEventType() {
            return this.eventType;
        }

        public String getResult() {
            return this.result;
        }

        @Override
        public void registerFinishChildExecutionEvent() {
            this.eventType = 2;
        }

        @Override
        public void registerFinishMainExecutionEvent(String arg) {
            this.eventType = 1;
            this.result = arg;
        }

        @Override
        public void registerStartChildExecutionEvent() {
            this.eventType = 3;
        }
    }

    protected static class WebErrorListener
    implements ErrorListener {
        protected int errorType_d = -1;
        protected boolean isError_d = false;
        protected Throwable throwable_d;
        public static final int RECOVERABLE_EX = 0;
        public static final int UNRECOVERABLE_EX = 1;

        public boolean isError() {
            return this.isError_d;
        }

        public Throwable getErrorCause() {
            return this.throwable_d;
        }

        public int getErrorType() {
            return this.errorType_d;
        }

        @Override
        public void recoverableError(Throwable t) {
            this.errorType_d = 0;
            this.isError_d = true;
            this.throwable_d = t;
        }

        @Override
        public void unrecoverableError(Throwable t) {
            this.errorType_d = 1;
            this.isError_d = true;
            this.throwable_d = t;
        }
    }
}

