/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.components;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import oracle.bpm.component.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.lib.chart.Dimension;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.lib.chart.Range;
import oracle.bpm.xobject.lib.chart.RangeKind;
import oracle.bpm.xobject.runtime.ShowFOExecution;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XObjectInternalException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.presentationComponents.XOGaugeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYZComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

@oracle.bpm.component.metadata.Component(module="Fuego.Internal")
public class PresentableDelegate
implements Serializable {
    private boolean isInitialize = false;
    private transient XORuntimeManager xoRuntimeManager;
    static final long serialVersionUID = -8306667831081401464L;
    static final long serialCheck = -7321057410597511050L;

    public PresentableDelegate() {
        this.isInitialize = false;
    }

    @Exclude
    public PresentableDelegate(XORuntimeManager xorm) {
        this.setRuntimeManager(xorm);
    }

    public void setChartCategoryLabel(String chartId, String value) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(chartId);
        if (comp != null && comp instanceof XOXYZComponent) {
            XOXYZComponent xoGraphicComponent = (XOXYZComponent)comp;
            xoGraphicComponent.setcategorylabel(value);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setcategorylabel", chartId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(chartId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getChartCategoryLabel(String chartId) {
        this.checkInitialization();
        String categoryLabel = null;
        XOPresentationComponent comp = this.getPressComponent(chartId);
        if (comp != null && comp instanceof XOXYZComponent) {
            XOXYZComponent xoGraphicComponent = (XOXYZComponent)comp;
            categoryLabel = xoGraphicComponent.getcategorylabel();
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getGaugeRange", chartId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(chartId, this.getPresentationName(), this.getFOName()));
        }
        return categoryLabel;
    }

    public void setChartValueLabel(String chartId, String value) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(chartId);
        if (comp != null && comp instanceof XOXYZComponent) {
            XOXYZComponent xoGraphicComponent = (XOXYZComponent)comp;
            xoGraphicComponent.setvaluelabel(value);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setcategorylabel", chartId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(chartId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getChartValueLabel(String chartId) {
        this.checkInitialization();
        String valueLabel = null;
        XOPresentationComponent comp = this.getPressComponent(chartId);
        if (comp != null && comp instanceof XOXYZComponent) {
            XOXYZComponent xoGraphicComponent = (XOXYZComponent)comp;
            valueLabel = xoGraphicComponent.getvaluelabel();
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getGaugeRange", chartId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(chartId, this.getPresentationName(), this.getFOName()));
        }
        return valueLabel;
    }

    public void setGaugeUnit(String chartId, String value) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(chartId);
        if (comp != null && comp instanceof XOGaugeComponent) {
            XOGaugeComponent xoGaugeComponent = (XOGaugeComponent)comp;
            xoGaugeComponent.setUnit(value);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGaugeUnit", chartId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(chartId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setBackgroundColor(String componentId, String color) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setBackgroundColor(color);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setBackgroundColor", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setBackgroundColor(String groupComponentId, String columnComponentId, int index, String color) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                groupComponent.setBgColorProperty(index, columnComponentId, color);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setBackgroundColor", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setBackgroundColor", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getBackgroundColor(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.getBackgroundColor();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getBackgroundColor", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    public String getBackgroundColor(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                return groupComponent.getBgColorProperty(index, columnComponentId);
            }
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("getBackgroundColor", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getBackgroundColor", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
        return null;
    }

    public void setCssClassName(String componentId, String cssClass) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setCssClassName(cssClass);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setCssClassName", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getCssClassName(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.getCssClassName();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getCssClassName", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    public void setEditable(String componentId, boolean editable) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setEditable(editable);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setEditable", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setEditable(String groupComponentId, String columnComponentId, int index, boolean editable) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                groupComponent.setEditableProperty(index, columnComponentId, editable);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setEditable", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setEditable", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public boolean isEditable(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.isEditable();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isEditable", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return true;
    }

    public boolean isEditable(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                return groupComponent.getEditableProperty(index, columnComponentId);
            }
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("isEditable", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isEditable", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
        return true;
    }

    public void setForegroundColor(String componentId, String color) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setForegroundColor(color);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setForegroundColor", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setForegroundColor(String groupComponentId, String columnComponentId, int index, String color) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                groupComponent.setFgColorProperty(index, columnComponentId, color);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setForegroundColor", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setForegroundColor", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getForegroundColor(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.getForegroundColor();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getForegroundColor", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    public String getForegroundColor(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                return groupComponent.getFgColorProperty(index, columnComponentId);
            }
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("getForegroundColor", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getForegroundColor", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
        return null;
    }

    public void setGaugeRange(String gaugeId, RangeKind rangeKind, Range range) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(gaugeId);
        if (comp != null && comp instanceof XOGaugeComponent) {
            XOGaugeComponent xoGraphicComponent = (XOGaugeComponent)comp;
            xoGraphicComponent.changeGaugeRange(rangeKind, range);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGaugeRange", gaugeId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GAUGE_PRESENTATION_ID(gaugeId, this.getPresentationName(), this.getFOName()));
        }
    }

    public Range getGaugeRange(String gaugeId, RangeKind rangeKind) {
        this.checkInitialization();
        Range range = null;
        XOPresentationComponent comp = this.getPressComponent(gaugeId);
        if (comp != null && comp instanceof XOGaugeComponent) {
            XOGaugeComponent xoGraphicComponent = (XOGaugeComponent)comp;
            range = xoGraphicComponent.getRange(rangeKind);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getGaugeRange", gaugeId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GAUGE_PRESENTATION_ID(gaugeId, this.getPresentationName(), this.getFOName()));
        }
        return range;
    }

    public void setGraphicSize(String graphicId, Dimension size) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            XOGraphicComponent xoGraphicComponent = (XOGraphicComponent)comp;
            xoGraphicComponent.setSize(size);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGraphicSize", graphicId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        }
    }

    public Dimension getGraphicSize(String graphicId) {
        this.checkInitialization();
        Dimension size = null;
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            XOGraphicComponent xoGraphicComponent = (XOGraphicComponent)comp;
            size = xoGraphicComponent.getSize();
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getGraphicSize", graphicId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        }
        return size;
    }

    public void setGraphicType(String graphicId, GraphicType graphicType) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            boolean isTypeOk = false;
            String graphicTypeStr = graphicType.getGraphicType();
            if (comp instanceof XOGaugeComponent && graphicTypeStr.equals("GAUGE") || comp instanceof XOXYComponent && graphicTypeStr.equals("XY") || comp instanceof XOXYZComponent && !graphicTypeStr.equals("GAUGE")) {
                isTypeOk = true;
            }
            if (isTypeOk) {
                ((XOGraphicComponent)comp).changeGraphicType(graphicType);
            } else {
                this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_TYPE(this.getPresentationName(), this.getFOName(), graphicType.toString(), graphicId));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGraphicType", graphicId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        }
    }

    public GraphicType getGraphicType(String graphicId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            return ((XOGraphicComponent)comp).getGraphicType();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getGraphicType", graphicId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    public void setGraphicTypeSelection(String graphicId, boolean typeSelection) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            ((XOGraphicComponent)comp).setHasDynamicType(typeSelection);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGraphicTypeSelection", graphicId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        }
    }

    public boolean isGraphicTypeSelection(String graphicId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            return ((XOGraphicComponent)comp).hasDynamicType();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isGraphicTypeSelection", graphicId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        return false;
    }

    public void setGraphicUserRefresh(String graphicId, boolean userRefresh) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            ((XOGraphicComponent)comp).setHasForcedRefresh(userRefresh);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGraphicUserRefresh", graphicId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        }
    }

    public boolean isGraphicUserRefresh(String graphicId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            return ((XOGraphicComponent)comp).hasForcedRefresh();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isGraphicUserRefresh", graphicId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        return false;
    }

    @Method(parameters={"groupComponentId", "headers : String[]"})
    public void setGroupHeaderText(String groupComponentId, List<String> headers) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent && headers != null) {
            String[] headersArray = headers.toArray(new String[headers.size()]);
            ((XOGroupComponent)comp).setHeaderText(headersArray);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setGroupHeaderText", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GROUP_PRESENTATION_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String[] getGroupHeaderText(String groupComponentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            return ((XOGroupComponent)comp).getHeaderText();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getGroupHeaderText", groupComponentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_GROUP_PRESENTATION_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    @Exclude
    public void setInitialize(boolean initialize) {
        this.isInitialize = initialize;
    }

    @Exclude
    public boolean isInitialize() {
        return this.isInitialize;
    }

    public void setLink(String componentId, String link) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setLink(link);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setLink", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setLink(String groupComponentId, String columnComponentId, int index, String link) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                groupComponent.setLinkProperty(index, columnComponentId, link);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setLink", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setLink", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getLink(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.getLink();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getLink", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    public String getLink(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                return groupComponent.getLinkProperty(index, columnComponentId);
            }
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("getLink", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getLink", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
        return null;
    }

    public void setRequired(String componentId, boolean required) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            this.xoRuntimeManager.getXScreen().registerRequired(required, comp.getReference());
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setRequired", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public boolean isRequired(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return this.xoRuntimeManager.getXScreen().isRequired(comp.getReference());
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isRequired", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return false;
    }

    @Exclude
    public void setRuntimeManager(XORuntimeManager rm) {
        this.setInitialize(true);
        this.xoRuntimeManager = rm;
    }

    public void setText(String componentId, String text) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setText(text);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setText", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setText(String groupComponentId, String columnComponentId, int index, String text) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                groupComponent.setTextProperty(index, columnComponentId, text);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setText", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setText", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public String getText(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.getText();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getText", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return null;
    }

    public String getText(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                return groupComponent.getTextProperty(index, columnComponentId);
            }
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("getText", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("getText", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
        return null;
    }

    public void setVisible(String componentId, boolean visible, boolean collapsed) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            comp.setVisible(visible, collapsed);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setVisible", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void setVisible(String groupComponentId, String columnComponentId, int index, boolean visible) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                groupComponent.setVisibleProperty(index, columnComponentId, visible);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setVisible", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setVisible", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public boolean isVisible(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            return comp.isVisible();
        }
        Locale locale = this.xoRuntimeManager.getLocale();
        this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isVisible", componentId, this.getFOName()).getString(locale));
        this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        return true;
    }

    public boolean isVisible(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                return groupComponent.getVisibleProperty(index, columnComponentId);
            }
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("isVisible", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("isVisible", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
        return true;
    }

    public void cancel() {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().processCancel();
    }

    public void focus(String componentId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(componentId);
        if (comp != null) {
            this.xoRuntimeManager.getXScreen().processFocus(componentId);
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("focus", componentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(componentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void focus(String groupComponentId, String columnComponentId, int index) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(groupComponentId);
        if (comp != null && comp instanceof XOGroupComponent) {
            XOGroupComponent groupComponent = (XOGroupComponent)comp;
            if (groupComponent.getColumnElementByPresId(columnComponentId) != null) {
                this.xoRuntimeManager.getXScreen().processFocus(groupComponentId, columnComponentId, index);
            } else {
                Locale locale = this.xoRuntimeManager.getLocale();
                this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_GROUP_ID("setForegroundColor", columnComponentId, groupComponentId, this.getFOName()).getString(locale));
                this.log(XObjectRuntimeMsg.INVALID_PRESENTATION_COMPONENT_GROUP_ID(columnComponentId, groupComponentId, this.getPresentationName(), this.getFOName()));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("setForegroundColor", groupComponentId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_COMPONENT_ID(groupComponentId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void openURL(String url, boolean newWindow, boolean standardBrowser) throws Throwable {
        this.checkInitialization();
        if (url != null) {
            this.xoRuntimeManager.getXScreen().openURL(url, newWindow, standardBrowser);
        }
    }

    public void broadcastViewChangeEvent(String viewId) {
        this.checkInitialization();
        if (viewId != null) {
            this.xoRuntimeManager.getXScreen().broadcastViewChangeEvent(viewId);
        }
    }

    @ReplacementFor(value="printPresentation")
    public void print() {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().printPresentation();
    }

    public void refresh() {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().processRefresh();
    }

    public void refreshGraphicImage(String graphicId) {
        this.checkInitialization();
        XOPresentationComponent comp = this.getPressComponent(graphicId);
        if (comp != null && comp instanceof XOGraphicComponent) {
            try {
                ((XOGraphicComponent)comp).refreshImage();
            }
            catch (XObjectInternalException e) {
                Log.logWarning((Msg)XObjectRuntimeMsg.REFRESH_GRAPHIC_IMAGE_ERROR(this.getPresentationName(), this.getFOName(), graphicId, e.getMessage()));
                Log.logWarning((Throwable)((Object)e));
            }
        } else {
            Locale locale = this.xoRuntimeManager.getLocale();
            this.showWarning(XObjectRuntimeMsg.PRESENTATION_INVALID_COMPONENT_ID("refreshGraphicImage", graphicId, this.getFOName()).getString(locale));
            this.log(XObjectRuntimeMsg.INVALID_GRAPHIC_PRESENTATION_ID(graphicId, this.getPresentationName(), this.getFOName()));
        }
    }

    public void refreshValidValues(String dataId) {
        this.checkInitialization();
        XScreen xScreen = this.xoRuntimeManager.getXScreen();
        XOInputComponent comp = xScreen.getPresComponentWithRef(dataId);
        if (comp != null) {
            String id = comp.getId();
            this.xoRuntimeManager.setPresentationValidValues(id);
        } else {
            this.log(XObjectRuntimeMsg.REFRESH_V_V_INVALID_ATT_NAME(this.getFOName(), this.getCallingMethodName(), dataId));
        }
    }

    @Exclude
    public XORuntimeManager removeRuntimeManager() {
        XORuntimeManager xoRuntimeManager = this.xoRuntimeManager;
        this.xoRuntimeManager = null;
        this.setInitialize(false);
        return xoRuntimeManager;
    }

    public void reset() {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().processReset();
    }

    public void save(String text) {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().processSave(text);
    }

    public void show(Object instance, String presentationName) throws Throwable {
        if (!Component.isRunningOnServerSide()) {
            this.checkInitialization();
            throw new ShowFOExecution(instance, presentationName);
        }
        Invokeable show = Component.instantiateRemoteDynamic((String)"java", null, (String)"Fuego.Internal.XObjectShowImpl", (String)"oracle.bpm.xobject.runtime.components.XObjectShowImpl", (String)"Kfuego.xobject.runtime.components.XObjectShowImpl()", null);
        show.invoke("Mshow(Ljava.lang.String;Ljava.lang.Object;)V", false, new Object[]{"#0", presentationName, "#1", instance}, null);
    }

    public void showError(String error) {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().showError(error);
    }

    public void showWarning(String warning) {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().showWarning(warning);
    }

    public void submit(String text) {
        this.checkInitialization();
        this.xoRuntimeManager.getXScreen().processSubmit(text);
    }

    private String getCallingMethodName() {
        Throwable t = new Throwable();
        StackTraceElement[] stacktrace = t.getStackTrace();
        String name = "";
        if (stacktrace.length > 3) {
            name = stacktrace[3].getMethodName();
        }
        return name;
    }

    private String getFOName() {
        String name = this.xoRuntimeManager.getXObject().getName();
        name = name.substring("xobject".length() + 1, name.length());
        return name;
    }

    private String getPresentationName() {
        return this.xoRuntimeManager.getPresentationName();
    }

    private XOPresentationComponent getPressComponent(String componentId) {
        if (!this.isInitialize) {
            throw new RuntimeException("Cant invoke presentation methods, if it is running on server side");
        }
        return this.xoRuntimeManager.getXScreen().getPresComponentWithId(componentId);
    }

    private void checkInitialization() {
        if (!this.isInitialize) {
            throw new RuntimeException("Cant invoke presentation methods, if it is running on server side");
        }
    }

    private void log(Msg msg) {
        if (this.xoRuntimeManager.isEmbedded()) {
            Log.logWarning((Msg)msg);
        } else {
            Log.logInfo((Msg)msg);
        }
    }
}

