/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

import java.io.Serializable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import oracle.bpm.lang.AbortedException;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Int;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.runtime.ErrorListener;
import oracle.bpm.xobject.runtime.ExecutionListener;
import oracle.bpm.xobject.runtime.XOCOntainer;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.html.UrlBuilder;

public class XOExecutionController
implements ExecutionListener,
ErrorListener {
    private Stack<XOCOntainer> containerStack = new Stack();
    private int currentManagerStackPosition = -1;
    private boolean error_d = false;
    private Throwable errorException_d = null;
    private int eventType = 0;
    private final String identifier;
    private Stack<XORuntimeManager> managerStack = new Stack();
    private boolean preview = false;
    private String selection_d = null;
    private static Integer counter = 0;

    XOExecutionController(Object xObj, XOCOntainer xoc, String selectedPres, int implType, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        this(xObj, xoc, selectedPres, implType, locale, tZone, false);
    }

    XOExecutionController(Object xObj, XOCOntainer xoc, String selectedPres, int implType, Locale locale, TimeZone tZone, boolean preview) throws ComponentExecutionException {
        this.preview = preview;
        XORuntimeManager manager = new XORuntimeManager(this, xObj, selectedPres, implType, locale, tZone);
        this.registerXORuntimeManager(manager);
        this.identifier = this.buildId(manager);
        this.registerContainer(xoc);
    }

    public static XOExecutionController newHTMLExecution(Object xObj, String selectedPres, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        return new XOExecutionController(xObj, null, selectedPres, 11, locale, tZone);
    }

    public static XOExecutionController newHTMLPreview(Object xObj, String selectedPres, Locale locale, TimeZone tZone) throws ComponentExecutionException {
        return new XOExecutionController(xObj, null, selectedPres, 11, locale, tZone, true);
    }

    public static XOExecutionController newSwingExecution(Object xObj, String selectedPres) throws ComponentExecutionException {
        try {
            XOCOntainer xoc = (XOCOntainer)Class.forName("oracle.bpm.xobject.runtime.swing.XOContainerSwingImpl").newInstance();
            return new XOExecutionController(xObj, xoc, selectedPres, 10, Locale.getDefault(), TimeZone.getDefault());
        }
        catch (InstantiationException e) {
            throw new ComponentExecutionException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentExecutionException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentExecutionException((Throwable)e);
        }
    }

    public static XOExecutionController newSwingExecution(Object xObj, XOCOntainer xoc, String selectedPres) throws ComponentExecutionException {
        return new XOExecutionController(xObj, xoc, selectedPres, 10, Locale.getDefault(), TimeZone.getDefault());
    }

    public static XOExecutionController newUXOExecution(Object xObj, XOCOntainer xoc, String selectedPres) throws ComponentExecutionException {
        return new XOExecutionController(xObj, xoc, selectedPres, 10, Locale.getDefault(), TimeZone.getDefault());
    }

    public final XORuntimeManager getCurrentManager() {
        return (XORuntimeManager)this.managerStack.get(this.currentManagerStackPosition);
    }

    public final int getCurrentManagerStackPosition() {
        return this.currentManagerStackPosition;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public final boolean isMainExecution() {
        return this.currentManagerStackPosition == 0;
    }

    public final XORuntimeManager getManager(int stackPosition) {
        this.setCurrentManagerStackPosition(stackPosition);
        return this.getCurrentManager();
    }

    @Override
    public int getRegisteredEventType() {
        return this.eventType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XOResult getXOResult() {
        if (this.getRegisteredEventType() == 1) return new XOResult(this.getCurrentManager().getTarget(), this.selection_d);
        if (!this.error_d) throw new IllegalStateException("Couldn't get result before xo execution is finished");
        return new XOResult(this.errorException_d);
    }

    public void display(UrlBuilder builder) throws ComponentExecutionException {
        XORuntimeManager currentManager = this.getCurrentManager();
        currentManager.setUrlBuilder(builder);
        currentManager.setShowOption(1);
        currentManager.makeXScreen(this, this);
        if (this.getCurrentContainer() != null) {
            this.getCurrentContainer().executeForm(currentManager.getXScreen());
        }
    }

    public void input(UrlBuilder builder) throws ComponentExecutionException {
        XORuntimeManager currentManager = this.getCurrentManager();
        currentManager.setUrlBuilder(builder);
        currentManager.setShowOption(0);
        currentManager.makeXScreen(this, this);
        if (this.getCurrentContainer() != null) {
            this.getCurrentContainer().executeForm(currentManager.getXScreen());
        }
    }

    public void preview() throws ComponentExecutionException {
        try {
            XORuntimeManager currentManager = this.getCurrentManager();
            currentManager.setUrlBuilder(new UrlBuilder(){

                protected String urlImage(String component, String action) {
                    return this.urlForAction(component, action);
                }

                @Override
                protected String urlForAction(String component, String action) {
                    return "";
                }

                @Override
                protected String urlForDynamicImage(String component, String action) {
                    return "";
                }

                @Override
                protected String urlForStaticImage(String component, String action) {
                    return "";
                }
            });
            currentManager.setShowOption(2);
            currentManager.makeXScreen(this, this);
        }
        catch (ComponentExecutionException e) {
            Log.logWarning((Throwable)e);
        }
    }

    @Override
    public void recoverableError(Throwable t) {
        if (this.getCurrentContainer() != null) {
            this.getCurrentContainer().recoverableError(t);
        }
    }

    @Override
    public void registerFinishChildExecutionEvent() {
        this.eventType = 2;
        if (this.getCurrentContainer() != null) {
            this.getCurrentContainer().dispose();
        }
        this.unregisterCurrentContainer();
    }

    @Override
    public void registerFinishMainExecutionEvent(String result) {
        this.eventType = 1;
        this.selection_d = result;
        if (this.getCurrentContainer() != null) {
            this.getCurrentContainer().dispose();
        }
    }

    @Override
    public void registerStartChildExecutionEvent() {
        block2: {
            try {
                XOCOntainer xoc = (XOCOntainer)Class.forName("oracle.bpm.xobject.runtime.swing.XOContainerSwingImpl").newInstance();
                this.registerContainer(xoc);
                this.eventType = 3;
            }
            catch (Throwable t) {
                Log.logDebug((Throwable)t);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"XOCOntainer could not be built!");
            }
        }
    }

    public void show(UrlBuilder builder) throws ComponentExecutionException {
        XORuntimeManager currentManager = this.getCurrentManager();
        currentManager.setUrlBuilder(builder);
        currentManager.setShowOption(3);
        currentManager.makeXScreen(this, this);
        if (this.getCurrentContainer() != null) {
            try {
                this.getCurrentContainer().executeForm(currentManager.getXScreen());
            }
            catch (AbortedException abortedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void unrecoverableError(Throwable t) {
        this.error_d = true;
        this.errorException_d = t;
        this.selection_d = null;
        if (this.getCurrentContainer() != null) {
            this.getCurrentContainer().unrecoverableError(t);
        }
    }

    public boolean isPreview() {
        return this.preview;
    }

    protected final void cleanChildExecutions() {
        while (!this.isCurrentManagerAtStackTop()) {
            this.managerStack.pop();
        }
    }

    protected final void finishChildExecution() {
        assert (!this.isMainExecution()) : "Main execution is not a child one.";
        this.setCurrentManagerStackPosition(this.currentManagerStackPosition - 1);
        try {
            this.getCurrentManager().initPresentableDelegate();
        }
        catch (Throwable t) {
            Log.logWarning((Throwable)t);
        }
    }

    protected final void startChildExecution(Object xObj, String selectedPres) throws ComponentExecutionException {
        assert (!this.managerStack.isEmpty()) : "This method must be called from a running presentation. The execution stack MUST NOT be empty!";
        XORuntimeManager currentManager = this.getCurrentManager();
        XORuntimeManager manager = new XORuntimeManager(this, xObj, selectedPres, currentManager.getImplementationType(), currentManager.getLocale(), currentManager.getTimeZone());
        this.registerXORuntimeManager(manager);
        this.show(currentManager.getUrlBuilder());
    }

    private XOCOntainer getCurrentContainer() {
        return this.containerStack.isEmpty() ? null : this.containerStack.peek();
    }

    private boolean isCurrentManagerAtStackTop() {
        return this.currentManagerStackPosition == this.managerStack.size() - 1;
    }

    private void setCurrentManagerStackPosition(int posistion) {
        this.currentManagerStackPosition = posistion < this.managerStack.size() ? posistion : this.managerStack.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildId(XORuntimeManager manager) {
        Integer n = counter;
        synchronized (n) {
            counter = Int.inc((Integer)counter);
            return manager.getXObject().getName() + System.currentTimeMillis() + counter;
        }
    }

    private void registerContainer(XOCOntainer xoc) {
        if (xoc != null) {
            this.containerStack.push(xoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerXORuntimeManager(XORuntimeManager xoRuntimeManager) {
        Stack<XORuntimeManager> stack = this.managerStack;
        synchronized (stack) {
            this.cleanChildExecutions();
            int targetPosistion = this.managerStack.size();
            xoRuntimeManager.setExecutionStackPosition(targetPosistion);
            this.managerStack.push(xoRuntimeManager);
            this.setCurrentManagerStackPosition(targetPosistion);
        }
    }

    private void unregisterCurrentContainer() {
        if (!this.containerStack.isEmpty()) {
            this.containerStack.pop();
        }
    }

    public static class XOResult
    implements Serializable {
        private Throwable exception_d;
        private boolean isException_d;
        private Object result_d;
        private String selection_d;
        static final long serialVersionUID = 7787148204666159044L;
        static final long serialCheck = -2786933170297463498L;

        public XOResult(Throwable ex) {
            this.result_d = null;
            this.selection_d = null;
            this.exception_d = ex;
            this.isException_d = true;
        }

        public XOResult(Object result, String selection) {
            this.result_d = result;
            this.selection_d = selection;
            this.exception_d = null;
            this.isException_d = false;
        }

        public Throwable getException() {
            return this.exception_d;
        }

        public boolean isException() {
            return this.isException_d;
        }

        public String getSelection() {
            return this.selection_d;
        }

        public Object getXOResult() {
            return this.result_d;
        }
    }
}

