/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormBackground;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormCheck;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormDatetimepiker;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormIframe;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormInterval;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormMultilinetext;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormRadio;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.runtime.ErrorListener;
import oracle.bpm.xobject.runtime.ExecutionListener;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XObjectRuntimeInternalException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;

public abstract class PresentationProcessing {
    protected String cellBColor;
    protected String compBColor;
    protected String presBColor;
    private XORuntimeManager xrm_d;

    protected PresentationProcessing(XORuntimeManager xrm, XScreen screen) {
        this.xrm_d = xrm;
        this.getRManager().setXScreen(screen);
    }

    public static PresentationProcessing get(XORuntimeManager xrm, ExecutionListener dl, ErrorListener el) {
        switch (xrm.getImplementationType()) {
            case 11: {
                return new oracle.bpm.xobject.runtime.html.PresentationProcessing(xrm);
            }
            case 10: {
                try {
                    Class<?> clazz = Class.forName("oracle.bpm.xobject.runtime.swing.PresentationProcessing");
                    Constructor<?> cons = clazz.getConstructor(XORuntimeManager.class, ExecutionListener.class, ErrorListener.class);
                    return (PresentationProcessing)cons.newInstance(xrm, dl, el);
                }
                catch (Exception e) {
                    Log.logSevere((Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    public final XScreen process() throws XObjectRuntimeInternalException {
        this.initPresentation();
        return this.getXScreen();
    }

    protected abstract void setPresBColor(String var1);

    protected abstract void setPresBackground(XFormBackground var1);

    protected abstract void buildPresentation(XFormTable var1) throws XObjectRuntimeInternalException;

    protected abstract XOPresentationComponent initButtonComponent(XFormButton var1);

    protected abstract XOPresentationComponent initCheckComponent(XFormCheck var1);

    protected abstract XOPresentationComponent initComboComponent(XFormCombo var1);

    protected abstract XOPresentationComponent initDateTimePickerComponent(XFormDatetimepiker var1);

    protected abstract XOPresentationComponent initGaugeComponent(XFormGauge var1);

    protected abstract XOPresentationComponent initGroupComponent(XFormArray var1);

    protected abstract XOPresentationComponent initIFrameComponent(XFormIframe var1);

    protected abstract XOPresentationComponent initImageComponent(XFormImage var1);

    protected abstract XOPresentationComponent initIntervalComponent(XFormInterval var1);

    protected abstract XOPresentationComponent initLabelComponent(XFormLabel var1);

    protected abstract XOPresentationComponent initLinkComponent(XFormLink var1);

    protected abstract XOPresentationComponent initRadioComponent(XFormRadio var1);

    protected abstract XOPresentationComponent initRepeatableSection(XFormRepeatablesection var1);

    protected abstract XOPresentationComponent initTableComponent(XFormTable var1, XOGroupComponent var2);

    protected abstract XOPresentationComponent initTextAreaComponent(XFormMultilinetext var1);

    protected abstract XOPresentationComponent initTextfieldComponent(XFormText var1);

    protected abstract XOPresentationComponent initXYComponent(XFormPie var1);

    protected abstract XOPresentationComponent initXYZComponent(XFormChart var1);

    protected XOPresentationComponent getPresentationComponentFromCell(XFormCell xCell, XOGroupComponent group) {
        XOPresentationComponent component = null;
        if (xCell.array != null) {
            component = this.initGroupComponent(xCell.array);
        } else if (xCell.repeatablesection != null) {
            component = this.initRepeatableSection(xCell.repeatablesection);
        } else if (xCell.check != null) {
            component = this.initCheckComponent(xCell.check);
        } else if (xCell.combo != null) {
            component = this.initComboComponent(xCell.combo);
        } else if (xCell.label != null) {
            component = this.initLabelComponent(xCell.label);
        } else if (xCell.link != null) {
            component = this.initLinkComponent(xCell.link);
        } else if (xCell.multilinetext != null) {
            component = this.initTextAreaComponent(xCell.multilinetext);
        } else if (xCell.text != null) {
            component = this.initTextfieldComponent(xCell.text);
        } else if (xCell.radio != null) {
            component = this.initRadioComponent(xCell.radio);
        } else if (xCell.button != null) {
            component = this.initButtonComponent(xCell.button);
        } else if (xCell.image != null) {
            component = this.initImageComponent(xCell.image);
        } else if (xCell.table != null) {
            component = this.initTableComponent(xCell.table, group);
        } else if (xCell.datetimepiker != null) {
            component = this.initDateTimePickerComponent(xCell.datetimepiker);
        } else if (xCell.interval != null) {
            component = this.initIntervalComponent(xCell.interval);
        } else if (xCell.iframe != null) {
            component = this.initIFrameComponent(xCell.iframe);
        } else if (xCell.getGauge() != null) {
            component = this.initGaugeComponent(xCell.getGauge());
        } else if (xCell.getChart() != null) {
            component = this.initXYZComponent(xCell.getChart());
        } else if (xCell.getPie() != null) {
            component = this.initXYComponent(xCell.getPie());
        }
        return component;
    }

    protected Locale getLocale() {
        return this.getRManager().getLocale();
    }

    protected XFormPresentationModel getPresentationModel() throws XObjectRuntimeInternalException {
        return this.getRManager().getCurrentPModel();
    }

    protected XORuntimeManager getRManager() {
        return this.xrm_d;
    }

    protected TimeZone getTimeZone() {
        return this.getRManager().getTimeZone();
    }

    protected XScreen getXScreen() {
        return this.getRManager().getXScreen();
    }

    private void initPresentation() throws XObjectRuntimeInternalException {
        XFormPresentation presentation = this.getPresentationModel().presentation_d;
        this.setPresBColor(presentation.bgcolor);
        XFormTable table = presentation.table;
        this.getXScreen().setInitializer(presentation.initializationmethod);
        this.getXScreen().enableCss(presentation.isCssEnabled());
        if (table != null) {
            this.buildPresentation(table);
        }
        if (presentation.background != null) {
            this.setPresBackground(presentation.background);
        }
    }
}

