/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

public class ConstraintReport {
    private String columnDataId;
    private String dataId;
    private Integer index;
    private String message;
    private String method;
    private int type = -1;
    public static final int ERROR = -1;
    public static final int REQUIRED_ERROR = 0;
    public static final int RUNTIME_METHOD_ERROR = 1;
    public static final int RUNTIME_SETTER_ERROR = 2;
    public static final int RUNTIME_NOT_NULL_ERROR = 3;
    public static final int RUNTIME_FORMAT_ERROR = 4;
    public static final int CHECK_ERROR = 5;

    private ConstraintReport(String method, String msg, int errorType, int index) {
        if (method == null) {
            method = "";
        }
        this.method = method;
        this.message = msg == null ? "" : msg;
        this.index = index < -1 ? null : Integer.valueOf(index);
        this.type = errorType;
    }

    private ConstraintReport(String dataId, String columnDataId, String msg, int errorType, int index) {
        if (dataId == null) {
            dataId = "";
        }
        this.dataId = dataId;
        if (columnDataId == null) {
            columnDataId = "";
        }
        this.columnDataId = columnDataId;
        this.message = msg == null ? "" : msg;
        this.index = index < 0 ? null : Integer.valueOf(index);
        this.type = errorType;
    }

    public static ConstraintReport getCheckErrorReportInstance(String dataId, String m) {
        return new ConstraintReport(dataId, null, m, 5, -1);
    }

    public static ConstraintReport getErrorReportInstance(String dataId, String m) {
        return new ConstraintReport(dataId, null, m, -1, -1);
    }

    public static ConstraintReport getErrorReportInstance(String dataId, String colDataId, String m, int index) {
        return new ConstraintReport(dataId, colDataId, m, -1, index);
    }

    public static ConstraintReport getRequiredErrorReportInstance(String dataId, String m) {
        return new ConstraintReport(dataId, null, m, 0, -1);
    }

    public static ConstraintReport getRequiredErrorReportInstance(String dataId, String columnDataId, String m, int index) {
        return new ConstraintReport(dataId, columnDataId, m, 0, index);
    }

    public static ConstraintReport getRuntimeFormatErrorReportInstance(String dataId, String m) {
        return new ConstraintReport(dataId, null, m, 4, -1);
    }

    public static ConstraintReport getRuntimeFormatErrorReportInstance(String dataId, String columnDataId, String m, int index) {
        return new ConstraintReport(dataId, columnDataId, m, 4, index);
    }

    public static ConstraintReport getRuntimeMethodErrorReportInstance(String method, String msg) {
        return new ConstraintReport(method, msg, 1, -1);
    }

    public static ConstraintReport getRuntimeMethodErrorReportInstance(String method, String msg, int index) {
        return new ConstraintReport(method, msg, 1, index);
    }

    public static ConstraintReport getRuntimeNotNullErrorReportInstance(String dataId, String m) {
        return new ConstraintReport(dataId, null, m, 3, -1);
    }

    public static ConstraintReport getRuntimeNotNullErrorReportInstance(String dataId, String columnDataId, String m, int index) {
        return new ConstraintReport(dataId, columnDataId, m, 3, index);
    }

    public static ConstraintReport getRuntimeSetterErrorReportInstance(String dataId, String m) {
        return new ConstraintReport(dataId, null, m, 2, -1);
    }

    public static ConstraintReport getRuntimeSetterErrorReportInstance(String dataId, String columnDataId, String m, int index) {
        return new ConstraintReport(dataId, columnDataId, m, 2, index);
    }

    public void setColumnDataId(String columnDataId) {
        this.columnDataId = columnDataId;
    }

    public String getColumnDataId() {
        return this.columnDataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public int getErrorType() {
        return this.type;
    }

    public boolean isGroupError() {
        return this.getIndex() != null;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getDataId() + "," + this.getIndex() + "," + this.getMessage() + "]";
    }
}

