/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib.chart;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.Str;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.Utilities;
import oracle.bpm.xobject.lib.XYDataSource;
import oracle.bpm.xobject.lib.XYZDataSource;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.runtime.html.HTMLGraphic;
import oracle.bpm.xobject.runtime.presentationComponents.XOGaugeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOXYZComponent;

public class FusionChartXmlFactory {
    private static final String NAME_AND_VALUE = "{0} = {1}";
    private static final String NAME = "{0}";
    private static final String VALUE = "{1}";
    private static final String PERCENTAGE = "{0} = {2}";
    private static final int TRUE = 1;

    public static String getFusionChartData(XYZDataSource dataSource, XOXYZComponent chart) {
        GraphicProperties properties = new GraphicProperties();
        String title = FusionChartXmlFactory.getEncodedTitle(chart.getText(), chart.isPreview());
        properties.put(GraphicProperty.TITLE, title);
        properties.put(GraphicProperty.CATEGORY_LABEL, chart.getcategorylabel());
        properties.put(GraphicProperty.VALUE_LABEL, chart.getvaluelabel());
        properties.put(GraphicProperty.TYPE, chart.getGraphicType().name());
        return FusionChartXmlFactory.getFusionChartData(dataSource, (XFormChart)chart.getPresentationXMLObject(), chart.getId(), !chart.isPreview(), properties);
    }

    public static String getFusionChartData(XYZDataSource dataSource, XFormChart chart, String id, boolean drillDown) {
        GraphicProperties properties = new GraphicProperties();
        String title = FusionChartXmlFactory.getEncodedTitle(chart.getTitle(), true);
        properties.put(GraphicProperty.TITLE, title);
        return FusionChartXmlFactory.getFusionChartData(dataSource, chart, id, drillDown, properties);
    }

    public static String getFusionChartData(XYZDataSource dataSource, XFormChart chart, String id, boolean drillDown, GraphicProperties properties) {
        String[] series = chart.seriescolors;
        boolean customColorsDefined = series != null && series.length != 0;
        StringBuffer xml = new StringBuffer("<chart ");
        FusionChartXmlFactory.addChartProperties(customColorsDefined, xml, chart, properties);
        if (dataSource != null) {
            FusionChartXmlFactory.addChartData(dataSource, xml, chart, customColorsDefined, id, drillDown);
        }
        FusionChartXmlFactory.addStyleManagedProperties(chart, xml);
        xml.append("</chart>");
        return xml.toString();
    }

    public static String getFusionChartData(XYDataSource dataSource, XOXYComponent pie) {
        GraphicProperties properties = new GraphicProperties();
        String title = FusionChartXmlFactory.getEncodedTitle(pie.getText(), pie.isPreview());
        properties.put(GraphicProperty.TITLE, title);
        return FusionChartXmlFactory.getFusionChartData(dataSource, (XFormPie)pie.getPresentationXMLObject(), pie.getId(), !pie.isPreview(), properties);
    }

    public static String getFusionChartData(XYDataSource dataSource, XFormPie pie, String id, boolean drillDown) {
        GraphicProperties properties = new GraphicProperties();
        String title = FusionChartXmlFactory.getEncodedTitle(pie.getTitle(), true);
        properties.put(GraphicProperty.TITLE, title);
        return FusionChartXmlFactory.getFusionChartData(dataSource, pie, id, drillDown, properties);
    }

    public static String getFusionChartData(XYDataSource dataSource, XFormPie pie, String id, boolean drillDown, GraphicProperties properties) {
        String[] series = pie.seriescolors;
        boolean customColorsDefined = series != null && series.length != 0;
        StringBuffer xml = new StringBuffer();
        xml.append("<chart ");
        FusionChartXmlFactory.addPieProperties(customColorsDefined, xml, (XFormChart)pie, properties);
        if (dataSource != null) {
            FusionChartXmlFactory.addPieData(dataSource, xml, (XFormChart)pie, customColorsDefined, id, drillDown);
        }
        FusionChartXmlFactory.addStyleManagedProperties((XFormChart)pie, xml);
        xml.append("</chart>");
        return xml.toString();
    }

    public static String getFusionChartData(Number dataSource, XOGaugeComponent gauge) {
        GraphicProperties properties = new GraphicProperties();
        properties.put(GraphicProperty.TYPE, gauge.getGraphicType().name());
        properties.put(GraphicProperty.VALUE_LABEL, String.valueOf(gauge.getUnit()));
        return FusionChartXmlFactory.getFusionChartData(dataSource, (XFormGauge)gauge.getPresentationXMLObject(), gauge.getId(), !gauge.isPreview(), properties);
    }

    public static String getFusionChartData(Number dataSource, XFormGauge gauge, String id, boolean drillDown) {
        GraphicProperties properties = new GraphicProperties();
        return FusionChartXmlFactory.getFusionChartData(dataSource, gauge, id, drillDown, properties);
    }

    public static String getFusionChartData(Number dataSource, XFormGauge gauge, String id, boolean drillDown, GraphicProperties properties) {
        GraphicType graphicType = GraphicType.valueOf(gauge.getEnumType());
        if (properties != null) {
            String type = properties.get(GraphicProperty.TYPE);
            graphicType = type != null ? GraphicType.valueOf(type) : graphicType;
        }
        String result = graphicType == GraphicType.GAUGE_SPEEDOMETER ? FusionChartXmlFactory.buildSpeedometer(gauge, dataSource, id, drillDown, properties) : FusionChartXmlFactory.buildThermometer(gauge, dataSource, id, drillDown, properties);
        return result;
    }

    static String getEncodedTitle(String title, boolean preview) {
        String result = null;
        if (title != null) {
            result = preview ? Str.encodeURL((String)title) : Str.toXMLString((String)title);
        }
        return result;
    }

    private static String buildThermometer(XFormGauge gauge, Number dataSource, String id, boolean drillDown, GraphicProperties properties) {
        String tmpUnits;
        int bulbRadius = gauge.getWidth() / 9;
        StringBuffer xml = new StringBuffer();
        xml.append("<chart ");
        if (drillDown && gauge.getOnclick() != null) {
            FusionChartXmlFactory.addGaugeDrillDown(xml, id);
        }
        String units = (tmpUnits = properties.get(GraphicProperty.VALUE_LABEL)) == null || "null".equals(tmpUnits) ? "" : tmpUnits;
        FusionChartXmlFactory.addGaugesCommonProperties(gauge, xml, properties);
        int height = gauge.getHeight() - bulbRadius - gauge.getHeight() / 4;
        xml.append("thmHeight='").append(height).append("' ");
        xml.append("thmFillColor='").append(FusionChartXmlFactory.getThermometerColor(gauge, dataSource)).append("' ");
        xml.append("thmBulbRadius='").append(bulbRadius).append("' ");
        xml.append("chartLeftMargin='").append(gauge.getWidth() / 9 * 4).append("' ");
        xml.append("numberSuffix=' " + units + "' ");
        xml.append(">");
        xml.append("<value>");
        Number value = dataSource != null ? (Number)dataSource : (Number)0;
        xml.append(value);
        xml.append("</value>");
        xml.append("</chart>");
        return xml.toString();
    }

    private static String getThermometerColor(XFormGauge gauge, Number dataSource) {
        String normalColor = gauge.normalcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.normalcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.GREEN));
        String warningColor = gauge.warningcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.warningcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.YELLOW));
        String criticalColor = gauge.criticalcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.criticalcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.RED));
        String color = gauge.contentcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.contentcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.GRAY));
        double value = dataSource.doubleValue();
        if (value >= gauge.getNormal_level() && value <= gauge.getNormal_level_max()) {
            color = normalColor;
        } else if (value >= gauge.getWarning_level() && value <= gauge.getWarning_level_max()) {
            color = warningColor;
        } else if (value >= gauge.getAlarm_level() && value <= gauge.getAlarm_level_max()) {
            color = criticalColor;
        }
        return color;
    }

    private static String buildSpeedometer(XFormGauge gauge, Number dataSource, String id, boolean drillDown, GraphicProperties properties) {
        String valueColor = gauge.valuecolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.valuecolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.WHITE));
        int height = gauge.getHeight() - 15;
        int radius = height / 2;
        int innerRadius = height / 2 - 5;
        String tmpUnits = properties.get(GraphicProperty.VALUE_LABEL);
        String units = tmpUnits == null || "null".equals(tmpUnits) ? "" : tmpUnits;
        StringBuffer xml = new StringBuffer();
        xml.append("<chart ");
        if (drillDown && gauge.getOnclick() != null) {
            FusionChartXmlFactory.addGaugeDrillDown(xml, id);
        }
        FusionChartXmlFactory.addGaugesCommonProperties(gauge, xml, properties);
        xml.append("gaugeScaleAngle='270' ");
        xml.append("pivotBgColor='").append(valueColor).append("' ");
        xml.append("placeValuesInside='1' ");
        xml.append("majorTMColor='").append(valueColor).append("' ");
        xml.append("minorTMColor='").append(valueColor).append("' ");
        xml.append("gaugeInnerRadius='").append(innerRadius).append("' ");
        xml.append("numberSuffix=' " + units + "' ");
        xml.append(">");
        FusionChartXmlFactory.addRanges(gauge, xml);
        Number value = dataSource != null ? (Number)dataSource : (Number)0;
        FusionChartXmlFactory.addDials(xml, value, valueColor, radius);
        FusionChartXmlFactory.addSpeedometerBackground(xml, gauge, radius);
        xml.append("</chart>");
        return xml.toString();
    }

    private static void addGaugeDrillDown(StringBuffer xml, String id) {
        xml.append("clickURL='");
        xml.append("JavaScript:");
        xml.append("drillDown_").append(id).append("();");
        xml.append("' ");
    }

    private static void addGaugesCommonProperties(XFormGauge gauge, StringBuffer xml, GraphicProperties properties) {
        String valueColor;
        if (gauge.bgcolor != null) {
            String background = FusionChartXmlFactory.getHexColorWithoutSharp(gauge.bgcolor);
            xml.append("bgcolor='").append(background).append("' ");
        }
        xml.append("upperLimit='").append(gauge.getMax_limit()).append("' ");
        xml.append("lowerlimit='").append(gauge.getMin_limit()).append("' ");
        xml.append("formatNumber='0' ");
        String units = gauge.getUnit();
        if (units != null && !"".equals(units)) {
            xml.append("numberSuffix='").append(units).append("' ");
        }
        if (gauge.valuecolor != null) {
            valueColor = FusionChartXmlFactory.getHexColorWithoutSharp(gauge.valuecolor);
        } else {
            GraphicType graphicType = GraphicType.valueOf(properties.get(GraphicProperty.TYPE));
            ColorInfo defaultValueColor = graphicType == GraphicType.GAUGE_SPEEDOMETER ? ColorInfo.WHITE : ColorInfo.BLACK;
            valueColor = FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(defaultValueColor));
        }
        xml.append("baseFontColor='").append(valueColor).append("' ");
        xml.append("baseFontSize='").append(gauge.valuefontsize).append("' ");
        xml.append("baseFont='").append(gauge.valuefonttype).append("' ");
        xml.append("showBorder='0' ");
        xml.append("showValue='1' ");
    }

    private static void addSpeedometerBackground(StringBuffer xml, XFormGauge gauge, int radius) {
        xml.append("<customObjects>");
        int yPosition = gauge.getWidth() / 2;
        int xPosition = gauge.getWidth() > gauge.getHeight() - 20 ? gauge.getWidth() / 2 : yPosition;
        xml.append("<objectGroup ");
        xml.append("xPos='").append(xPosition).append("' ");
        xml.append("yPos='").append(yPosition).append("' ");
        xml.append("showBelowChart='1'>");
        xml.append("<object type='circle' radius='").append(radius).append("' ");
        xml.append("toYPos='").append(yPosition).append("' ");
        xml.append("toXPos='").append(xPosition).append("' ");
        xml.append("showBorder='0' ");
        String contentcolor = gauge.contentcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.contentcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.BLACK));
        xml.append("fillColor='333333,").append(contentcolor).append("' ");
        xml.append("fillRatio='5, 95' fillAsGradient='1'");
        xml.append("/>");
        xml.append("</objectGroup>");
        xml.append("</customObjects>");
    }

    private static void addDials(StringBuffer xml, Number dataSource, String valueColor, int radius) {
        xml.append("<dials>");
        xml.append("<dial value='").append(dataSource).append("' ");
        xml.append("bgColor='").append(valueColor).append("' ");
        xml.append("borderColor='").append(valueColor).append("' ");
        xml.append("radius='").append(radius - 35).append("' ");
        xml.append("/>");
        xml.append("</dials>");
    }

    private static void addRanges(XFormGauge gauge, StringBuffer xml) {
        String normalColor = gauge.normalcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.normalcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.GREEN));
        String warningColor = gauge.warningcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.warningcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.YELLOW));
        String criticalColor = gauge.criticalcolor != null ? FusionChartXmlFactory.getHexColorWithoutSharp(gauge.criticalcolor) : FusionChartXmlFactory.getHexColorWithoutSharp(Utilities.getString(ColorInfo.RED));
        xml.append("<colorRange>");
        xml.append("<color minValue='").append(gauge.getNormal_level()).append("' ");
        xml.append("maxValue='").append(gauge.getNormal_level_max()).append("' ");
        xml.append("code='").append(normalColor).append("'/>");
        xml.append("<color minValue='").append(gauge.getWarning_level()).append("' ");
        xml.append("maxValue='").append(gauge.getWarning_level_max()).append("' ");
        xml.append("code='").append(warningColor).append("'/>");
        xml.append("<color minValue='").append(gauge.getAlarm_level()).append("' ");
        xml.append("maxValue='").append(gauge.getAlarm_level_max()).append("' ");
        xml.append("code='").append(criticalColor).append("'/>");
        xml.append("</colorRange>");
    }

    private static void addPieData(XYDataSource dataSource, StringBuffer xml, XFormChart pie, boolean customColorsDefined, String id, boolean drillDown) {
        String onclickMethod = pie.getOnclick();
        for (int i = 0; i < dataSource.getRowCount(); ++i) {
            for (int j = 0; j < dataSource.getColumnCount(); ++j) {
                xml.append("<set label='");
                String slice = dataSource.getColumnHeaderAt(j);
                xml.append(slice);
                xml.append("' value='");
                xml.append(dataSource.getValueAt(i, j));
                xml.append("' ");
                if (customColorsDefined && j < pie.seriescolors.length) {
                    FusionChartXmlFactory.addColor(xml, pie.seriescolors[j]);
                }
                if (drillDown && onclickMethod != null) {
                    FusionChartXmlFactory.addDrillDown(slice, null, id, xml);
                }
                xml.append("/>");
            }
        }
    }

    private static void addChartData(XYZDataSource dataSource, StringBuffer xml, XFormChart chart, boolean customColorsDefined, String id, boolean drillDown) {
        String onclickMethod = chart.getOnclick();
        xml.append("<categories>");
        for (int j = 0; j < dataSource.getColumnCount(); ++j) {
            String categoryLabel = dataSource.getColumnHeaderAt(j);
            xml.append("<category label='").append(categoryLabel).append("'/>");
        }
        xml.append("</categories>");
        for (int i = 0; i < dataSource.getRowCount(); ++i) {
            String seriesName = dataSource.getRowHeaderAt(i);
            xml.append("<dataset seriesName='").append(seriesName).append("' ");
            if (customColorsDefined && i < chart.seriescolors.length) {
                String color = chart.seriescolors[i];
                FusionChartXmlFactory.addColor(xml, color);
                FusionChartXmlFactory.addLegendColor(xml, color);
            }
            xml.append(">");
            for (int j = 0; j < dataSource.getColumnCount(); ++j) {
                String categoryLabel = dataSource.getColumnHeaderAt(j);
                xml.append("<set value='").append(dataSource.getValueAt(i, j)).append("' ");
                if (drillDown && onclickMethod != null) {
                    FusionChartXmlFactory.addDrillDown(categoryLabel, seriesName, id, xml);
                }
                xml.append("/>");
            }
            xml.append("</dataset>");
        }
    }

    private static void addDrillDown(String categoryLabel, String seriesValue, String id, StringBuffer xml) {
        String clickeableScript = HTMLGraphic.getClickeableScript(categoryLabel, seriesValue, id);
        xml.append("link=\"JavaScript:");
        xml.append(clickeableScript);
        xml.append("\" ");
    }

    private static void addStyleManagedProperties(XFormChart chart, StringBuffer xml) {
        xml.append("<styles>");
        xml.append("<definition>");
        String titleFontStyle = "AlbpmCaptionFont";
        FusionChartXmlFactory.addTitleFontStyle(titleFontStyle, chart, xml);
        String labelFontStyle = "AlbpmLegendFont";
        FusionChartXmlFactory.addLabelFontStyle(labelFontStyle, chart, xml);
        String shadowStyle = "AlbpmShadow";
        FusionChartXmlFactory.addShadowStyle(shadowStyle, chart, xml);
        xml.append("</definition>");
        xml.append("<application>");
        xml.append("<apply toObject='Caption' styles='");
        xml.append(titleFontStyle);
        xml.append("' />");
        xml.append("<apply toObject='DataValues' styles='");
        xml.append(labelFontStyle);
        xml.append("' />");
        if (chart.shadowcolor != null) {
            xml.append("<apply toObject='DataPlot' styles='");
            xml.append(shadowStyle);
            xml.append("' />");
        }
        xml.append("</application>");
        xml.append("</styles>");
    }

    private static void addShadowStyle(String shadowStyle, XFormChart chart, StringBuffer xml) {
        String shadowColor = chart.shadowcolor;
        if (shadowColor != null) {
            shadowColor = FusionChartXmlFactory.getHexColorWithoutSharp(shadowColor);
            xml.append("<style name='").append(shadowStyle);
            xml.append("' type='Shadow' strength='3' angle='60' ");
            xml.append("color='").append(shadowColor);
            xml.append("' />");
        }
    }

    private static String getHexColorWithoutSharp(String shadowColor) {
        return shadowColor.substring(1);
    }

    private static void addLabelFontStyle(String name, XFormChart chart, StringBuffer xml) {
        FontStyleBuilder styleBuilder = new FontStyleBuilder(name);
        styleBuilder.setFont(chart.valuefonttype);
        styleBuilder.setSize(chart.valuefontsize);
        styleBuilder.setForegroundColor(chart.valuecolor);
        styleBuilder.setFontType(chart.valuefontface.toString());
        xml.append(styleBuilder.build());
    }

    private static void addColor(StringBuffer xml, String color) {
        xml.append("color='");
        xml.append(FusionChartXmlFactory.getHexColorWithoutSharp(color));
        xml.append("' ");
    }

    private static void addChartProperties(boolean customColorsDefined, StringBuffer xml, XFormChart chart, GraphicProperties properties) {
        FusionChartXmlFactory.addCommonProperties(customColorsDefined, xml, chart, properties);
        FusionChartXmlFactory.addPlotOutlineColor(chart, xml);
        FusionChartXmlFactory.addPlotBackgroundColor(chart, xml);
        xml.append("plotSpacePercent='40' ");
        xml.append("decimals='3' ");
        FusionChartXmlFactory.addAxisLabels(xml, properties);
        xml.append(">");
    }

    private static void addAxisLabels(StringBuffer xml, GraphicProperties properties) {
        xml.append("xAxisName='");
        xml.append(properties.get(GraphicProperty.CATEGORY_LABEL));
        xml.append("'");
        xml.append("yAxisName='");
        xml.append(properties.get(GraphicProperty.VALUE_LABEL));
        xml.append("' ");
    }

    private static void addPieProperties(boolean customColorsDefined, StringBuffer xml, XFormChart pie, GraphicProperties properties) {
        FusionChartXmlFactory.addCommonProperties(customColorsDefined, xml, pie, properties);
        xml.append(">");
    }

    private static void addCommonProperties(boolean customColorsDefined, StringBuffer xml, XFormChart chart, GraphicProperties properties) {
        if (!customColorsDefined) {
            xml.append("palette='4' ");
        }
        xml.append("showBorder='0' ");
        FusionChartXmlFactory.addTitle(properties.get(GraphicProperty.TITLE), xml);
        FusionChartXmlFactory.addShowLegend(chart, xml);
        FusionChartXmlFactory.addBackgroundColor((XFormGraphic)chart, xml);
        FusionChartXmlFactory.addOutlineColor(chart, xml);
        FusionChartXmlFactory.addValueFormat(chart, xml);
        FusionChartXmlFactory.addShadow(chart, xml);
        FusionChartXmlFactory.addAutoRange(chart, xml);
    }

    private static void addAutoRange(XFormChart chart, StringBuffer xml) {
        if (!chart.autorangeincludeszero) {
            xml.append("setAdaptiveYMin='1' ");
        }
    }

    private static void addShowLegend(XFormChart chart, StringBuffer xml) {
        boolean showLegend = chart.getShowLegend();
        if (!showLegend) {
            xml.append("showLegend='0' ");
        }
    }

    private static void addValueFormat(XFormChart chart, StringBuffer xml) {
        xml.append("showPercentInToolTip='0' ");
        String valueFormat = chart.getItemlabelmask();
        if (NAME.equals(valueFormat) || NAME_AND_VALUE.equals(valueFormat) || PERCENTAGE.equals(valueFormat)) {
            xml.append("showLabels='1' ");
        } else {
            xml.append("showLabels='0' ");
        }
        if (VALUE.equals(valueFormat) || NAME_AND_VALUE.equals(valueFormat) || PERCENTAGE.equals(valueFormat)) {
            xml.append("showValues='1' ");
        } else {
            xml.append("showValues='0' ");
        }
        if (PERCENTAGE.equals(valueFormat)) {
            xml.append("showPercentValues='1' ");
        }
    }

    private static void addTitleFontStyle(String name, XFormChart chart, StringBuffer xml) {
        FontStyleBuilder styleBuilder = new FontStyleBuilder(name);
        styleBuilder.setFont(chart.fonttype);
        styleBuilder.setSize(chart.fontsize);
        styleBuilder.setForegroundColor(chart.titleforeground);
        styleBuilder.setBackgroundColor(chart.titlebackground);
        styleBuilder.setFontType(chart.fontface);
        xml.append(styleBuilder.build());
    }

    private static void addShadow(XFormChart chart, StringBuffer xml) {
        String shadow = chart.shadowcolor;
        xml.append("showShadow='");
        if (shadow != null) {
            xml.append(1);
        } else {
            xml.append(0);
        }
        xml.append("' ");
    }

    private static void addPlotBackgroundColor(XFormChart pie, StringBuffer xml) {
        String plotBackgroundColor = pie.plotbgcolor;
        if (plotBackgroundColor != null) {
            xml.append("canvasBgColor='").append(plotBackgroundColor).append("' ");
        }
    }

    private static void addPlotOutlineColor(XFormChart pie, StringBuffer xml) {
        String plotOutlineColor = pie.plotoutlinecolor;
        if (plotOutlineColor != null) {
            xml.append("canvasBorderColor='").append(plotOutlineColor).append("' ");
        }
    }

    private static void addOutlineColor(XFormChart pie, StringBuffer xml) {
        String outlineColor = pie.outlinecolor;
        if (outlineColor != null) {
            xml.append("plotBorderColor='").append(outlineColor).append("' ");
        }
    }

    private static void addBackgroundColor(XFormGraphic graphic, StringBuffer xml) {
        String background = graphic.bgcolor;
        if (background != null) {
            xml.append("bgcolor='").append(background).append("' ");
        }
    }

    private static void addTitle(String title, StringBuffer xml) {
        if (title != null) {
            xml.append("caption='").append(title).append("' ");
        }
    }

    private static void addLegendColor(StringBuffer xml, String color) {
        xml.append("legendBgColor='").append(color).append("'");
    }

    private static class GraphicProperties {
        private Map<GraphicProperty, String> propertyMap = new HashMap<GraphicProperty, String>();

        public String put(GraphicProperty key, String value) {
            return this.propertyMap.put(key, value);
        }

        public String get(GraphicProperty key) {
            return this.propertyMap.get((Object)key);
        }
    }

    private static class FontStyleBuilder {
        private String backgroundColor;
        private String font;
        private String fontType;
        private String foregroundColor;
        private String name;
        private int size;

        FontStyleBuilder(String name) {
            this.name = name;
        }

        public void setFont(String font) {
            this.font = font;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setForegroundColor(String foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        public void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public void setFontType(String fontType) {
            this.fontType = fontType;
        }

        public String build() {
            StringBuffer style = new StringBuffer();
            style.append("<style name='").append(this.name).append("' type='font' ");
            if (this.font != null) {
                style.append("font='").append(this.font).append("' ");
            }
            style.append("size='").append(this.size).append("' ");
            if (this.foregroundColor != null) {
                style.append("color='").append(this.foregroundColor).append("' ");
            }
            if (this.backgroundColor != null) {
                style.append("bgcolor='").append(this.backgroundColor).append("' ");
            }
            if (this.fontType != null) {
                if (this.fontType.equalsIgnoreCase(FontStyle.BOLD.toString()) || this.fontType.equalsIgnoreCase(FontStyle.BOLD_ITALIC.toString()) || this.fontType.equalsIgnoreCase(FontStyle.ITALIC_BOLD.toString())) {
                    style.append("bold='1' ");
                }
                if (this.fontType.equalsIgnoreCase(FontStyle.ITALIC.toString()) || this.fontType.equalsIgnoreCase(FontStyle.BOLD_ITALIC.toString()) || this.fontType.equalsIgnoreCase(FontStyle.ITALIC_BOLD.toString())) {
                    style.append("italic='1'");
                }
            }
            style.append("/>");
            return style.toString();
        }
    }

    private static enum GraphicProperty {
        TITLE,
        CATEGORY_LABEL,
        VALUE_LABEL,
        TYPE;

    }
}

