/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentLoadingException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeLoader45;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.JarWrapper;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class ImportOTDWrapper {
    private String fileName = null;
    private JarWrapper.FileDefinition[] files = null;
    private String moduleName;
    private ObjectTypeDescription parent = null;
    private ComponentCatalog repository = null;
    private boolean zipFile = false;

    protected ImportOTDWrapper(String fileName, ComponentCatalog repository, String moduleName) {
        this.fileName = fileName;
        this.repository = repository;
        this.moduleName = moduleName;
        if (fileName.toLowerCase().endsWith(".xml") || fileName.toLowerCase().endsWith(".xcdl")) {
            this.zipFile = false;
        }
        if (fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".jar")) {
            this.zipFile = true;
        }
    }

    public static ImportOTDWrapper create(String fileName, ComponentCatalog repository, String parentName) {
        return new ImportOTDWrapper(fileName, repository, parentName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ObjectTypeDescription getParent() throws ConstructionException {
        if (this.parent == null) {
            this.initParent();
        }
        if (this.parent != null && this.parent.isBpmObject() && this.zipFile) {
            ArrayList<ObjectTypeDescription> inners = new ArrayList<ObjectTypeDescription>();
            try {
                for (JarWrapper.FileDefinition fd : this.files) {
                    ByteArrayInputStream data = new ByteArrayInputStream(fd.getFileData());
                    ObjectTypeDescription obj = TypeLoader45.createFrom((InputStream)data, (ComponentCatalog)this.repository, (String)this.moduleName);
                    boolean isXODelegate = false;
                    boolean isGroupDelegate = false;
                    for (SuperType superType : obj.getSuperTypes()) {
                        if (!isXODelegate) {
                            isXODelegate = "Fuego.Internal.XODelegate".equals(superType.getText());
                        }
                        if (isGroupDelegate) continue;
                        isGroupDelegate = "Fuego.Internal.InnerFODelegate".equals(superType.getText());
                    }
                    if (isXODelegate && !isGroupDelegate && this.parent.getName().equals(obj.getName())) continue;
                    if (!isGroupDelegate) {
                        throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0006);
                    }
                    inners.add(obj);
                }
            }
            catch (ComponentLoadingException e) {
                throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0010(this.fileName), e);
            }
            for (ObjectTypeDescription inner : inners) {
                MethodTypeDescription secondConst;
                MethodTypeDescription constructor;
                this.parent.addInnerType((TypeRef)inner);
                AttributeTypeDescription grMember = this.parent.findAttribute(Identifier.attribute((String)inner.getName()));
                if (grMember != null && grMember.getResultType().isArray()) {
                    ArrayTypeDescription groupType = TypeFactory.getArray((TypeRef)inner);
                    groupType.setJavaType("oracle.bpm.xobject.GroupArray");
                    grMember.setResultType((TypeRef)groupType);
                }
                if ((constructor = inner.getMember(inner.getName(), 14)) == null || !constructor.isConstructor() || (secondConst = constructor.getNextMethod()) == null || secondConst.getArgument("parent") < 0) continue;
                Argument[] args = secondConst.getArguments();
                int j = secondConst.getArgument("parent");
                args[j].setType((TypeRef)this.parent);
                secondConst.setArguments(args);
            }
        }
        return this.parent;
    }

    private void initParent() throws ConstructionException {
        try {
            if (!this.zipFile) {
                this.parent = TypeLoader45.createFrom((InputStream)new FileInputStream(this.fileName), (ComponentCatalog)this.repository, (String)this.moduleName);
            } else {
                JarWrapper jr = JarWrapper.openJar((String)this.fileName, (int)1);
                this.files = jr.getFiles();
                if (this.files != null) {
                    for (int f = 0; f < this.files.length && this.parent == null; ++f) {
                        JarWrapper.FileDefinition fd = this.files[f];
                        byte[] byteData = fd.getFileData();
                        ByteArrayInputStream data = new ByteArrayInputStream(byteData);
                        ObjectTypeDescription obj = TypeLoader45.createFrom((InputStream)data, (ComponentCatalog)this.repository, (String)this.moduleName);
                        boolean isGroupDelegate = false;
                        boolean isXODelegate = false;
                        if (obj.isBpmObject()) {
                            for (SuperType superType : obj.getSuperTypes()) {
                                if (!isXODelegate) {
                                    isXODelegate = "Fuego.Internal.XODelegate".equals(superType.getText());
                                }
                                if (isGroupDelegate) continue;
                                isGroupDelegate = "Fuego.Internal.InnerFODelegate".equals(superType.getText());
                            }
                        }
                        if (!obj.isEnum() && (!obj.isBpmObject() || !isXODelegate || isGroupDelegate)) continue;
                        this.parent = obj;
                        String fullName = jr.getFileNames()[f];
                        int index = fullName.lastIndexOf(47);
                        if (index <= 0) continue;
                        String pathName = fullName.substring(0, index);
                        this.moduleName = pathName.replace('/', '.');
                        data = new ByteArrayInputStream(byteData);
                        this.parent = TypeLoader45.createFrom((InputStream)data, (ComponentCatalog)this.repository, (String)this.moduleName);
                    }
                }
            }
        }
        catch (ComponentLoadingException e) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0010(this.fileName), e);
        }
        catch (IOException e) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_0000, e);
        }
    }
}

