/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.BreakIterator;
import java.util.Locale;
import oracle.bpm.lang.IncompatibleTypesException;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.xobject.UtilitiesLib;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class Utilities {
    private static final Class[] STR_CLASS_ARRAY = new Class[]{String.class};
    private static final Class[] OBJ_CLASS_ARRAY = new Class[]{Object.class};
    public static final int DEFAULT_YEAR = 1980;
    public static final int DEFAULT_MONTH = 1;
    public static final int DEFAULT_DAY = 10;
    public static final int DEFAULT_HOUR = 10;
    public static final int DEFAULT_MINUTE = 0;
    public static final int DEFAULT_SECOND = 0;
    public static final String CAL_EXP = "calculate$";
    public static final String VAL_EXP = "validate$";
    public static boolean SHOW_IMAGES = false;
    public static final String RIGHT_ALIGN = "right";
    public static final String LEFT_ALIGN = "left";
    public static final String CENTER_ALIGN = "center";
    public static final String LEADING_ALIGN = "leading";
    public static final String TRAILING_ALIGN = "trailing";
    public static final String TOP_ALIGN = "top";
    public static final String BOTTOM_ALIGN = "bottom";
    public static final String TILE_IMAGE = "tile";
    public static final String CENTER_IMAGE = "center";
    public static final String BOLD = "BOLD";
    public static final String ITALIC = "ITALIC";
    public static final String BOLD_ITALIC = "BOLD_ITALIC";
    public static final String NORMAL = "NORMAL";
    public static boolean DEBUG = false;
    public static final String XO_RUNTIME_INFO_RES = "runtimeInfoRes";
    public static final String XO_PRESENTATIONS_RES = "presentationsRes";
    public static final String XO_I18N_RES = "i18nRes";
    private static final String DATE_MASK = "yyyy/MM/dd HH:mm:ss.S";
    private static final String DATE_ONLY_MASK = "MMM d, yyyy";
    private static final String TIME_ONLY_MASK = "HH:mm:ss aa";

    public static String getAttrSignature(String attName, TypeDescription type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('A');
        buffer.append(attName);
        buffer.append(';');
        buffer.append(type.getJavaSignature());
        return buffer.toString();
    }

    public static String getDescriptionFor(Throwable t) {
        return t.getClass().getName() + ": ";
    }

    public static String getId(XFormXMLObject where) {
        try {
            Field f = where.getClass().getField("id");
            return (String)f.get(where);
        }
        catch (Exception e) {
            try {
                Field f = where.getClass().getField("id_d");
                return (String)f.get(where);
            }
            catch (Exception ex) {
                return "";
            }
        }
    }

    public static String getMask(int precision) {
        switch (precision) {
            case 0: {
                return DATE_ONLY_MASK;
            }
            case 1: {
                return TIME_ONLY_MASK;
            }
        }
        return DATE_MASK;
    }

    public static String getMethodSignature(String methodName, TypeDescription[] paramsType, TypeDescription returnType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('M');
        buffer.append(methodName);
        buffer.append("(");
        if (paramsType != null) {
            for (TypeDescription aParamsType : paramsType) {
                buffer.append(aParamsType.getJavaSignature());
            }
        }
        buffer.append(")");
        buffer.append(returnType.getJavaSignature());
        return buffer.toString();
    }

    public static String getString(String key) {
        System.out.println("Implemet new resources schema, key: " + key);
        return key;
    }

    public static String getString(String key, Locale locale) {
        System.out.println("Implemet new resources schema, key: " + key + "locale" + locale);
        return key;
    }

    public static String getString(ColorInfo currentColor) {
        if (currentColor != null) {
            String redComp = Integer.toHexString(currentColor.getRed());
            while (redComp.length() < 2) {
                redComp = "0" + redComp;
            }
            String gComp = Integer.toHexString(currentColor.getGreen());
            while (gComp.length() < 2) {
                gComp = "0" + gComp;
            }
            String bComp = Integer.toHexString(currentColor.getBlue());
            while (bComp.length() < 2) {
                bComp = "0" + bComp;
            }
            return "#" + redComp + gComp + bComp;
        }
        return null;
    }

    public static String getValidValuesMethodSignature(String attName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('M');
        buffer.append(attName);
        buffer.append("ValidValues()");
        buffer.append('L');
        buffer.append("java.util.List");
        buffer.append(';');
        return buffer.toString();
    }

    public static long computeXObjectSerialVersion(String module, String name) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            data.writeUTF(module);
            data.writeUTF(name);
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                h += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return h;
    }

    public static String[] getPosibleHAligns() {
        return new String[]{RIGHT_ALIGN, LEFT_ALIGN, "center", LEADING_ALIGN, TRAILING_ALIGN};
    }

    public static String[] getPosibleVAligns() {
        return new String[]{"center", TOP_ALIGN, BOTTOM_ALIGN};
    }

    public static boolean compare(String value, String validValues, String mask) {
        Time t = Utilities.valueOf(value);
        Time t1 = Utilities.valueOf(validValues);
        String s = t.format(mask);
        String s1 = t1.format(mask);
        return s.equals(s1);
    }

    public static Object convert(TypeDescription type, String value) {
        Object result;
        System.out.println("Utilities.convert : [type=" + type + "] [value=" + value + "]");
        if (value == null || value.equals("")) {
            return DefaultValue.forClass((Class)type.getJavaClass());
        }
        Class<Conversion> conversorClass = Conversion.class;
        String methodName = "to" + type.getJavaType().replace('.', '_');
        try {
            Method method = conversorClass.getMethod(methodName, STR_CLASS_ARRAY);
            result = method.invoke(null, value);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Method method = conversorClass.getMethod(methodName, OBJ_CLASS_ARRAY);
                result = method.invoke(null, value);
            }
            catch (NoSuchMethodException nsme1) {
                throw new IncompatibleTypesException(value + ", It isn't of the type: " + type.getName());
            }
            catch (IllegalAccessException noway) {
                throw new IncompatibleTypesException(value + ", It isn't of the type: " + type.getName());
            }
            catch (InvocationTargetException ite) {
                throw new IncompatibleTypesException(value + ", It isn't of the type: " + type.getName());
            }
        }
        catch (IllegalAccessException noway) {
            throw new IncompatibleTypesException(value + ", It isn't of the type: " + type.getName());
        }
        catch (InvocationTargetException ite) {
            throw new IncompatibleTypesException(value + ", It isn't of the type: " + type.getName());
        }
        return result;
    }

    public static String toString(Time time) {
        return time.format(DATE_MASK);
    }

    public static String toString(Object value) {
        if (value instanceof Time) {
            return UtilitiesLib.toString((Time)((Time)value));
        }
        return value.toString();
    }

    public static Time valueOf(String temp) throws TimeFormatException {
        return Time.valueOf((String)temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String wrapText(String text, int cols, Locale locale) {
        if (text == null || text.length() == 0 || cols <= 0) {
            return text;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            BreakIterator boundary = BreakIterator.getLineInstance(locale);
            boundary.setText(text);
            int start = boundary.first();
            int end = boundary.next();
            int lineLength = 0;
            while (end != -1) {
                String word = text.substring(start, end);
                if ((lineLength += word.length()) > cols) {
                    printWriter.println();
                    lineLength = word.length();
                } else if (word.endsWith("\n")) {
                    lineLength = 0;
                }
                printWriter.print(word);
                start = end;
                end = boundary.next();
            }
        }
        finally {
            printWriter.flush();
            printWriter.close();
        }
        return stringWriter.toString();
    }
}

