/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.project.interfaces.ConversationHelper;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ServiceReference;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.DefineInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceReferenceImpl
implements ServiceReference {
    private Conversation conversation;
    private Process process;

    public ServiceReferenceImpl(@NotNull Conversation conversation, @NotNull Process baseProcess) {
        if (conversation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ServiceReferenceImpl.<init> must not be null");
        }
        if (baseProcess == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/ServiceReferenceImpl.<init> must not be null");
        }
        this.conversation = conversation;
        this.process = baseProcess;
    }

    @Override
    @Nullable
    public QName getCallPortType() {
        QName portType = null;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                String portTypename = this.getBaseName();
                portType = new QName(this.process.getNamespace(), portTypename + "PortType");
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationDefinition uicf = this.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                ReferenceObject reference = uicf.getReference();
                if (reference == null) break;
                ServiceObject serviceObject = this.getServiceObjectFrom(reference);
                assert (serviceObject != null);
                portType = serviceObject.getServiceQName();
                break;
            }
            case PROCESS_CALL: {
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationDefinition sccf = this.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                oracle.bpm.project.model.catalog.ServiceObject service = sccf.getService();
                if (service == null) break;
                portType = this.getServiceObjectFrom(service).getServiceQName();
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return portType;
    }

    @Override
    @Nullable
    public QName getCallBackPortType() {
        QName callbackPortType = null;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                boolean hasCallback = false;
                ArrayList<Conversational> conversationals = new ArrayList<Conversational>();
                Sequence<FlowNode> allActivities = ModelUtils.getAllFlowNodes(this.process);
                for (FlowNode flowNode : allActivities) {
                    Conversational currentConversational;
                    boolean isEquals;
                    if (!flowNode.isConversational() || !(isEquals = this.compareConversation((currentConversational = flowNode.asAnyNode(Conversational.class)).getConversation(), this.getConversation()))) continue;
                    conversationals.add(currentConversational);
                }
                for (Conversational conv : conversationals) {
                    DefineInterfaceConversationalDefinition as = conv.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                    if (!conv.getConversationalType().isSender() || as.getReplyTo() != null) continue;
                    hasCallback = true;
                    break;
                }
                if (!hasCallback) break;
                String portTypename = this.getBaseName();
                portTypename = portTypename + "PortType";
                portTypename = portTypename + "CallBack";
                callbackPortType = new QName(this.process.getNamespace(), portTypename);
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationDefinition uicf = this.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                ReferenceObject reference = uicf.getReference();
                if (reference == null) break;
                ServiceObject serviceObject = this.getServiceObjectFrom(reference);
                assert (serviceObject != null);
                callbackPortType = serviceObject.getCallbackServiceQName();
                break;
            }
            case PROCESS_CALL: {
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationDefinition sccf = this.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                oracle.bpm.project.model.catalog.ServiceObject service = sccf.getService();
                if (service == null) break;
                callbackPortType = this.getServiceObjectFrom(service).getCallbackServiceQName();
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return callbackPortType;
    }

    @Override
    public String getServiceName() {
        return ConversationHelper.getServiceNameFrom(this.getConversation(), this.process);
    }

    @Override
    public String getReferenceName() {
        return ConversationHelper.getReferenceNameFrom(this.getConversation(), this.process);
    }

    @Override
    @Nullable
    public String getWsdlInterface() {
        String wsdlName = null;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                wsdlName = this.process.getId() + ".wsdl";
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationDefinition uicf = this.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                ReferenceObject reference = uicf.getReference();
                if (reference == null) break;
                ServiceObject serviceObject = this.getServiceObjectFrom(reference);
                assert (serviceObject != null);
                wsdlName = serviceObject.getServiceLocation();
                break;
            }
            case PROCESS_CALL: {
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationDefinition sccf = this.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                oracle.bpm.project.model.catalog.ServiceObject service = sccf.getService();
                if (service == null) break;
                wsdlName = this.getServiceObjectFrom(service).getServiceLocation();
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return wsdlName;
    }

    @Override
    public String getName() {
        return ConversationHelper.getServiceReferencedName(this.getConversation(), this.process);
    }

    Conversation getConversation() {
        return this.conversation;
    }

    ConversationDefinition getConversationDefinition() {
        return this.conversation.getConversationDefinition();
    }

    private boolean compareConversation(@Nullable Conversation convA, @Nullable Conversation convB) {
        boolean ret = false;
        if (convA == convB) {
            return true;
        }
        if (convA == null || convB == null) {
            return false;
        }
        if (convA.getConversationType() == convB.getConversationType()) {
            String convAName = convA.getName();
            String convBName = convB.getName();
            boolean equalName = convAName != null ? convAName.equals(convBName) : convBName == null;
            boolean equalsDefaultFlag = convA.isDefaultConversation() == convB.isDefaultConversation();
            boolean equalsContent = false;
            switch (convA.getConversationType()) {
                case DEFINE_INTERFACE: {
                    DefineInterfaceConversationDefinition dicdA = convA.getConversationDefinition().as(DefineInterfaceConversationDefinition.class);
                    DefineInterfaceConversationDefinition dicdB = convB.getConversationDefinition().as(DefineInterfaceConversationDefinition.class);
                    equalsContent = dicdA.getName() != null ? dicdA.getName().equals(dicdB.getName()) : dicdB.getName() == null;
                    break;
                }
                case USE_INTERFACE: {
                    UseInterfaceConversationDefinition uicdA = convA.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                    UseInterfaceConversationDefinition uicdB = convB.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                    ReferenceObject uicdAReference = uicdA.getReference();
                    ReferenceObject uicdBReference = uicdB.getReference();
                    if (uicdAReference == uicdBReference) {
                        equalsContent = true;
                        break;
                    }
                    if (uicdAReference != null) {
                        if (uicdBReference == null) break;
                        equalsContent = uicdAReference.getId().equals(uicdBReference.getId());
                        break;
                    }
                    equalsContent = uicdBReference == null;
                    break;
                }
                case PROCESS_CALL: {
                    ProcessCallConversationDefinition pccdA = convA.getConversationDefinition().as(ProcessCallConversationDefinition.class);
                    ProcessCallConversationDefinition pccdB = convB.getConversationDefinition().as(ProcessCallConversationDefinition.class);
                    Conversation pccdATargetConversation = null;
                    Conversation pccdBTargetConversation = null;
                    if (pccdATargetConversation == pccdBTargetConversation) {
                        equalsContent = true;
                        break;
                    }
                    if (pccdATargetConversation != null) {
                        if (pccdBTargetConversation == null) break;
                        equalsContent = this.compareConversation(pccdATargetConversation, pccdBTargetConversation);
                        break;
                    }
                    equalsContent = pccdBTargetConversation == null;
                    break;
                }
                case SERVICE_CALL: {
                    ServiceCallConversationDefinition sccdA = convA.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                    ServiceCallConversationDefinition sccdB = convB.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                    oracle.bpm.project.model.catalog.ServiceObject sccdAService = sccdA.getService();
                    oracle.bpm.project.model.catalog.ServiceObject sccdBService = sccdB.getService();
                    if (sccdAService == sccdBService) {
                        equalsContent = true;
                        break;
                    }
                    if (sccdAService != null) {
                        if (sccdBService == null) break;
                        equalsContent = sccdAService.getId().equals(sccdBService.getId());
                        break;
                    }
                    equalsContent = sccdBService == null;
                }
            }
            return equalName && equalsDefaultFlag && equalsContent;
        }
        return ret;
    }

    private ServiceObject getServiceObjectFrom(@NotNull CatalogObject catalogObject) {
        if (catalogObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ServiceReferenceImpl.getServiceObjectFrom must not be null");
        }
        ProjectObject parentObject = catalogObject.getParentObject();
        ObjectTypeDescription objectType = parentObject.is(ReferenceObject.class) ? ((ReferenceObject)parentObject).getObjectType() : catalogObject.getObjectType();
        return objectType.asServiceObject();
    }

    private String getBaseName() {
        boolean isDefault = this.getConversation().isDefaultConversation();
        return isDefault ? this.process.getId() : this.getConversation().getName();
    }
}

