/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.parser.wsdl.OperationType;
import oracle.bpm.project.interfaces.ConversationHelper;
import oracle.bpm.project.interfaces.ServiceReferenceImpl;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ServiceReference;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ProcessCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class OperationReferenceImpl
implements OperationReference {
    private Conversational conversational;
    private Process process;

    public OperationReferenceImpl(@NotNull Conversational conversational) {
        if (conversational == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.<init> must not be null");
        }
        this.conversational = conversational;
        this.process = conversational.getProcess();
    }

    public OperationReferenceImpl(@NotNull Conversational conversational, @NotNull Process baseProcess) {
        if (conversational == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.<init> must not be null");
        }
        if (baseProcess == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.<init> must not be null");
        }
        this.conversational = conversational;
        this.process = baseProcess;
    }

    public Conversational getConversational() {
        return this.conversational;
    }

    public ServiceReference getServiceReference() {
        return new ServiceReferenceImpl(this.conversational.getConversation(), this.process);
    }

    public Conversation getConversation() {
        return this.conversational.getConversation();
    }

    public ConversationalDefinition getConversationalDefinition() {
        return this.conversational.getConversationalDefinition();
    }

    public QName getInputType() {
        QName qname;
        Conversation conversation = this.getConversation();
        ConversationType conversationType = conversation.getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                String namespace = this.process.getNamespace();
                boolean receiver = this.conversational.getConversationalType().isReceiver();
                String messageSuffix = receiver ? "" : "Response";
                qname = new QName(namespace, this.getName() + messageSuffix);
                break;
            }
            case PROCESS_CALL: {
                ProcessCallConversationalDefinition pccf = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                qname = new OperationReferenceImpl(pccf.getTargetConversational()).getInputType();
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationalDefinition uicf = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                qname = this.getMessageQname(ArgumentType.INPUT, uicf.getOperation());
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationalDefinition sccf = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                qname = this.getMessageQname(ArgumentType.INPUT, sccf.getOperation());
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return qname;
    }

    public QName getOutputType() {
        QName qname;
        Conversation conversation = this.getConversation();
        ConversationType conversationType = conversation.getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                String namespace = this.process.getNamespace();
                boolean sender = this.conversational.getConversationalType().isSender();
                String messageSuffix = sender ? "" : "Response";
                qname = new QName(namespace, this.getName() + messageSuffix);
                break;
            }
            case PROCESS_CALL: {
                ProcessCallConversationalDefinition pccf = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                qname = new OperationReferenceImpl(pccf.getTargetConversational()).getOutputType();
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationalDefinition uicf = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                qname = this.getMessageQname(ArgumentType.OUTPUT, uicf.getOperation());
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationalDefinition sccf = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                qname = this.getMessageQname(ArgumentType.OUTPUT, sccf.getOperation());
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return qname;
    }

    public boolean hasReplyTo() {
        boolean hasReplyTo;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                DefineInterfaceConversationalDefinition dcf = this.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                hasReplyTo = dcf.getReplyTo() != null;
                break;
            }
            case USE_INTERFACE: {
                hasReplyTo = this.getServiceReference().getCallBackPortType() == null;
                break;
            }
            case PROCESS_CALL: {
                ProcessCallConversationalDefinition pccf = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                Conversational targetConversational = pccf.getTargetConversational();
                hasReplyTo = new OperationReferenceImpl(targetConversational).hasReplyTo();
                break;
            }
            case SERVICE_CALL: {
                hasReplyTo = this.getServiceReference().getCallBackPortType() == null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return hasReplyTo;
    }

    @Override
    public String getName() {
        String operationName;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                DefineInterfaceConversationalDefinition dcf = this.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                operationName = dcf.getDefinedOperationName();
                if (dcf.getReplyTo() == null) break;
                DefineInterfaceConversationalDefinition replyTo = dcf.getReplyTo().getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                operationName = replyTo.getDefinedOperationName();
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationalDefinition uicf = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                CatalogMember uicfOperation = uicf.getOperation();
                operationName = this.getOperationNativeName(uicfOperation);
                break;
            }
            case PROCESS_CALL: {
                ProcessCallConversationalDefinition pccf = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                Conversational targetConversational = pccf.getTargetConversational();
                operationName = new OperationReferenceImpl(targetConversational).getName();
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationalDefinition sccf = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                CatalogMember sccfOperation = sccf.getOperation();
                operationName = this.getOperationNativeName(sccfOperation);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return operationName;
    }

    @Override
    public String findArgumentPartName(String argumentName) {
        String result = argumentName;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                boolean alloWrappedArguments = this.allowsWrappedArguments();
                if (alloWrappedArguments) break;
                result = "parameters";
                break;
            }
            case USE_INTERFACE: {
                ErrorObject error;
                Argument argument;
                UseInterfaceConversationalDefinition uicf = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                CatalogMember operation = uicf.getOperation();
                MethodTypeDescription methodTypeDescription = this.getMethodTypeDescription(operation);
                Argument argument2 = argument = methodTypeDescription == null ? null : methodTypeDescription.findArgument(argumentName);
                if (argument != null) {
                    result = argument.getProperty("partName");
                }
                if (result != null || (error = uicf.getError()) == null) break;
                CatalogType catalogType = error.getErrorInfoAttributes().get(argumentName);
                XmlTypeDescription modelObject = TypeUtils.getModelObject((ObjectTypeDescription)catalogType.getDelegate().asObject());
                result = modelObject.getProperty("partName");
                break;
            }
            case PROCESS_CALL: {
                ProcessCallConversationalDefinition pccf = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                OperationReferenceImpl operationReference = new OperationReferenceImpl(pccf.getTargetConversational());
                result = operationReference.findArgumentPartName(argumentName);
                break;
            }
            case SERVICE_CALL: {
                Argument arg;
                ServiceCallConversationalDefinition sccf = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                MethodTypeDescription typeDescription = this.getMethodTypeDescription(sccf.getOperation());
                Argument argument = arg = typeDescription == null ? null : typeDescription.findArgument(argumentName);
                if (arg == null) break;
                result = arg.getProperty("partName");
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return result;
    }

    @Override
    public QName getPortType() {
        QName qName;
        ConversationType conversationType = this.getConversation().getConversationType();
        switch (conversationType) {
            case DEFINE_INTERFACE: {
                DefineInterfaceConversationalDefinition dcf = this.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                String portTypename = ConversationHelper.getPortTypeName(this.process, this.getConversation());
                if (dcf.getReplyTo() == null && dcf.getParentObject().getConversationalType().isSender()) {
                    portTypename = portTypename + "CallBack";
                }
                qName = new QName(this.process.getNamespace(), portTypename);
                break;
            }
            case USE_INTERFACE: {
                UseInterfaceConversationalDefinition uicf = this.getConversationalDefinition().as(UseInterfaceConversationalDefinition.class);
                qName = uicf.getReference().getObjectType().asServiceObject().getServiceQName();
                break;
            }
            case PROCESS_CALL: {
                ProcessCallConversationalDefinition pccf = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
                OperationReferenceImpl operationReference = new OperationReferenceImpl(pccf.getTargetConversational());
                qName = operationReference.getPortType();
                break;
            }
            case SERVICE_CALL: {
                ServiceCallConversationalDefinition sccf = this.getConversationalDefinition().as(ServiceCallConversationalDefinition.class);
                qName = sccf.getService().getObjectType().asServiceObject().getServiceQName();
                break;
            }
            default: {
                throw new UnsupportedOperationException("The conversation type '" + (Object)((Object)conversationType) + "' is not defined.");
            }
        }
        return qName;
    }

    @Override
    public boolean allowsWrappedArguments() {
        boolean allowsWrappedArguments = false;
        DefineInterfaceConversationalDefinition dcf = this.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
        if (dcf != null) {
            allowsWrappedArguments = true;
            Sequence<DataDeclaration> dataDeclarationSequence = dcf.getArgumentsContainer().getDeclarations();
            int size = CollectionUtils.size(dataDeclarationSequence);
            if (size == 1) {
                DataDeclaration dataDeclaration = (DataDeclaration)dataDeclarationSequence.iterator().next();
                CatalogType type = dataDeclaration.getType();
                TypeDescription typeDescription = type.getDelegate();
                SchemaObject schemaObject = typeDescription.asSchemaObject();
                allowsWrappedArguments = !schemaObject.isFromWsdl();
            }
        } else {
            ProcessCallConversationalDefinition pccd = this.getConversationalDefinition().as(ProcessCallConversationalDefinition.class);
            if (pccd != null && pccd.getProcess() != null) {
                Conversational targetConversational = pccd.getTargetConversational();
                OperationReferenceImpl operationReference = new OperationReferenceImpl(targetConversational);
                allowsWrappedArguments = operationReference.allowsWrappedArguments();
            }
        }
        return allowsWrappedArguments;
    }

    public void setProcess(@NotNull Process model) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.setProcess must not be null");
        }
        this.process = model;
    }

    private String getOperationNativeName(CatalogMember operation) {
        MethodTypeDescription methodTypeDescription = operation.getDelegate().get().asMethod();
        DelegatedMethodTypeDescription delegatedMethodTypeDescription = methodTypeDescription.asDelegated();
        TypeDescription typeDescription = delegatedMethodTypeDescription.getDelegatedServiceRef().get();
        MethodTypeDescription memberBySignature = typeDescription.asObject().getMemberBySignature(delegatedMethodTypeDescription.getDelegatedMethodSignature());
        return memberBySignature.getNativeName();
    }

    private MethodTypeDescription getMethodTypeDescription(@NotNull CatalogMember operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.getMethodTypeDescription must not be null");
        }
        MethodTypeDescription memberType = operation.getMemberType();
        MethodTypeDescription methodTypeDescription = null;
        if (memberType.isDelegated()) {
            DelegatedMethodTypeDescription delegatedMethod = memberType.asDelegated();
            String signature = delegatedMethod.getDelegatedMethodSignature();
            TypeRef service = delegatedMethod.getDelegatedServiceRef();
            TypeDescription typeDescription = service.get();
            WsdlTypeDescription wsdlTypeDescription = (WsdlTypeDescription)typeDescription.asObject();
            methodTypeDescription = wsdlTypeDescription.findMethod(signature);
        }
        return methodTypeDescription;
    }

    private QName getMessageQname(@NotNull ArgumentType argumentType, @NotNull CatalogMember catalogMember) {
        if (argumentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.getMessageQname must not be null");
        }
        if (catalogMember == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/interfaces/OperationReferenceImpl.getMessageQname must not be null");
        }
        QName result = null;
        MethodTypeDescription methodTypeDescription = this.getMethodTypeDescription(catalogMember);
        if (methodTypeDescription != null) {
            String strmep = methodTypeDescription.getProperty("mep");
            OperationType mep = OperationType.valueOf(strmep);
            if (mep != OperationType.ONE_WAY || argumentType != ArgumentType.OUTPUT) {
                String namespace = methodTypeDescription.getProperty(argumentType.getMessageNamespace());
                String localPart = methodTypeDescription.getProperty(argumentType.getMessageName());
                result = new QName(namespace, localPart);
            }
        } else {
            throw new IllegalArgumentException("Conversation is not properly defined. There are not operation/process or external services defined");
        }
        return result;
    }

    private static enum ArgumentType {
        INPUT{

            @Override
            public String getMessageNamespace() {
                return "inputMessageNamespace";
            }

            @Override
            public String getMessageName() {
                return "inputMessage";
            }
        }
        ,
        OUTPUT{

            @Override
            public String getMessageNamespace() {
                return "outputMessageNamespace";
            }

            @Override
            public String getMessageName() {
                return "outputMessage";
            }
        };


        public abstract String getMessageNamespace();

        public abstract String getMessageName();
    }
}

