/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.utils;

import oracle.bpm.lang.DefaultException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidServiceException
extends DefaultException {
    private static final long serialVersionUID = 486029036222816664L;

    private InvalidServiceException(Msg msg) {
        super(msg);
    }

    private InvalidServiceException(Msg msg, Throwable throwable) {
        super(msg, throwable);
    }

    static InvalidServiceException cannotValidateZipFile(@NotNull String fileName, @Nullable Throwable throwable) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotValidateZipFile must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.CANNOT_VALIDATE_ZIP_FILE(fileName), throwable);
    }

    static InvalidServiceException cannotValidateWsdlFile(@NotNull String fileName, @Nullable Throwable throwable) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotValidateWsdlFile must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.CANNOT_VALIDATE_WSDL_FILE(fileName), throwable);
    }

    static InvalidServiceException cannotResolveDependency(@NotNull String dependency, @NotNull String fileName, @Nullable Throwable throwable) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotResolveDependency must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotResolveDependency must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.CANNOT_RESOLVE_DEPENDENCY(dependency, fileName), throwable);
    }

    static InvalidServiceException moreThanOneServiceInZipFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.moreThanOneServiceInZipFile must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.MORE_THAN_ONE_SERVICE_IN_ZIP_FILE(fileName));
    }

    static InvalidServiceException noServiceInZipFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.noServiceInZipFile must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.NO_SERVICE_IN_ZIP_FILE(fileName));
    }

    static InvalidServiceException invalidWsdlFile(@NotNull String fileName, @NotNull Throwable e) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.invalidWsdlFile must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.invalidWsdlFile must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.INVALID_WSDL_FILE(fileName), e);
    }

    static InvalidServiceException cannotLoadFileInZip(@NotNull String fileName, @NotNull String zipName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotLoadFileInZip must not be null");
        }
        if (zipName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotLoadFileInZip must not be null");
        }
        return new InvalidServiceException((Msg)ProjectCatalogMsg.CANNOT_LOAD_FILE_IN_ZIP(fileName, zipName));
    }

    static InvalidServiceException invalidXsdFile(@NotNull String fileName, @NotNull Throwable e) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.invalidXsdFile must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.invalidXsdFile must not be null");
        }
        return new InvalidServiceException(ProjectCatalogMsg.INVALID_XSD_FILE(fileName), e);
    }

    static InvalidServiceException invalidLocationReference(@NotNull String fileName, @NotNull Throwable e) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.invalidLocationReference must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.invalidLocationReference must not be null");
        }
        return new InvalidServiceException(ProjectCatalogMsg.INVALID_LOCATION(fileName), e);
    }

    static InvalidServiceException cannotCreateZip(@NotNull String fileName, @NotNull Throwable e) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotCreateZip must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/utils/InvalidServiceException.cannotCreateZip must not be null");
        }
        return new InvalidServiceException(ProjectCatalogMsg.CANNOT_CREATE_ZIP_FILE(fileName), e);
    }
}

