/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import oracle.bpm.collections.Tuple;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlSchemaToTypeRef {
    private static final String separator = ":";

    private XmlSchemaToTypeRef() {
    }

    public static List<Tuple<String, TypeRef>> getDefinedElementRefs(@NotNull Document dom, @NotNull ComponentCatalog catalog) {
        if (dom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getDefinedElementRefs must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getDefinedElementRefs must not be null");
        }
        ArrayList<Tuple<String, TypeRef>> result = new ArrayList<Tuple<String, TypeRef>>();
        try {
            XPath xPath = XmlSchemaToTypeRef.getXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/xs:schema/xs:element", dom, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element child = (Element)nodeList.item(i);
                String name = child.getAttribute("name");
                String type = child.getAttribute("type");
                TypeRef ref = XmlSchemaToTypeRef.resolveElement(child, type, name, catalog);
                result.add((Tuple<String, TypeRef>)Tuple.create((Object)name, (Object)ref));
            }
        }
        catch (XPathExpressionException ignored) {
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            // empty catch block
        }
        return result;
    }

    public static List<TypeRef> getDefinedTypeRefs(@NotNull Document dom, @NotNull ComponentCatalog catalog) {
        if (dom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getDefinedTypeRefs must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getDefinedTypeRefs must not be null");
        }
        ArrayList<TypeRef> result = new ArrayList<TypeRef>();
        try {
            XPath xPath = XmlSchemaToTypeRef.getXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/xs:schema/xs:complexType", dom, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element node = (Element)nodeList.item(i);
                String typeName = node.getAttribute("name");
                TypeRef typeRef = XmlSchemaToTypeRef.resolveType(node, typeName, typeName, catalog);
                result.add(typeRef);
            }
        }
        catch (XPathExpressionException ignored) {
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            // empty catch block
        }
        return result;
    }

    public static XPath getXPath() throws XPathFactoryConfigurationException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "http://www.w3.org/2001/XMLSchema";
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return "";
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
        return xPath;
    }

    public static List<Element> getFirstLevelElements(@NotNull Document dom) {
        if (dom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getFirstLevelElements must not be null");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            XPath xPath = XmlSchemaToTypeRef.getXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/xs:schema/xs:complexType", dom, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add((Element)nodeList.item(i));
            }
        }
        catch (XPathFactoryConfigurationException ignored) {
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return result;
    }

    public static List<Tuple<String, TypeRef>> getSecondLevelElementRefs(@NotNull Element element, @NotNull ComponentCatalog catalog) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getSecondLevelElementRefs must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getSecondLevelElementRefs must not be null");
        }
        List<Tuple<String, TypeRef>> result = new ArrayList<Tuple<String, TypeRef>>();
        try {
            NodeList nodeList = (NodeList)XmlSchemaToTypeRef.getXPath().evaluate("./xs:sequence/xs:element", element, XPathConstants.NODESET);
            result = XmlSchemaToTypeRef.getRefs(nodeList, catalog);
        }
        catch (XPathExpressionException ignored) {
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            // empty catch block
        }
        return result;
    }

    @Nullable
    private static String getPrefix(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getPrefix must not be null");
        }
        int endIndex = name.lastIndexOf(separator);
        if (endIndex != -1) {
            return name.substring(0, endIndex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static TypeRef resolveType(@NotNull Element element, @NotNull String typeName, @NotNull String name, @NotNull ComponentCatalog catalog) {
        TypeRef ref;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveType must not be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveType must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveType must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveType must not be null");
        }
        if (XmlSchemaToTypeRef.isPrimitiveType(typeName)) {
            ref = XmlSchemaToTypeRef.getPrimitiveType(typeName);
        } else {
            String namespace = XmlSchemaToTypeRef.getNamespace(element, typeName);
            String id = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)namespace, (String)XmlSchemaToTypeRef.removePrefix(typeName)).getId();
            ref = new BpmObjectDynamicRef(id, namespace, catalog);
        }
        assert (ref != null);
        TypeRef typeRef = ref;
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveType must not return null");
        }
        return typeRef;
    }

    private static TypeRef resolveElement(@NotNull Element element, String typeName, @NotNull String name, @NotNull ComponentCatalog catalog) {
        TypeRef ref;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveElement must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveElement must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.resolveElement must not be null");
        }
        if (XmlSchemaToTypeRef.isPrimitiveType(typeName)) {
            ref = XmlSchemaToTypeRef.getPrimitiveType(typeName);
        } else {
            String namespace = XmlSchemaToTypeRef.getNamespace(element, typeName);
            String id = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)namespace, (String)name).getId();
            ref = new BpmObjectDynamicRef(id, namespace, catalog);
        }
        return ref;
    }

    private static String getNamespace(@NotNull Element element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getNamespace must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getNamespace must not be null");
        }
        return element.lookupNamespaceURI(XmlSchemaToTypeRef.getPrefix(name));
    }

    private static boolean isPrimitiveType(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.isPrimitiveType must not be null");
        }
        String name = XmlSchemaToTypeRef.removePrefix(type);
        return SFSNamespace.S2001_NAMESPACE.getAllDefinedTypesByName().get(name) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String removePrefix(@NotNull String typeName) {
        String string;
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.removePrefix must not be null");
        }
        String[] split = typeName.split(separator);
        if (split.length == 2) {
            string = split[1];
            if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.removePrefix must not return null");
            return string;
        }
        string = typeName;
        if (string != null) return string;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.removePrefix must not return null");
    }

    @Nullable
    private static TypeRef getPrimitiveType(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getPrimitiveType must not be null");
        }
        String name = XmlSchemaToTypeRef.removePrefix(type);
        TypeDescription typeDescription = SFSNamespace.S2001_NAMESPACE.getAllDefinedTypesByName().get(name);
        if (typeDescription != null) {
            return typeDescription.getRef();
        }
        return null;
    }

    private static List<Tuple<String, TypeRef>> getRefs(@NotNull NodeList nodeList, @NotNull ComponentCatalog catalog) {
        if (nodeList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getRefs must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/XmlSchemaToTypeRef.getRefs must not be null");
        }
        ArrayList<Tuple<String, TypeRef>> result = new ArrayList<Tuple<String, TypeRef>>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TypeRef ref;
            Element child = (Element)nodeList.item(i);
            String xmlTypeName = child.getAttribute("type");
            String argName = child.getAttribute("name");
            if (!Str.isEmpty((String)xmlTypeName)) {
                ref = XmlSchemaToTypeRef.resolveType(child, xmlTypeName, argName, catalog);
            } else {
                xmlTypeName = child.getAttribute("ref");
                if (argName.isEmpty()) {
                    argName = XmlSchemaToTypeRef.removePrefix(xmlTypeName);
                }
                if (Str.isEmpty((String)xmlTypeName)) continue;
                ref = XmlSchemaToTypeRef.resolveElement(child, xmlTypeName, argName, catalog);
            }
            Tuple tuple = Tuple.create((Object)argName, (Object)ref);
            result.add((Tuple<String, TypeRef>)tuple);
        }
        return result;
    }
}

