/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.utils;

import javax.xml.namespace.QName;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.composite.ScaBindingInfo;
import oracle.bpm.project.catalog.composite.ScaBindingInfoWSIF;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class NotificationServiceHelper {
    public static final String EXT_REF_NAME = "BPM-NotificationService";
    public static final String NOTIFICATION_SERVICE = "NotificationService";
    public static final String SEND_IM_NOTIFICATION = "sendIMNotification";
    public static final String SEND_VOICE_NOTIFICATION = "sendVoiceNotification";
    public static final String SEND_SMS_NOTIFICATION = "sendSMSNotification";
    public static final String SEND_NOTIFICATION_TO_USER = "sendNotificationToUser";
    public static final String SEND_EMAIL_NOTIFICATION = "sendEmailNotification";
    public static final String TO = "to";
    public static final String BODY = "body";
    public static final String FROM = "from";
    public static final String SUBJECT = "subject";
    public static final String MESSAGE = "message";
    private static final String USER_PROPERTY_TYPE = "UserPropertiesParameterType";
    public static final String HEADER = "header";
    public static final String VALUE = "value";
    public static final String PROPERTIES = "properties";
    public static final String FROM_ACCOUNT = "fromAccount";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String REPLY_TO_ADDRESS = "replyToAddress";
    public static final String ATTACHMENTS = "attachments";
    private static final String ATTACHMENT_TYPE = "AttachmentType";
    public static final String HEADERS = "headers";
    private static final String HEADERS_TYPE = "HeadersType";
    public static final String NAME = "name";
    public static final String MIME_TYPE = "mimeType";
    public static final String ENCODING = "encoding";
    public static String NOTIFICATION_SERVICE_NAMESPACE = "http://xmlns.oracle.com/ias/pcbpel/NotificationService";
    private static final String NOTIFICATION_WSDL = "oramds:/soa/shared/workflow/NotificationService.wsdl";
    private static final String NOTIFICATION_XSD = "oramds:/soa/shared/workflow/NotificationService.xsd";
    public static final QName NOTIFICATION_PORT_TYPE = new QName(NOTIFICATION_SERVICE_NAMESPACE, "NotificationService");
    public static final ScaWsdlInfo NOTIFICATION_SCA_WSDL_INFO = new ScaWsdlInfo("oramds:/soa/shared/workflow/NotificationService.wsdl", NOTIFICATION_PORT_TYPE, null);
    public static final ScaBindingInfo NOTIFICATION_BINDING_INFO = new ScaBindingInfoWSIF("JavaPort", NOTIFICATION_PORT_TYPE);

    public static String buildOldNotificationExternalRefName(@NotNull String processId, @NotNull Activity activity) {
        if (processId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildOldNotificationExternalRefName must not be null");
        }
        if (activity == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildOldNotificationExternalRefName must not be null");
        }
        return processId + "." + NotificationServiceHelper.buildNotificationReferenceName(activity);
    }

    public static String buildNotificationReferenceName(@NotNull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildNotificationReferenceName must not be null");
        }
        return "NotificationService." + activity.getId();
    }

    public static String getOperationNativeName(@NotNull NotificationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.getOperationNativeName must not be null");
        }
        String result = null;
        if (type == NotificationType.MAIL) {
            result = SEND_EMAIL_NOTIFICATION;
        } else if (type == NotificationType.USER) {
            result = SEND_NOTIFICATION_TO_USER;
        } else if (type == NotificationType.SMS) {
            result = SEND_SMS_NOTIFICATION;
        } else if (type == NotificationType.VOICE) {
            result = SEND_VOICE_NOTIFICATION;
        } else if (type == NotificationType.IM) {
            result = SEND_IM_NOTIFICATION;
        }
        return result;
    }

    public static TypeDescription createNotificationService(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.createNotificationService must not be null");
        }
        ObjectTypeDescription result = new ObjectTypeDescription(NOTIFICATION_SERVICE);
        result.addMember(NotificationServiceHelper.buildSendEmail(catalog));
        result.addMember(NotificationServiceHelper.buildSendNotificationToUser(catalog));
        result.addMember(NotificationServiceHelper.buildSendSMS());
        result.addMember(NotificationServiceHelper.buildSendVoice());
        result.addMember(NotificationServiceHelper.buildSendIM());
        return result;
    }

    private static MethodTypeDescription buildSendIM() {
        MethodTypeDescription imOperation = new MethodTypeDescription(SEND_IM_NOTIFICATION);
        imOperation.addArgument(new Argument(TO, (TypeRef)TypeFactory.getString(), 1L));
        imOperation.addArgument(new Argument(BODY, (TypeRef)TypeFactory.getString(), 1L));
        return imOperation;
    }

    private static MethodTypeDescription buildSendVoice() {
        MethodTypeDescription voiceOperation = new MethodTypeDescription(SEND_VOICE_NOTIFICATION);
        voiceOperation.addArgument(new Argument(TO, (TypeRef)TypeFactory.getString(), 1L));
        voiceOperation.addArgument(new Argument(MIME_TYPE, (TypeRef)TypeFactory.getString(), 1L));
        voiceOperation.addArgument(new Argument(BODY, (TypeRef)TypeFactory.getString(), 1L));
        return voiceOperation;
    }

    private static MethodTypeDescription buildSendSMS() {
        MethodTypeDescription smsOperation = new MethodTypeDescription(SEND_SMS_NOTIFICATION);
        smsOperation.addArgument(new Argument(FROM, (TypeRef)TypeFactory.getString(), 1L));
        smsOperation.addArgument(new Argument(TO, (TypeRef)TypeFactory.getString(), 1L));
        smsOperation.addArgument(new Argument(SUBJECT, (TypeRef)TypeFactory.getString(), 1L));
        smsOperation.addArgument(new Argument(BODY, (TypeRef)TypeFactory.getString(), 1L));
        return smsOperation;
    }

    private static MethodTypeDescription buildSendNotificationToUser(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildSendNotificationToUser must not be null");
        }
        MethodTypeDescription userOperation = new MethodTypeDescription(SEND_NOTIFICATION_TO_USER);
        userOperation.addArgument(new Argument(TO, (TypeRef)TypeFactory.getString(), 1L));
        userOperation.addArgument(new Argument(SUBJECT, (TypeRef)TypeFactory.getString(), 1L));
        userOperation.addArgument(new Argument(MESSAGE, (TypeRef)TypeFactory.getString(), 1L));
        XmlTypeDescription userPropertyType = XmlTypeDescription.createForExternalXml((String)USER_PROPERTY_TYPE, (String)NOTIFICATION_SERVICE_NAMESPACE, (String)NOTIFICATION_XSD, (XmlElementType)XmlElementType.TYPE);
        AttributeTypeDescription propertyHeader = new AttributeTypeDescription(HEADER, (TypeRef)TypeFactory.getString());
        propertyHeader.setNativeName(HEADER);
        userPropertyType.addMember((MethodTypeDescription)propertyHeader);
        AttributeTypeDescription propertyValue = new AttributeTypeDescription(VALUE, (TypeRef)TypeFactory.getAny());
        propertyValue.setNativeName(VALUE);
        userPropertyType.addMember((MethodTypeDescription)propertyValue);
        userPropertyType.setCatalog(catalog);
        userOperation.addArgument(new Argument(PROPERTIES, (TypeRef)TypeFactory.createArray((TypeRef)userPropertyType), 1L));
        return userOperation;
    }

    private static MethodTypeDescription buildSendEmail(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildSendEmail must not be null");
        }
        MethodTypeDescription mailOperation = new MethodTypeDescription(SEND_EMAIL_NOTIFICATION);
        mailOperation.addArgument(new Argument(FROM_ACCOUNT, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(TO, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(CC, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(BCC, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(REPLY_TO_ADDRESS, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(SUBJECT, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(BODY, (TypeRef)TypeFactory.getString(), 1L));
        mailOperation.addArgument(new Argument(ATTACHMENTS, (TypeRef)TypeFactory.createArray((TypeRef)NotificationServiceHelper.buildAttachmentType(catalog)), 1L));
        mailOperation.addArgument(new Argument(HEADERS, (TypeRef)TypeFactory.createArray((TypeRef)NotificationServiceHelper.buildHeadersType(catalog)), 1L));
        return mailOperation;
    }

    private static ObjectTypeDescription buildAttachmentType(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildAttachmentType must not be null");
        }
        XmlTypeDescription attachmentType = XmlTypeDescription.createForExternalXml((String)ATTACHMENT_TYPE, (String)NOTIFICATION_SERVICE_NAMESPACE, (String)NOTIFICATION_XSD, (XmlElementType)XmlElementType.TYPE);
        AttributeTypeDescription name = new AttributeTypeDescription(NAME, (TypeRef)TypeFactory.getString());
        name.setNativeName(NAME);
        attachmentType.addMember((MethodTypeDescription)name);
        AttributeTypeDescription mimeType = new AttributeTypeDescription(MIME_TYPE, (TypeRef)TypeFactory.getString());
        mimeType.setNativeName(MIME_TYPE);
        attachmentType.addMember((MethodTypeDescription)mimeType);
        AttributeTypeDescription encoding = new AttributeTypeDescription(ENCODING, (TypeRef)TypeFactory.getString());
        encoding.setNativeName(ENCODING);
        attachmentType.addMember((MethodTypeDescription)encoding);
        AttributeTypeDescription value = new AttributeTypeDescription(VALUE, (TypeRef)TypeFactory.getAny());
        value.setNativeName(VALUE);
        attachmentType.addMember((MethodTypeDescription)value);
        attachmentType.setCatalog(catalog);
        return attachmentType;
    }

    private static ObjectTypeDescription buildHeadersType(@NotNull ComponentCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/NotificationServiceHelper.buildHeadersType must not be null");
        }
        XmlTypeDescription headersType = XmlTypeDescription.createForExternalXml((String)HEADERS_TYPE, (String)NOTIFICATION_SERVICE_NAMESPACE, (String)NOTIFICATION_XSD, (XmlElementType)XmlElementType.TYPE);
        AttributeTypeDescription name = new AttributeTypeDescription(NAME, (TypeRef)TypeFactory.getString());
        name.setNativeName(NAME);
        headersType.addMember((MethodTypeDescription)name);
        AttributeTypeDescription value = new AttributeTypeDescription(VALUE, (TypeRef)TypeFactory.getString());
        value.setNativeName(VALUE);
        headersType.addMember((MethodTypeDescription)value);
        headersType.setCatalog(catalog);
        return headersType;
    }
}

