/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.utils;

import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.CatalogMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogMemberUtils {
    private CatalogMemberUtils() {
    }

    @Nullable
    public static String getOperationNativeName(@NotNull CatalogMember member) {
        MethodTypeDescription originalMtd;
        DelegatedMethodTypeDescription dmtd;
        TypeDescription service;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/CatalogMemberUtils.getOperationNativeName must not be null");
        }
        MethodTypeDescription mtd = member.getMemberType();
        String result = mtd.getNativeName();
        if (mtd.isDelegated() && (service = (dmtd = mtd.asDelegated()).getDelegatedServiceRef().get()) != null && !service.isUnknown() && (originalMtd = service.asObject().getMemberBySignature(dmtd.getDelegatedMethodSignature())) != null) {
            result = originalMtd.getNativeName();
        }
        return result;
    }
}

