/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.parser;

import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Text;
import oracle.bpm.type.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmoScript
extends WsdlElement {
    public BpmoScript() {
        this.setTagName("script");
        this.setNamespace("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    public void setLanguage(@NotNull String language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoScript.setLanguage must not be null");
        }
        if (!Str.isEmpty((String)language)) {
            this.setAttribute("language", language);
        }
    }

    @Nullable
    public String getLanguage() {
        return this.getAttribute("language");
    }

    @Nullable
    public SourceCode getSourceCode() {
        DefaultElement firstElement = this.getFirstElement();
        if (firstElement != null) {
            Text cdata = (Text)firstElement;
            String content = cdata.getContent();
            if (content == null) {
                return null;
            }
            String code = content.replaceAll("\\s+$", "");
            code = XmlUtils.unEscapeCData((String)code);
            String lang = this.getLanguage();
            if (lang == null) {
                throw new IllegalStateException("Script element has sourcecode but it's missing language");
            }
            return SourceCode.create((String)code, (String)lang);
        }
        return null;
    }
}

