/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import oracle.bpm.extensionpoint.metadata.ComponentRendererMetadata;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentRenderer;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

@ComponentRendererMetadata(type="xml")
public class XmlComponentRenderer
extends ComponentRenderer.Default {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Msg getIcon(@NotNull TypeRef typeRef) {
        Msg result;
        Msg msg;
        if (typeRef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/XmlComponentRenderer.getIcon must not be null");
        }
        TypeDescription td = typeRef.get();
        if (!td.isSchemaObject()) {
            msg = ProjectCatalogMsg.XML_ELEMENT;
            if (msg == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/XmlComponentRenderer.getIcon must not return null");
            return msg;
        }
        SchemaObject schemaObject = td.asSchemaObject();
        XmlElementType type = schemaObject.getXmlElementType();
        switch (type) {
            case ELEMENT: {
                result = ProjectCatalogMsg.XML_ELEMENT;
                break;
            }
            case TYPE: {
                if (td.isEnum()) {
                    result = ProjectCatalogMsg.XML_ENUM;
                    break;
                }
                result = ProjectCatalogMsg.XML_COMPLEX_TYPE;
                break;
            }
            default: {
                result = ProjectCatalogMsg.XML_ELEMENT;
            }
        }
        if ((msg = result) != null) return msg;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/XmlComponentRenderer.getIcon must not return null");
    }

    public Msg getMsg() {
        return ProjectCatalogMsg.XML;
    }
}

