/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.lang.DescriptionEnabled;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.Documentation;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.catalog.type.BpmoWriterContext;
import oracle.bpm.project.catalog.type.ElementBuilder;
import oracle.bpm.project.catalog.type.parser.AbstractBpmoDoc;
import oracle.bpm.project.catalog.type.parser.BpmoArgumentDoc;
import oracle.bpm.project.catalog.type.parser.BpmoDescription;
import oracle.bpm.project.catalog.type.parser.BpmoDocumentable;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.util.documentation.DocumentationType;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBpmoTypeWriter {
    ElementBuilder elementBuilder;
    VFile outputFile;
    final NamespaceContext rootContext;
    String targetNamespace;
    XObjectTypeDescription xotd;
    private BpmoWriterContext context;

    protected AbstractBpmoTypeWriter(@NotNull XObjectTypeDescription xotd, @NotNull VFile outputFile, @NotNull BpmoWriterContext context) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/AbstractBpmoTypeWriter.<init> must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/AbstractBpmoTypeWriter.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/AbstractBpmoTypeWriter.<init> must not be null");
        }
        this.rootContext = new NamespaceContext(null);
        this.xotd = xotd;
        this.outputFile = outputFile;
        this.rootContext.addNamespace("bpmo", "http://xmlns.oracle.com/bpm/bpmobject/");
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws TypeCatalogException {
        BufferedWriter bw;
        DefaultElement rootElement = this.build();
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new VFileOutputStream(this.outputFile), "UTF-8"));
        }
        catch (IOException e) {
            throw new TypeCatalogException(null, this.xotd.getText(), (Exception)e);
        }
        IndentedPrintWriter writer = new IndentedPrintWriter((Writer)bw);
        try {
            String instructionLine = this.getBpmoProcessingInstructionLine();
            rootElement.dump(writer, new String[]{instructionLine}, "UTF-8");
            writer.flush();
        }
        finally {
            writer.close();
        }
        if (writer.checkError()) {
            throw new TypeCatalogException(null, "I/O error on " + this.outputFile);
        }
    }

    public BpmoWriterContext getContext() {
        return this.context;
    }

    abstract DefaultElement build() throws TypeCatalogException;

    abstract String getXmlSchemaPrefix();

    static DefaultElement buildDocumentation(TypeDescription td, NamespaceContext parentContext) {
        AbstractBpmoDoc doc;
        Documentation documentation;
        DefaultElement documentable;
        String text;
        Locale locale;
        DefaultElement annotation = SchemaElementFactory.createAnnotation(parentContext);
        NamespaceContext annotationContext = annotation.getNSContext();
        AbstractBpmoTypeWriter.buildDescriptions(td, annotation);
        HashMap<Locale, DefaultElement> documentableMap = new HashMap<Locale, DefaultElement>();
        for (Map.Entry entry : td.getDocumentation(DocumentationType.DOCUMENTATION)) {
            locale = (Locale)entry.getKey();
            text = (String)entry.getValue();
            if (Str.isEmpty((String)text)) continue;
            documentable = (DefaultElement)documentableMap.get(locale);
            if (documentable == null) {
                documentation = SchemaElementFactory.createDocumentation(locale, annotationContext);
                annotation.addChild(documentation);
                documentable = SchemaElementFactory.createBpmoDocumentable(documentation.getNSContext());
                ((DefaultElement)documentation).addChild(documentable);
                documentableMap.put(locale, documentable);
            }
            doc = SchemaElementFactory.createBpmoDocumentation(text, documentable.getNSContext());
            documentable.addChild(doc);
        }
        for (Map.Entry entry : td.getDocumentation(DocumentationType.USE_CASE_DOCUMENTATION)) {
            locale = (Locale)entry.getKey();
            text = (String)entry.getValue();
            if (Str.isEmpty((String)text)) continue;
            documentable = (DefaultElement)documentableMap.get(locale);
            if (documentable == null) {
                documentation = SchemaElementFactory.createDocumentation(locale, annotationContext);
                annotation.addChild(documentation);
                documentable = SchemaElementFactory.createBpmoDocumentable(documentation.getNSContext());
                ((DefaultElement)documentation).addChild(documentable);
                documentableMap.put(locale, documentable);
            }
            doc = SchemaElementFactory.createBpmoUseCase(text, documentable.getNSContext());
            documentable.addChild(doc);
        }
        return annotation;
    }

    private static void buildDescriptions(TypeDescription td, DefaultElement annotation) {
        DescriptionEnabled de;
        String description;
        Documentation documentation = SchemaElementFactory.createDocumentation(null, annotation.getNSContext());
        BpmoDocumentable documentable = SchemaElementFactory.createBpmoDocumentable(documentation.getNSContext());
        ((DefaultElement)documentation).addChild(documentable);
        if (td instanceof DescriptionEnabled && !Str.isEmpty((String)(description = (de = (DescriptionEnabled)td).getDescription()))) {
            BpmoDescription desc = SchemaElementFactory.createBpmoDescription(description, documentable.getNSContext());
            documentable.addChild(desc);
        }
        if (td.isMethod()) {
            MethodTypeDescription mtd = td.asMethod();
            for (Argument argument : mtd.getArguments()) {
                String description2 = argument.getDescription();
                if (Str.isEmpty((String)description2)) continue;
                BpmoArgumentDoc argDoc = SchemaElementFactory.createBpmoArgumentDoc(argument, documentable.getNSContext());
                documentable.addChild(argDoc);
            }
            Argument resultArgument = mtd.getResultArgument();
            String description3 = resultArgument.getDescription();
            if (!Str.isEmpty((String)description3)) {
                BpmoArgumentDoc argDoc = SchemaElementFactory.createBpmoArgumentDoc(resultArgument, documentable.getNSContext());
                documentable.addChild(argDoc);
            }
        }
        if (documentable.hasChilds()) {
            annotation.addChild(documentation);
        }
    }

    private String getBpmoProcessingInstructionLine() {
        return String.format("<?bpmo version=\"%s\" build=\"%s\" fullName=\"%s\" modifiers=\"%s\"?>\n", Id.getAbsoluteVersion(), Id.getBuildNumber(), this.xotd.getText(), this.xotd.getModifiers());
    }
}

