/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.recognizer;

import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.catalog.recognizer.FileHeader;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.recognizer.ResourceTypeRecognizer;
import org.jetbrains.annotations.NotNull;

public class MutableModuleRecognizer
implements ResourceTypeRecognizer {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ResourceType getResourceType() {
        ResourceType resourceType = ResourceType.MUTABLE_MODULE;
        if (resourceType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/MutableModuleRecognizer.getResourceType must not return null");
        }
        return resourceType;
    }

    @Override
    public boolean recognizeByFileExtension(@NotNull FileHeader resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/MutableModuleRecognizer.recognizeByFileExtension must not be null");
        }
        return false;
    }

    @Override
    public boolean recognizeResource(@NotNull FileHeader resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/MutableModuleRecognizer.recognizeResource must not be null");
        }
        VFile vFile = resource.getFile();
        boolean folder = !vFile.isFile();
        return vFile.getCanonicalPath().startsWith("/businessCatalog/") && folder;
    }
}

