/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SimpleType;
import oracle.bpm.type.TypeFactory;
import org.jetbrains.annotations.NotNull;

class Union
extends SchemaElement {
    Union() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        TypeDescription promotion = null;
        ArrayList<TypeDescription> members = new ArrayList<TypeDescription>();
        String memberTypes = this.getMemberTypes();
        if (memberTypes != null) {
            StringTokenizer ms = new StringTokenizer(memberTypes);
            while (ms.hasMoreTokens()) {
                String text = ms.nextToken();
                members.add(this.findType(text));
            }
        }
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            if (!(element instanceof SimpleType)) continue;
            members.add(element.buildType(current));
        }
        for (TypeDescription member : members) {
            if (promotion == null) {
                promotion = member;
                continue;
            }
            if (member == null) continue;
            if (member.isNumber() && promotion.isNumber()) {
                promotion = promotion.promote(member);
                continue;
            }
            if (member.isPredefined() && promotion.isPredefined()) {
                promotion = TypeFactory.getString();
                continue;
            }
            promotion = promotion.promote(member);
        }
        TypeDescription typeDescription = SimpleType.ensureIsSimple(promotion);
        if (typeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Union.buildType must not return null");
        }
        return typeDescription;
    }

    String getMemberTypes() {
        return this.getAttribute("memberTypes");
    }
}

