/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.Parser;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.ElementRootDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidRootException;
import oracle.bpm.project.catalog.xmltype.EntityResolver;
import oracle.bpm.project.catalog.xmltype.ImportType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaParser
extends Parser {
    private ComponentCatalog catalog;
    private boolean dumpTree;
    private final VFileSystem fileSystem;
    private Context parentCtx;
    private final Set<SchemaElement> pendingElementsBuild;
    private EntityResolver resolver;
    private boolean secondPass;
    private boolean twoPassBuild;
    private final TypeIndex typeFinder;

    public SchemaParser(@NotNull VFileSystem vFileSystem, @NotNull TypeIndex typeFinder) {
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaParser.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaParser.<init> must not be null");
        }
        this.fileSystem = vFileSystem;
        this.typeFinder = typeFinder;
        super.setElementFactory(new SchemaElementFactory());
        this.pendingElementsBuild = new HashSet<SchemaElement>();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VFileSystem getFileSystem() {
        VFileSystem vFileSystem = this.fileSystem;
        if (vFileSystem == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/SchemaParser.getFileSystem must not return null");
        }
        return vFileSystem;
    }

    @Override
    public void startElement(String namespace, String name, String qualifiedName, Attributes attrs) throws SAXException {
        Element element = this.peek();
        boolean isRoot = element instanceof Schema;
        super.startElement(namespace, name, qualifiedName, attrs);
        if (isRoot && this.peek() instanceof ElementDef) {
            Element defaultElement = this.pop();
            ElementRootDef elementDefRoot = new ElementRootDef((ElementDef)defaultElement);
            Element parent = this.peek();
            if (parent != null) {
                parent.addChild(elementDefRoot);
            }
            this.push(elementDefRoot);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeIndex getTypeFinder() {
        TypeIndex typeIndex = this.typeFinder;
        if (typeIndex == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/SchemaParser.getTypeFinder must not return null");
        }
        return typeIndex;
    }

    public void setCatalog(ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    public ComponentCatalog getCatalog() {
        return this.catalog;
    }

    public Schema parseSchema(URL location, InputStream source) throws TypeParseException {
        SchemaElement root = (SchemaElement)super.parse(location, source);
        if (!(root instanceof Schema)) {
            throw new InvalidRootException(location, root.getTagName());
        }
        return (Schema)root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Schema parse(@NotNull URI uri) throws TypeParseException {
        Schema schema;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaParser.parse must not be null");
        }
        InputStream source = null;
        try {
            EntityResolver resolver = this.getXsdImportResolver();
            if (resolver != null) {
                source = resolver.resolveEntity(null, uri.toString(), null, ImportType.IMPORT_TYPE_XSD10);
            }
            URL location = URLHelper.createURL((URI)uri);
            if (source == null) {
                source = URLHelper.openStream((URL)location);
            }
            Schema schema2 = this.parseSchema(location, source);
            schema2.setLocation(location);
            schema = schema2;
        }
        catch (IOException e) {
            try {
                throw new TypeParseException(uri, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{source});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{source});
        Schema schema3 = schema;
        if (schema3 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/SchemaParser.parse must not return null");
        }
        return schema3;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Schema compile(@NotNull URL location, @Nullable InputStream source) throws TypeParseException {
        Schema schema;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SchemaParser.compile must not be null");
        }
        try {
            if (source == null) {
                source = location.openStream();
            }
            Schema schema2 = this.parseSchema(location, source);
            if (this.dumpTree) {
                schema2.dump(new IndentedPrintWriter((OutputStream)System.out, true), "utf-8");
            }
            schema2.declare();
            schema2.buildType(null);
            ExtendedNamespace target = schema2.getContext().getTarget();
            ArrayList<TypeDescription> types = new ArrayList<TypeDescription>();
            types.addAll(target.getAllDefinedTypes());
            types.addAll(target.getDefinedElements());
            String relativePath = URLHelper.getResourceLocation((URL)location);
            for (TypeDescription type : types) {
                Utils.fixResourceLocation(location, relativePath, type);
            }
            schema = schema2;
        }
        catch (IOException e) {
            try {
                throw new TypeParseException(location, e);
                catch (TypeBuildException e2) {
                    throw TypeParseException.wrap(e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{source});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{source});
        Schema schema3 = schema;
        if (schema3 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/SchemaParser.compile must not return null");
        }
        return schema3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ExtendedNamespace importSchema(Context ctx, URL location, InputStream reader) throws TypeParseException {
        Schema result = this.compile(location, reader);
        ExtendedNamespace ns = result.getContext().getTarget();
        ctx.setNamespace(ns);
        ExtendedNamespace extendedNamespace = ns;
        if (extendedNamespace == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/SchemaParser.importSchema must not return null");
        }
        return extendedNamespace;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.parentCtx != null) {
            this.pushContext(this.parentCtx);
            this.parentCtx = null;
        }
    }

    public void setXsdImportResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public EntityResolver getXsdImportResolver() {
        return this.resolver;
    }

    public void addPendingElementBuild(SchemaElement element) {
        this.pendingElementsBuild.add(element);
    }

    public Set<SchemaElement> getPendingElementsBuild() {
        return this.pendingElementsBuild;
    }

    public void setSecondPass(boolean secondPass) {
        this.secondPass = secondPass;
    }

    public boolean isSecondPass() {
        return this.secondPass;
    }

    public void setTwoPassBuild(boolean twoPassBuild) {
        this.twoPassBuild = twoPassBuild;
    }

    public boolean isTwoPassBuild() {
        return this.twoPassBuild;
    }

    protected void setDumpTree(boolean dumpTree) {
        this.dumpTree = dumpTree;
    }

    @Override
    protected NamespaceContext createContext(NamespaceContext parent) {
        return new Context(parent);
    }
}

