/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.lang.DescriptionEnabled;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.Text;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.type.parser.BpmoArgumentDoc;
import oracle.bpm.project.catalog.type.parser.BpmoDescription;
import oracle.bpm.project.catalog.type.parser.BpmoDocumentable;
import oracle.bpm.project.catalog.type.parser.BpmoDocumentation;
import oracle.bpm.project.catalog.type.parser.BpmoUseCaseDoc;
import oracle.bpm.util.documentation.DocumentationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Documentation
extends SchemaElement {
    private String doc;

    @Override
    public void addChild(Element element) {
        if (element instanceof Text) {
            Text text = (Text)element;
            this.doc = text.getContent();
            if (this.doc != null) {
                this.doc = this.doc.trim();
            }
        } else {
            super.addChild(element);
        }
    }

    public void setLang(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Documentation.setLang must not be null");
        }
        this.setAttribute("xml:lang", locale.getLanguage());
    }

    @Override
    public void setAttributes(Map<QName, String> attributes) {
        for (Map.Entry<QName, String> entry : attributes.entrySet()) {
            QName qName = entry.getKey();
            String localPart = qName.getLocalPart();
            String prefix = qName.getPrefix();
            if (localPart != null && localPart.equals("lang") && prefix != null && prefix.equals("xml")) {
                this.setAttribute("xml:lang", entry.getValue());
                continue;
            }
            this.setAttribute(qName, entry.getValue());
        }
    }

    @Nullable
    public Locale getLocale() {
        String lang = this.getLang();
        if (!Str.isEmpty((String)lang)) {
            return new Locale(lang);
        }
        return null;
    }

    public void buildBpmoDocumentation(TypeDescription td) {
        List<BpmoDocumentable> documentables = this.findChildrenByClass(BpmoDocumentable.class);
        if (documentables.size() == 1) {
            BpmoDocumentable bpmoDocumentable = documentables.get(0);
            Locale locale = this.getLocale();
            for (DefaultElement current = bpmoDocumentable.getFirstElement(); current != null; current = current.getNextElement()) {
                if (current instanceof BpmoDescription && td instanceof DescriptionEnabled) {
                    this.buildBpmoDescription(td, current);
                    continue;
                }
                if (current instanceof BpmoDocumentation && locale != null) {
                    this.buildBpmoDocumentationDoc(td, locale, current);
                    continue;
                }
                if (current instanceof BpmoArgumentDoc && td.isMethod()) {
                    this.buildBpmoArgumentDoc(td, current);
                    continue;
                }
                if (!(current instanceof BpmoUseCaseDoc) || locale == null) continue;
                this.buildBpmoUseCaseDoc(td, locale, current);
            }
        }
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) {
        if (this.doc != null && current != null && (current.isObject() || current.isEnum())) {
            current.asObject().setDescription(this.doc);
        }
        return current;
    }

    String getLang() {
        return this.getAttribute("xml:lang");
    }

    private void buildBpmoDescription(TypeDescription td, DefaultElement current) {
        BpmoDescription bpmoDescription = (BpmoDescription)current;
        DescriptionEnabled descriptionEnabled = (DescriptionEnabled)td;
        descriptionEnabled.setDescription(bpmoDescription.getDocText());
    }

    private void buildBpmoDocumentationDoc(TypeDescription td, Locale locale, DefaultElement current) {
        BpmoDocumentation bpmoDocumentation = (BpmoDocumentation)current;
        td.setDocumentation(DocumentationType.DOCUMENTATION, locale, bpmoDocumentation.getDocText());
    }

    private void buildBpmoUseCaseDoc(TypeDescription td, Locale locale, DefaultElement current) {
        BpmoUseCaseDoc bpmoUseCaseDoc = (BpmoUseCaseDoc)current;
        td.setDocumentation(DocumentationType.USE_CASE_DOCUMENTATION, locale, bpmoUseCaseDoc.getDocText());
    }

    private void buildBpmoArgumentDoc(TypeDescription td, DefaultElement current) {
        BpmoArgumentDoc bpmoArgumentDoc = (BpmoArgumentDoc)current;
        MethodTypeDescription mtd = td.asMethod();
        String name = bpmoArgumentDoc.getArgumentName();
        if (name.equals("return")) {
            mtd.getResultArgument().setDescription(bpmoArgumentDoc.getDocText());
        } else {
            int i = mtd.getArgument(name);
            if (i != -1) {
                mtd.getArgument(i).setDescription(bpmoArgumentDoc.getDocText());
            }
        }
    }
}

