/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.AttributeGroup;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Group;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.project.catalog.parser.xsd.SOAPNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.AttrGroupNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.ComplexTypeNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.GroupNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.NamespaceNotDeclaredException;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Context
extends NamespaceContext {
    private Set<String> knownSchemas;
    private Set<ObjectTypeDescription> parentTypes = new LinkedHashSet<ObjectTypeDescription>();
    private ExtendedNamespace target;
    static final long serialVersionUID = 9006533596340729406L;
    static final long serialCheck = -3552654455036422276L;

    public Context(NamespaceContext parent) {
        super(parent);
    }

    public void addParentType(TypeDescription td) {
        if (td.isObject()) {
            this.parentTypes.add(td.asObject());
        }
    }

    @Nullable
    public ObjectTypeDescription getParentType() {
        return (ObjectTypeDescription)CollectionUtils.last(this.parentTypes);
    }

    public String buildParentFullName() {
        String result = null;
        for (ObjectTypeDescription otd : this.parentTypes) {
            String name = otd.getNativeName();
            if (name == null) continue;
            if (result == null) {
                result = name;
                continue;
            }
            result = result + "." + name;
        }
        return result;
    }

    public void removeParentType(TypeDescription type) {
        if (type.isObject()) {
            this.parentTypes.remove(type.asObject());
        }
    }

    public void setTarget(String uri) {
        this.target = (ExtendedNamespace)this.findNamespaceByUri(uri);
        if (this.target == null) {
            this.target = new ExtendedNamespace(uri);
            ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace("");
            if (ns != null) {
                this.target.setDefault(ns);
            } else {
                this.addNamespace("", this.target);
            }
        }
    }

    public void setTarget(ExtendedNamespace target) {
        this.target = target;
    }

    public ExtendedNamespace getTarget() {
        this.findParentTarget();
        return this.target;
    }

    public boolean isTarget() {
        this.findParentTarget();
        return this.target != null;
    }

    @Override
    public void addNamespace(String prefix, String uri) {
        Namespace ns;
        ExtendedNamespace target = this.getTarget();
        if (target != null && uri.equals(target.getUri())) {
            ns = target;
        } else if (SFSNamespace.isSFS(uri)) {
            ns = SFSNamespace.get(uri);
        } else if (SOAPNamespace.isSOAPSchema(uri)) {
            ns = SOAPNamespace.get(uri);
        } else {
            ns = this.findNamespaceByUri(uri);
            if (ns == null) {
                ns = new ExtendedNamespace(uri);
            }
        }
        this.addNamespace(prefix, ns);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public TypeDescription lookupAttributeGroupType(@NotNull TypeIndex finder, @NotNull String qname) throws ContextLookupException, TypeBuildException {
        if (finder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupAttributeGroupType must not be null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupAttributeGroupType must not be null");
        }
        TypeDescription result = null;
        try {
            AttributeGroup attributeGroup = this.lookupAttributeGroup(qname);
            result = attributeGroup.buildType(null);
        }
        catch (ContextLookupException ignored) {
            // empty catch block
        }
        if (result == null) {
            result = this.lookupTypeDescriptionFromPointer(finder, qname, XmlElementType.ATTGROUP);
        }
        if (result == null) {
            throw new AttrGroupNotFoundException(qname, this.lookupNamespace(qname));
        }
        TypeDescription typeDescription = result;
        if (typeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Context.lookupAttributeGroupType must not return null");
        }
        return typeDescription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public TypeDescription lookupGroupType(@NotNull TypeIndex finder, @NotNull String qname) throws ContextLookupException, TypeBuildException {
        if (finder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupGroupType must not be null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupGroupType must not be null");
        }
        TypeDescription result = null;
        try {
            Group group = this.lookupGroup(qname);
            result = group.buildType(null);
        }
        catch (ContextLookupException ignored) {
            // empty catch block
        }
        if (result == null) {
            result = this.lookupTypeDescriptionFromPointer(finder, qname, XmlElementType.GROUP);
        }
        if (result == null) {
            throw new GroupNotFoundException(qname, this.lookupNamespace(qname));
        }
        TypeDescription typeDescription = result;
        if (typeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Context.lookupGroupType must not return null");
        }
        return typeDescription;
    }

    public ExtendedNamespace lookupNamespace(String qname) {
        String prefix = Context.prefix(qname);
        return (ExtendedNamespace)this.findNamespace(prefix);
    }

    public TypeRef lookupTypeDynamicRef(@NotNull String qname, @NotNull ComponentCatalog catalog) throws TypeBuildException, ContextLookupException {
        TypeDescription result;
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeDynamicRef must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeDynamicRef must not be null");
        }
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        String namespace = ns.getUri();
        if (SFSNamespace.isSFS(namespace) || SOAPNamespace.isSOAPSchema(namespace)) {
            SchemaElement schemaElement = ns.lookupType(name);
            result = schemaElement.getTypeDescription();
        } else {
            XmlUUID id = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)namespace, (String)name);
            result = new DynamicRef(id, name, catalog);
        }
        return result;
    }

    public TypeRef lookupTypeRef(@NotNull String qname, @NotNull ComponentCatalog catalog) throws ContextLookupException, TypeBuildException {
        TypeDescription result;
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeRef must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeRef must not be null");
        }
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        String namespace = ns.getUri();
        if (SFSNamespace.isSFS(namespace) || SOAPNamespace.isSOAPSchema(namespace)) {
            SchemaElement schemaElement = ns.lookupType(name);
            result = schemaElement.getTypeDescription();
        } else {
            result = this.lookupRef(qname, catalog, XmlElementType.TYPE);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeRef lookupRef(@NotNull String qname, @NotNull ComponentCatalog catalog, @NotNull XmlElementType xmlElementType) throws NamespaceNotDeclaredException {
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupRef must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupRef must not be null");
        }
        if (xmlElementType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupRef must not be null");
        }
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        String namespace = ns.getUri();
        XmlUUID id = UUIDFactory.createXmlId((XmlElementType)xmlElementType, (String)namespace, (String)name);
        BpmObjectDynamicRef bpmObjectDynamicRef = new BpmObjectDynamicRef(id.getId(), name, catalog);
        if (bpmObjectDynamicRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Context.lookupRef must not return null");
        }
        return bpmObjectDynamicRef;
    }

    public TypeRef lookupAttributeRef(@NotNull String qname, @NotNull ComponentCatalog catalog) throws NamespaceNotDeclaredException {
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupAttributeRef must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupAttributeRef must not be null");
        }
        return this.lookupRef(qname, catalog, XmlElementType.ATTRIBUTE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeRef lookupElementRef(@NotNull String qname, @NotNull ComponentCatalog catalog) throws NamespaceNotDeclaredException {
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupElementRef must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupElementRef must not be null");
        }
        TypeRef typeRef = this.lookupRef(qname, catalog, XmlElementType.ELEMENT);
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Context.lookupElementRef must not return null");
        }
        return typeRef;
    }

    public SchemaElement lookupType(String qname) throws NamespaceNotDeclaredException, ComplexTypeNotFoundException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        return ns.lookupType(name);
    }

    public void setKnownSchemas(Set<String> knownSchemas) {
        this.knownSchemas = knownSchemas;
    }

    public boolean isKnownSchema(String namespace) {
        boolean ret = false;
        if (this.knownSchemas != null) {
            ret = this.knownSchemas.contains(namespace);
        } else {
            boolean knownSchemasFound = false;
            Context contxParent = (Context)this.getParent();
            while (contxParent != null && !knownSchemasFound) {
                if (contxParent.knownSchemas != null) {
                    ret = contxParent.knownSchemas.contains(namespace);
                    knownSchemasFound = true;
                }
                if (contxParent.getParent() != null) {
                    contxParent = (Context)contxParent.getParent();
                    continue;
                }
                contxParent = null;
            }
        }
        return ret;
    }

    void setNamespace(@NotNull ExtendedNamespace ns) {
        if (ns == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.setNamespace must not be null");
        }
        Map<String, Namespace> byURI = this.getDeclaredNamespaces();
        byURI.put(ns.getUri(), ns);
    }

    private static String localname(String qname) {
        int index = qname.indexOf(58);
        if (index != -1) {
            qname = qname.substring(index + 1);
        }
        return qname;
    }

    private static String prefix(String qname) {
        int index = qname.indexOf(58);
        String prefix = "";
        if (index != -1) {
            prefix = qname.substring(0, index);
        }
        return prefix;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private AttributeGroup lookupAttributeGroup(String qname) throws AttrGroupNotFoundException, NamespaceNotDeclaredException {
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        AttributeGroup attributeGroup = ns.lookupAttributeGroup(name);
        if (attributeGroup == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Context.lookupAttributeGroup must not return null");
        }
        return attributeGroup;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Group lookupGroup(@NotNull String qname) throws ContextLookupException {
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupGroup must not be null");
        }
        String prefix = Context.prefix(qname);
        String name = Context.localname(qname);
        ExtendedNamespace ns = (ExtendedNamespace)this.findNamespace(prefix);
        if (ns == null) {
            throw new NamespaceNotDeclaredException(prefix);
        }
        Group group = ns.lookupGroup(name);
        if (group == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/xsd/Context.lookupGroup must not return null");
        }
        return group;
    }

    private TypeDescription lookupTypeDescriptionFromPointer(@NotNull TypeIndex finder, @NotNull String qname, @NotNull XmlElementType elementType) {
        if (finder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeDescriptionFromPointer must not be null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeDescriptionFromPointer must not be null");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/Context.lookupTypeDescriptionFromPointer must not be null");
        }
        TypeDescription result = null;
        Namespace namespace = this.findNamespace(Context.prefix(qname));
        String uri = "";
        if (namespace != null) {
            uri = namespace.getUri();
        }
        XmlUUID id = UUIDFactory.createXmlId((XmlElementType)elementType, (String)uri, (String)Context.localname(qname));
        TypeRef typeRef = finder.findById(ComponentType.XML.getText(), id.getId());
        if (typeRef != null) {
            TypeRef realType;
            TypeDescription type = typeRef.get();
            result = type.isXmlObject() ? ((realType = (TypeRef)type.asObject().getTransientProperty("real.type")) != null ? realType.get() : type) : type;
        }
        return result;
    }

    private void findParentTarget() {
        Context parent;
        if (this.target == null && (parent = (Context)this.getParent()) != null) {
            this.target = parent.getTarget();
        }
    }
}

