/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.ArrayList;
import oracle.bpm.bpmobject.XMLSignatureParser;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.Particle;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.Nullable;

class Choice
extends Particle {
    Choice() {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        AttrGroupTypeDescription group = super.buildAttributes(current, true);
        if (this.getMaxOccurs() > 1) {
            AttributeTypeDescription[] attributes = group.getAttributes();
            ArrayList<AttributeTypeDescription> newAttributes = new ArrayList<AttributeTypeDescription>();
            for (AttributeTypeDescription attribute : attributes) {
                if (!attribute.getResultType().isArray()) {
                    AttributeTypeDescription attr = attribute.clone();
                    attr.setType((TypeRef)TypeFactory.createArray((TypeRef)attr.getTypeRef()));
                    String signature = attr.getReadSignature();
                    signature = 'N' + signature.substring(1);
                    signature = XMLSignatureParser.replaceAttributeType((String)signature, (String)Choice.buildSignature(attr.getType()));
                    attr.setReadSignature(signature);
                    attr.setWriteSignature(signature);
                    newAttributes.add(attr);
                    continue;
                }
                newAttributes.add(attribute);
            }
            group = new AttrGroupTypeDescription(newAttributes);
        }
        return group;
    }
}

