/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.ArrayList;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.exception.AttrGroupNotFoundException;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import org.jetbrains.annotations.Nullable;

class AttributeGroup
extends SchemaElement {
    AttributeGroup() {
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        if (this.type != null) {
            return this.type;
        }
        String ref = this.getRef();
        if (ref != null) {
            try {
                current = this.getContext().lookupAttributeGroupType(this.getSchemaParser().getTypeFinder(), ref);
            }
            catch (ContextLookupException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        } else {
            ArrayList<TypeDescription> group = new ArrayList<TypeDescription>();
            for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
                TypeDescription attribute = element.buildType((TypeDescription)current);
                if (attribute == null || !attribute.isAttribute()) continue;
                group.add(attribute);
            }
            ExtendedNamespace currentNamespace = this.getContext().getTarget();
            String namespace = currentNamespace.getUri();
            AttrGroupTypeDescription attGroup = new AttrGroupTypeDescription(group);
            attGroup.setName(this.getName());
            attGroup.setNamespace(namespace);
            current = attGroup;
        }
        this.type = current;
        return current;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        try {
            if (name != null) {
                this.getTarget().declareAttributeGroup(name, this);
            }
        }
        catch (InvalidLocalNameException e) {
            throw TypeNotFoundException.wrap(e, (DefaultElement)this);
        }
        catch (UnsupportedOperationException e) {
            throw TypeNotFoundException.wrap(new AttrGroupNotFoundException(name, this.getTarget()), (DefaultElement)this);
        }
    }

    String getName() {
        return this.getAttribute("name");
    }

    String getRef() {
        return this.getAttribute("ref");
    }
}

