/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.xml.XmlWriter;

public class Text
extends DefaultElement {
    private String content;

    public Text(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return this.content;
    }

    @Override
    public void generateXml(XmlWriter xml) throws IOException {
        String content = this.getContent();
        if (content != null) {
            xml.printChars(content.trim(), false, true, false);
        }
    }

    @Override
    protected void dumpWrite(IndentedPrintWriter out, boolean root, String[] processingInstructions, NamespaceContext currentCtx, String encoding, DefaultElement.DumpParameters parameters) {
        String content = this.getContent();
        if (content != null) {
            String text = Str.toXMLString((String)content.trim(), (CharsetEncoder)Charset.forName(encoding).newEncoder());
            this.writeMultilineIndented(out, parameters, text);
        }
    }

    protected void writeMultilineIndented(IndentedPrintWriter out, DefaultElement.DumpParameters parameters, String text) {
        if (parameters.isPrintIndented()) {
            String[] lines;
            for (String line : lines = text.split("\r\n|\r|\n")) {
                out.println(line);
            }
        } else {
            out.println(text);
        }
    }
}

