/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.type.catalog.ComponentBundle;
import org.jetbrains.annotations.NotNull;

public class ParserContext {
    private Set<String> bundles;
    private Map<URI, ServiceDefinition> parsedWsdlFiles = new HashMap<URI, ServiceDefinition>();

    public ParserContext() {
        this.bundles = new HashSet<String>();
    }

    public void init(ComponentBundle bundle) {
        String bundleId = bundle.getUniqueId();
        if (this.bundles.contains(bundleId)) {
            this.clean();
        }
        this.bundles.add(bundleId);
    }

    public ServiceDefinition getServiceDefinition(URI uri) {
        uri = uri.normalize();
        return this.parsedWsdlFiles.get(uri);
    }

    public void addParsedWsdlFile(URI uri, ServiceDefinition serviceDefinition) {
        uri = uri.normalize();
        this.parsedWsdlFiles.put(uri, serviceDefinition);
    }

    public void clean() {
        this.parsedWsdlFiles = new HashMap<URI, ServiceDefinition>();
        this.bundles = new HashSet<String>();
    }

    public void removeParsedFile(@NotNull URI location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/ParserContext.removeParsedFile must not be null");
        }
        this.parsedWsdlFiles.remove(location);
    }
}

