/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.Text;
import oracle.bpm.xml.XmlWriter;

public class CData
extends Text {
    public CData(String content) {
        super(content);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<![CDATA[");
        builder.append(this.getContent().trim());
        builder.append("]]>");
        return builder.toString();
    }

    @Override
    public void generateXml(XmlWriter xml) throws IOException {
        String content = this.getContent();
        if (content != null) {
            xml.printCDATA(content.trim(), false, true);
        }
    }

    @Override
    protected void dumpWrite(IndentedPrintWriter out, boolean root, String[] processingInstructions, NamespaceContext currentCtx, String encoding, DefaultElement.DumpParameters parameters) {
        String content = this.getContent();
        CharsetEncoder charsetEncoder = Charset.forName(encoding).newEncoder();
        int i = content.indexOf("]]>");
        if (i != -1) {
            String escaped = Str.toXMLString((String)"]]>", (CharsetEncoder)charsetEncoder);
            content = content.replaceAll("]]>", escaped);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<![CDATA[");
        builder.append(content.trim());
        builder.append("]]>");
        this.writeMultilineIndented(out, parameters, builder.toString());
    }
}

