/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.exception.SchemaBuildException;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.exception.XsdTypeBuildException;

public class TypeDefinition
extends WsdlElement {
    private ExtendedNamespace[] targets;

    public List<Schema> getSchemas() {
        return this.findChildrenByClass(Schema.class);
    }

    ExtendedNamespace[] getTargets() {
        return this.targets;
    }

    void buildTypes() throws TypeBuildException {
        if (this.targets != null) {
            return;
        }
        ArrayList<Schema> declared = new ArrayList<Schema>();
        ArrayList<ExtendedNamespace> targets = new ArrayList<ExtendedNamespace>();
        Set<String> declaredNamespaces = this.getDeclaredSchemas();
        for (Schema schema : this.getSchemas()) {
            String tns = schema.getTargetNamespace();
            Context ctx = schema.getContext();
            HashSet<String> alreadyImported = new HashSet<String>(declaredNamespaces);
            alreadyImported.remove(tns);
            ctx.setKnownSchemas(alreadyImported);
            if (tns != null && SFSNamespace.isSFS(tns)) {
                this.reportWarning("Schema for XMLSchema should not be defined here, ignoring it...");
                continue;
            }
            if (tns != null) {
                ctx.setTarget(tns);
            }
            targets.add(ctx.getTarget());
            schema.setLocation(this.getServiceDefinitionLocation());
            try {
                schema.declare();
            }
            catch (XsdTypeBuildException e) {
                throw new SchemaBuildException(this, e);
            }
            declared.add(schema);
        }
        for (int i = 0; i < declared.size(); ++i) {
            Schema schema;
            schema = (Schema)declared.get(i);
            ExtendedNamespace target = (ExtendedNamespace)targets.get(i);
            schema.getContext().setTarget(target);
            schema.buildType(null);
        }
        this.targets = targets.toArray(new ExtendedNamespace[targets.size()]);
    }

    URL getServiceDefinitionLocation() {
        URL location = null;
        ServiceDefinition serviceDefinition = this.findAncestorByClass(ServiceDefinition.class);
        if (serviceDefinition != null) {
            location = serviceDefinition.getLocation();
        }
        return location;
    }

    private Set<String> getDeclaredSchemas() {
        HashSet<String> ret = new HashSet<String>();
        for (Schema schema : this.getSchemas()) {
            ret.add(schema.getTargetNamespace());
        }
        return ret;
    }
}

