/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Part
extends WsdlElement {
    public Part() {
        this.setTagName("part");
    }

    public String getElement() {
        return this.getAttribute("element");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setElement(String value) {
        this.setAttribute("element", value);
    }

    public void setName(String value) {
        this.setAttribute("name", value);
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        URL location = this.getServiceDefinition().getLocation();
        if (this.getName() == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("name", "part"));
        }
        if (this.getType() == null && this.getElement() == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("type", "message"));
        }
    }

    String getType() {
        return this.getAttribute("type");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    Argument buildArg() throws TypeBuildException {
        String type = this.getType();
        String element = this.getElement();
        TypeRef argType = this.resolveType(type, element);
        String name = this.getName();
        if ("return".equals(name)) {
            name = "result";
        }
        Argument arg = new Argument(Identifier.argument((String)name), argType, 0L);
        arg.setProperty("nativeName", this.getName());
        arg.setProperty("partName", this.getName());
        Argument argument = arg;
        if (argument == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Part.buildArg must not return null");
        }
        return argument;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private TypeRef resolveType(@Nullable String type, @Nullable String element) throws TypeBuildException {
        TypeRef result;
        block5: {
            result = null;
            ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
            try {
                if (type != null) {
                    result = this.getContext().lookupTypeRef(type, catalog);
                    break block5;
                }
                if (element != null) {
                    result = this.getContext().lookupElementRef(element, catalog);
                }
            }
            catch (ContextLookupException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
        TypeRef typeRef = result;
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Part.resolveType must not return null");
        }
        return typeRef;
    }
}

