/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.List;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.exception.MessageNotFoundException;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.utils.WsdlUtils;
import oracle.bpm.type.Argument;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class Input
extends WsdlElement {
    private Argument[] args;
    private Message msg;

    public Input() {
        this.setTagName("input");
    }

    public String getMessage() {
        return this.getAttribute("message");
    }

    public void setMessage(String message) {
        this.setAttribute("message", message);
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        String msgId = this.getMessage();
        URL location = this.getServiceDefinition().getLocation();
        if (msgId == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("message", "input"));
        }
    }

    public List<Argument> buildBpmObjectArguments() throws TypeBuildException {
        List<Argument> args = this.msg.buildBpmObjectArguments();
        for (Argument arg : args) {
            arg.setModifiers(arg.getModifiers() | 1L);
        }
        this.setMsg(this.msg);
        return args;
    }

    void setArgs(Argument[] args) {
        this.args = args;
    }

    Argument[] getArgs() {
        return this.args;
    }

    void setMsg(Message msg) {
        this.msg = msg;
    }

    Message getMsg() {
        return this.msg;
    }

    @Override
    void bind(Operation operation) throws TypeBuildException {
        super.bindInput(operation);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    List<Argument> buildArguments() throws TypeBuildException {
        String msgId = this.getMessage();
        Message msg = this.getServiceDefinition().getMessage(msgId);
        if (msg == null) {
            Operation operation = (Operation)this.getParent();
            throw new MessageNotFoundException(this, msgId, operation);
        }
        List<Argument> args = msg.buildArguments();
        for (Argument arg : args) {
            arg.setModifiers(arg.getModifiers() | 1L);
        }
        if (args.size() == 1) {
            Argument argument = args.get(0);
            String typeName = WsdlUtils.buildArgumentNameFromType(argument.getTypeRef());
            argument.setName(Identifier.argument((String)typeName));
        }
        this.setMsg(msg);
        List<Argument> list = args;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Input.buildArguments must not return null");
        }
        return list;
    }
}

