/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.LoaderUtils;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.TypeDefinition;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceDefinitionParsedObject
extends ParsedObject<ServiceDefinition> {
    private Set<Dependency> dependencies;

    public ServiceDefinitionParsedObject(@NotNull URI uri, @Nullable ServiceDefinition parsedData) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/ServiceDefinitionParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.dependencies = this.parseDependencies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/ServiceDefinitionParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Set<Dependency> parseDependencies() throws TypeParseException {
        TreeSet<Dependency> result = new TreeSet<Dependency>();
        ServiceDefinition serviceDefinition = (ServiceDefinition)this.getParsedData();
        List<Import> imports = serviceDefinition.findChildrenByClass(Import.class);
        for (Import anImport : imports) {
            String location = anImport.getLocation();
            URI uri = this.getUri().resolve(location);
            result.add(new Dependency(uri, ResourceType.WSDL));
        }
        List<TypeDefinition> types = serviceDefinition.findChildrenByClass(TypeDefinition.class);
        for (TypeDefinition type : types) {
            List<Schema> schemas = type.getSchemas();
            for (Schema schema : schemas) {
                result.addAll(LoaderUtils.findSchemaDependencies(this.getUri(), schema));
            }
        }
        TreeSet<Dependency> treeSet = result;
        if (treeSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/ServiceDefinitionParsedObject.parseDependencies must not return null");
        }
        return treeSet;
    }
}

